/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.SignalListeners;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Signal
extends Control
implements SignalService {
    private SignalListener signalListener;

    public Signal(String key) {
        super(key);
    }

    public synchronized void addSignalListener(SignalListener signalListener) {
        this.setSignalListener(SignalListeners.add(this.getSignalListener(), signalListener));
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireErrorOccurred(signalListener, Signal.getCurrentTimestamp(), data);
        }
    }

    protected void fireErrorOccurred(SignalListener signalListener, Object timestamp, Object data) {
        try {
            signalListener.errorOccurred((Object)this, timestamp, data);
        }
        catch (RuntimeException exception) {
            this.log(exception, 1);
        }
    }

    public void fireSignalOccurred(SignalListener signalListener, Object timestamp) {
        this.fireSignalOccurred(signalListener, timestamp, null);
    }

    public void fireSignalOccurred(SignalListener signalListener, Object timestamp, ChannelService channel) {
        if (signalListener != null) {
            try {
                if (signalListener instanceof MultiplexSignalListener || channel != null) {
                    ((MultiplexSignalListener)signalListener).signalOccurred((SignalService)this, timestamp, channel, null);
                } else {
                    signalListener.signalOccurred((SignalService)this, timestamp, null);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void fireSignalOccurred(SignalListener signalListener, Object timestamp, ChannelService channel, Object data) {
        if (signalListener != null) {
            try {
                if (signalListener instanceof MultiplexSignalListener || channel != null) {
                    ((MultiplexSignalListener)signalListener).signalOccurred((SignalService)this, timestamp, channel, data);
                } else {
                    signalListener.signalOccurred((SignalService)this, timestamp, data);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void fireSignalOccurred(SignalListener signalListener, Object timestamp, Object data) {
        this.fireSignalOccurred(signalListener, timestamp, null, data);
    }

    protected SignalListener getSignalListener() {
        return this.signalListener;
    }

    public synchronized void removeSignalListener(SignalListener signalListener) {
        this.setSignalListener(SignalListeners.remove(this.getSignalListener(), signalListener));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        super.reportError(errorNumber, error, errorObjects);
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireErrorOccurred(signalListener, Signal.getCurrentTimestamp(), error);
        }
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public void trigger() {
        this.trigger(null);
    }

    public void trigger(ChannelService channel) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireSignalOccurred(signalListener, Signal.getCurrentTimestamp(), channel);
        }
    }

    public void trigger(ChannelService channel, Object object) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireSignalOccurred(signalListener, Signal.getCurrentTimestamp(), channel, object);
        }
    }

    public void trigger(ChannelService channel, Object data, Object timestamp) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            this.fireSignalOccurred(signalListener, timestamp, channel, data);
        }
    }

    public void trigger(Object value) {
        this.trigger(null, value);
    }

    public void trigger(Object data, Object timestamp) {
        this.trigger(null, data, timestamp);
    }
}

