/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.bundle.DeviceServletBundle;
import org.eclipse.soda.dk.epcglobal.llrp.adapter.service.EpcglobalLlrpAdapterService;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.LLRPConfigServlet;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities.ReaderCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.LLRPConfigStore;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.LLRPDefStoreExtra;
import org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.service.EpcglobalLlrpInventoryProfileService;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.service.EpcglobalLlrpWriteProfileService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class LLRPConfigConsole
extends DeviceServletBundle
implements NotificationListener {
    private static final String inventoryLLRPConfigurationGetTopic = "/LLRPInventoryProfile/LLRPConfiguration/get";
    private static final String inventoryLLRPConfigurationSetTopic = "/LLRPInventoryProfile/LLRPConfiguration/write";
    private static final String inventoryLLRPConfigurationTopic = "/LLRPInventoryProfile/LLRPConfiguration";
    private static final String writeLLRPConfigurationGetTopic = "/LLRPWriteProfile/LLRPConfiguration/get";
    private static final String writeLLRPConfigurationSetTopic = "/LLRPWriteProfile/LLRPConfiguration/write";
    private static final String writeLLRPConfigurationTopic = "/LLRPWriteProfile/LLRPConfiguration";
    private static final String llrpAdapterCapabilitiesGetTopic = "/LlrpAdapter/ReaderCapabilities/get";
    private static final String llrpAdapterCapabilitiesTopic = "/LlrpAdapter/ReaderCapabilities";
    private static final long REQUEST_DELAY = 1000L;
    private LLRPConfigStore llrpConfigStore = new LLRPConfigStore(this);
    private IServiceDetecter llrpInventoryServiceDetecter;
    private IServiceDetecter llrpWriteServiceDetecter;
    private IServiceDetecter llrpAdapterServiceDetecter;
    private ServiceDetecterListener serviceDetecterListener;
    static /* synthetic */ Class class$0;

    static {
        LLRPDefStoreExtra.addExtraDef();
    }

    protected void activate() {
        IServiceDetecter llrpInventoryServiceDetecter = this.getLLRPInventoryServiceDetecter();
        IServiceDetecter llrpWriteServiceDetecter = this.getLLRPWriteServiceDetecter();
        IServiceDetecter llrpAdapterServiceDetecter = this.getLLRPAdapterServiceDetecter();
        ServiceDetecterListener listener = this.getServiceDetecterListener();
        llrpInventoryServiceDetecter.addServiceDetecterListener(listener);
        llrpWriteServiceDetecter.addServiceDetecterListener(listener);
        llrpAdapterServiceDetecter.addServiceDetecterListener(listener);
        llrpInventoryServiceDetecter.acquire();
        llrpWriteServiceDetecter.acquire();
        llrpAdapterServiceDetecter.acquire();
        super.activate();
    }

    public void addReader(String readerPrefix, String readerId) {
        this.llrpConfigStore.addReader(readerPrefix, readerId);
    }

    public synchronized Map addReaderProfile(String readerPrefix, String profileName) {
        return this.llrpConfigStore.addReaderProfile(readerPrefix, profileName);
    }

    private IServiceDetecter createLLRPAdapterServiceDetecter() {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        IServiceDetecter detecter = utility.createServiceDetecter(context, "org.eclipse.soda.dk.epcglobal.llrp.adapter.service.EpcglobalLlrpAdapterService");
        return detecter;
    }

    private IServiceDetecter createLLRPInventoryServiceDetecter() {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        IServiceDetecter detecter = utility.createServiceDetecter(context, "org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.service.EpcglobalLlrpInventoryProfileService");
        return detecter;
    }

    private IServiceDetecter createLLRPWriteServiceDetecter() {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        IServiceDetecter detecter = utility.createServiceDetecter(context, "org.eclipse.soda.dk.epcglobal.llrp.write.profile.service.EpcglobalLlrpWriteProfileService");
        return detecter;
    }

    private ServiceDetecterListener createServiceDetecterListener() {
        return new ServiceDetecterListener(){

            public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                String readerId = (String)serviceReference.getProperty("id");
                String readerPrefix = (String)serviceReference.getProperty("prefix");
                if (service instanceof EpcglobalLlrpInventoryProfileService) {
                    LLRPConfigConsole.this.addReader(readerPrefix, readerId);
                    LLRPConfigConsole.this.addReaderProfile(readerPrefix, "EpcglobalLlrpInventoryProfile");
                    LLRPConfigConsole.this.requestConfigWithThread(readerPrefix, LLRPConfigConsole.inventoryLLRPConfigurationGetTopic, LLRPConfigConsole.inventoryLLRPConfigurationTopic, 1000L);
                } else if (service instanceof EpcglobalLlrpWriteProfileService) {
                    LLRPConfigConsole.this.addReader(readerPrefix, readerId);
                    LLRPConfigConsole.this.addReaderProfile(readerPrefix, "EpcglobalLlrpWriteProfile");
                    LLRPConfigConsole.this.requestConfigWithThread(readerPrefix, LLRPConfigConsole.writeLLRPConfigurationGetTopic, LLRPConfigConsole.writeLLRPConfigurationTopic, 1000L);
                } else if (service instanceof EpcglobalLlrpAdapterService) {
                    LLRPConfigConsole.this.addReader(readerPrefix, readerId);
                    LLRPConfigConsole.this.requestConfigWithThread(readerPrefix, LLRPConfigConsole.llrpAdapterCapabilitiesGetTopic, LLRPConfigConsole.llrpAdapterCapabilitiesTopic, 1000L);
                }
            }

            public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
            }
        };
    }

    public DeviceServlet createServlet() {
        LLRPConfigServlet llrpConfigServlet = new LLRPConfigServlet();
        llrpConfigServlet.bind(this);
        return llrpConfigServlet;
    }

    public String getHtml(String servletPath) {
        return this.llrpConfigStore.getHtml(servletPath);
    }

    protected String[] getImportedServiceNames() {
        return new String[]{"org.osgi.service.http.HttpService", "org.eclipse.soda.dk.notification.service.NotificationService"};
    }

    public IServiceDetecter getLLRPAdapterServiceDetecter() {
        if (this.llrpAdapterServiceDetecter == null) {
            this.llrpAdapterServiceDetecter = this.createLLRPAdapterServiceDetecter();
        }
        return this.llrpAdapterServiceDetecter;
    }

    public IServiceDetecter getLLRPInventoryServiceDetecter() {
        if (this.llrpInventoryServiceDetecter == null) {
            this.llrpInventoryServiceDetecter = this.createLLRPInventoryServiceDetecter();
        }
        return this.llrpInventoryServiceDetecter;
    }

    public IServiceDetecter getLLRPWriteServiceDetecter() {
        if (this.llrpWriteServiceDetecter == null) {
            this.llrpWriteServiceDetecter = this.createLLRPWriteServiceDetecter();
        }
        return this.llrpWriteServiceDetecter;
    }

    private NotificationService getNotificationService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.notification.service.NotificationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (NotificationService)this.getImportedService(clazz.getName());
    }

    public ServiceDetecterListener getServiceDetecterListener() {
        if (this.serviceDetecterListener == null) {
            this.serviceDetecterListener = this.createServiceDetecterListener();
        }
        return this.serviceDetecterListener;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.endsWith(inventoryLLRPConfigurationTopic)) {
            String readerPrefix = externalKey.substring(0, externalKey.indexOf(inventoryLLRPConfigurationTopic));
            String configStr = (String)data.get("value");
            this.setReaderProfileConfigStr(readerPrefix, "EpcglobalLlrpInventoryProfile", configStr);
        } else if (externalKey.endsWith(writeLLRPConfigurationTopic)) {
            String readerPrefix = externalKey.substring(0, externalKey.indexOf(writeLLRPConfigurationTopic));
            String configStr = (String)data.get("value");
            this.setReaderProfileConfigStr(readerPrefix, "EpcglobalLlrpWriteProfile", configStr);
        } else if (externalKey.endsWith(llrpAdapterCapabilitiesTopic)) {
            String readerPrefix = externalKey.substring(0, externalKey.indexOf(llrpAdapterCapabilitiesTopic));
            Map readerCapabilities = (Map)((Hashtable)data).get("value");
            if (readerCapabilities != null) {
                this.setReaderCapabilities(readerPrefix, readerCapabilities);
            }
        }
    }

    public void processReqeust(HttpServletRequest request) {
        this.llrpConfigStore.processRequest(request);
    }

    protected void requestConfig(String prefix, String getTopic, String valueTopic) {
        this.sendRequest(String.valueOf(prefix) + valueTopic, "");
        this.getNotificationService().register(String.valueOf(prefix) + getTopic, (NotificationListener)this);
    }

    protected void requestConfigWithThread(final String prefix, final String getTopic, String valueTopic, final long sleep) {
        this.getNotificationService().register(String.valueOf(prefix) + valueTopic, (NotificationListener)this);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {}
                LLRPConfigConsole.this.sendRequest(String.valueOf(prefix) + getTopic, "");
            }
        }).start();
    }

    public void sendLLRPConfiguration(String profileName, String prefix, String configStr) {
        if ("EpcglobalLlrpInventoryProfile".equals(profileName)) {
            this.sendRequest(String.valueOf(prefix) + inventoryLLRPConfigurationSetTopic, configStr);
        } else if ("EpcglobalLlrpWriteProfile".equals(profileName)) {
            this.sendRequest(String.valueOf(prefix) + writeLLRPConfigurationSetTopic, configStr);
        }
    }

    protected void sendRequest(String topic, Object request) {
        Hashtable<String, Object> value = new Hashtable<String, Object>();
        value.put("value", request);
        this.getNotificationService().broadcast(topic, value);
    }

    public void setReaderCapabilities(String readerPrefix, Map readerCapabilities) {
        this.llrpConfigStore.setReaderCapabilities(readerPrefix, new ReaderCapabilities(readerCapabilities));
    }

    public void setReaderProfileConfigStr(String readerPrefix, String profileName, String configStr) {
        this.llrpConfigStore.setReaderProfileConfigStr(readerPrefix, profileName, configStr);
    }
}

