/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities.IReaderCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.ParameterDisplay;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPConfigParser;
import org.eclipse.soda.dk.nls.Nls;

public class ProfileDisplay
extends ParameterDisplay {
    public static final String CONFIGSTR = "configStr";
    private boolean displayConfigStr4XML = false;

    public ProfileDisplay(String name, Object paramObj, IReaderCapabilities readerCapabilities) {
        super(name, paramObj, 2, null, readerCapabilities);
    }

    public String getConfigStr() {
        if (this.getParamObj() != null) {
            return Nls.formatData((Object)this.getParamObj());
        }
        return "";
    }

    private String getConfigStrForDisplay() {
        String configStr = this.getConfigStr();
        if (this.isDisplayConfigStr4XML()) {
            StringBuffer result = new StringBuffer(1024);
            int s = 0;
            int i = configStr.indexOf(34, s);
            while (i != -1) {
                result.append(configStr.substring(s, i));
                result.append("&amp;quot;");
                s = i + 1;
                i = configStr.indexOf(34, s);
            }
            result.append(configStr.substring(s));
            return result.toString();
        }
        return configStr;
    }

    protected String getFormTail(boolean subParamOnly) {
        StringBuffer result = new StringBuffer();
        result.append("<tr><td colspan=\"3\"><hr size=\"1\"></td></tr>\n");
        result.append("<tr><td>&nbsp;</td>\n");
        result.append("<td align=\"left\">");
        result.append("<input type=\"hidden\" name=\"Action\" id=\"Action\" value=\"\"/>\n");
        result.append("<input type=\"hidden\" name=\"Path\" id=\"Path\" value=\"\"/>\n");
        result.append("<table border=\"0\"><tr>\n");
        result.append("<td>");
        if (!this.isStandalone()) {
            result.append(ProfileDisplay.getButton("Send", 8, ""));
        } else {
            result.append("&nbsp;");
        }
        result.append("</td>\n");
        result.append("<td>");
        result.append(ProfileDisplay.getButton("Reset", 9, ""));
        result.append("</td>\n");
        result.append("<td>");
        result.append(ProfileDisplay.getButton("Import", 13, ""));
        result.append("</td>\n");
        result.append("</tr></table>\n");
        result.append("</td><td>&nbsp;</td></tr>\n");
        result.append("<tr><td align=\"right\" valign=\"top\">Configuration:</td>\n");
        result.append("<td colspan=\"1\" align=\"left\">\n");
        result.append("<textarea name=\"configStr\" row=\"5\" col=\"80\" readonly=\"readonly\">\n");
        result.append(String.valueOf(this.getConfigStrForDisplay()) + '\n');
        result.append("</textarea></td>");
        result.append("<td align=\"left\" valign=\"top\">\n");
        result.append("<input type=\"checkbox\" name=\"configStr_in_xml\" value=\"true\"" + (this.isDisplayConfigStr4XML() ? "checked=\"checked\"" : "") + " onchange=\"setValue('" + "Action" + "','" + 14 + "'); " + " this.form.submit();\"/>Quote Escape\n");
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("</form>\n");
        return result.toString();
    }

    public Object getParamObj() {
        return this.getProfileMap().get("ProfileParameters");
    }

    private Map getProfileMap() {
        return (Map)super.getParamObj();
    }

    public void importConfigStr(String configStr) {
        if (configStr != null && configStr.trim().length() > 0) {
            this.getProfileMap().put("ProfileParameters", LLRPConfigParser.parseConfig((String)configStr.trim()));
        }
    }

    private boolean isDisplayConfigStr4XML() {
        return this.displayConfigStr4XML;
    }

    private boolean isStandalone() {
        return this.getName().equals("StandAlone");
    }

    public void processRequest(HttpServletRequest request) {
        String configStr_in_xml = request.getParameter("configStr_in_xml");
        this.setDisplayConfigStr4XML("true".equals(configStr_in_xml));
    }

    public void reset() {
        String configStr = (String)this.getProfileMap().get("ProfileConfigStr");
        this.getProfileMap().put("ProfileParameters", LLRPConfigParser.parseConfig((String)configStr));
    }

    private void setDisplayConfigStr4XML(boolean displayConfigStr4XML) {
        this.displayConfigStr4XML = displayConfigStr4XML;
    }
}

