/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.Messages;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPConfigParser;

public class LLRPDefStore {
    public static final String LLRP_DEF_STRING = Messages.getString("LLRPDefStore");
    private static Map store = (Map)LLRPConfigParser.parseConfig((String)LLRP_DEF_STRING);

    public static void addEnumDef(String enumId, int enumType, String[] enums) {
        if (store == null) {
            return;
        }
        HashMap<String, Object> enumDef = new HashMap<String, Object>();
        enumDef.put("id", enumId);
        enumDef.put("type", EscObject.createInteger((int)enumType));
        enumDef.put("enums", enums);
        List enumDefList = (List)store.get("enums");
        if (enumDefList != null) {
            enumDefList.add(enumDef);
        }
    }

    public static void addParamDef(String paramId, int paramType) {
        if (store == null || LLRPDefStore.getParameterDef(paramId) != null) {
            return;
        }
        List paramDefList = (List)store.get("parameters");
        HashMap<String, Object> paramDef = new HashMap<String, Object>();
        paramDef.put("id", paramId);
        paramDef.put("type", EscObject.createInteger((int)paramType));
        paramDef.put("defitems", new ArrayList());
        paramDefList.add(paramDef);
    }

    public static void addParamElementDef(String paramId, String elementId, int elementType, String minOccur, String maxOccur) {
        List paramElements = LLRPDefStore.getParamElements(paramId);
        if (paramElements == null || LLRPDefStore.getParamElementDef(paramId, elementId) != null) {
            return;
        }
        HashMap<String, Object> elementDef = new HashMap<String, Object>();
        elementDef.put("id", elementId);
        elementDef.put("type", EscObject.createInteger((int)elementType));
        if (minOccur != null) {
            elementDef.put("occursminimum", minOccur);
        }
        if (maxOccur != null) {
            elementDef.put("occursmaximum", maxOccur);
        }
        paramElements.add(elementDef);
    }

    public static void addParamElementDefInChoice(String choiceId, String elementId, int elementType, String minOccur, String maxOccur) {
        String[] choices = LLRPDefStore.getChoiceItems(choiceId);
        int i = 0;
        while (i < choices.length) {
            LLRPDefStore.addParamElementDef(choices[i], elementId, elementType, minOccur, maxOccur);
            ++i;
        }
    }

    public static void addProfileDef(String profileId) {
        LLRPDefStore.addParamDef(profileId, 3);
        LLRPDefStore.addParamElementDef(profileId, "ROSpecParameter", 3, "1", "n");
        LLRPDefStore.addParamElementDef(profileId, "AccessSpecParameter", 3, "0", "n");
    }

    public static String[] getChoiceItems(String id) {
        if (store == null) {
            return null;
        }
        List choiceDefList = (List)store.get("choices");
        int i = 0;
        while (i < choiceDefList.size()) {
            Map choiceDef = (Map)choiceDefList.get(i);
            String choiceId = (String)choiceDef.get("id");
            if (choiceId.equals(id)) {
                return (String[])choiceDef.get("choices");
            }
            ++i;
        }
        return null;
    }

    public static String[] getEnumItems(String id) {
        if (store == null) {
            return null;
        }
        List enumDefList = (List)store.get("enums");
        int i = 0;
        while (i < enumDefList.size()) {
            Map enumDef = (Map)enumDefList.get(i);
            String enumId = (String)enumDef.get("id");
            if (enumId.equals(id)) {
                return (String[])enumDef.get("enums");
            }
            ++i;
        }
        return null;
    }

    public static int getListType(String id) {
        if (store == null) {
            return -1;
        }
        List listDefList = (List)store.get("lists");
        int i = 0;
        while (i < listDefList.size()) {
            Map listDef = (Map)listDefList.get(i);
            String listId = (String)listDef.get("id");
            if (listId.equals(id)) {
                Integer type = (Integer)listDef.get("type");
                return type;
            }
            ++i;
        }
        return -1;
    }

    public static Map getParamElementDef(String paramId, String elementId) {
        Map paramDef = LLRPDefStore.getParameterDef(paramId);
        if (paramDef == null) {
            return null;
        }
        List defItems = (List)paramDef.get("defitems");
        int i = 0;
        while (i < defItems.size()) {
            Map elementDef = (Map)defItems.get(i);
            String id = (String)elementDef.get("id");
            if (id.equals(elementId)) {
                return elementDef;
            }
            ++i;
        }
        return null;
    }

    public static int getParamElementType(String paramId, String elementId) {
        Map paramDef = LLRPDefStore.getParameterDef(paramId);
        if (paramDef == null) {
            return -1;
        }
        List defItems = (List)paramDef.get("defitems");
        int i = 0;
        while (i < defItems.size()) {
            Map elementDef = (Map)defItems.get(i);
            String id = (String)elementDef.get("id");
            if (elementId.equals(id)) {
                return (Integer)elementDef.get("type");
            }
            ++i;
        }
        return -1;
    }

    public static List getParamElements(String paramId) {
        Map paramDef = LLRPDefStore.getParameterDef(paramId);
        if (paramDef == null) {
            return null;
        }
        return (List)paramDef.get("defitems");
    }

    public static Map getParameterDef(String id) {
        if (store == null) {
            return null;
        }
        List paramDefList = (List)store.get("parameters");
        int i = 0;
        while (i < paramDefList.size()) {
            Map paramDef = (Map)paramDefList.get(i);
            String paramId = (String)paramDef.get("id");
            if (paramId.equals(id)) {
                return paramDef;
            }
            ++i;
        }
        return null;
    }

    public static int getVariableLengthType(String id) {
        if (store == null) {
            return -1;
        }
        List variableLengthDefList = (List)store.get("variablelengths");
        int i = 0;
        while (i < variableLengthDefList.size()) {
            Map variableLengthDef = (Map)variableLengthDefList.get(i);
            String variableId = (String)variableLengthDef.get("id");
            if (variableId.equals(id)) {
                Integer type = (Integer)variableLengthDef.get("type");
                return type;
            }
            ++i;
        }
        return -1;
    }
}

