/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.device.gpio.gpio.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioService;
import org.eclipse.soda.dk.generic.device.gpio.gpio.profile.service.GenericDeviceGpioGpioProfileService;
import org.eclipse.soda.dk.gpio.profile.GpioProfile;
import org.eclipse.soda.dk.gpio.profile.service.GpioProfileService;
import org.eclipse.soda.dk.profile.service.ProfileService;

public class GenericDeviceGpioGpioProfile
extends GpioProfile
implements ProfileService,
GenericDeviceGpioGpioProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.device.gpio.gpio.profile.GenericDeviceGpioGpioProfile";
    private GenericGpioListener gpioListener = new GenericGpioListener(){

        public void receiveInputEvent(int inputPin, boolean state) {
            GenericDeviceGpioGpioProfile.this.handleInputEvent(inputPin, state);
        }
    };
    private GenericGpioService adapter;

    public GenericDeviceGpioGpioProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "GenericDeviceGpioGpioProfile";
    }

    public GenericGpioService getGpioAdapterService() {
        return this.adapter;
    }

    protected long getInputCountValue() {
        if (this.adapter != null) {
            return this.adapter.getInputCountValue();
        }
        return 0L;
    }

    private Map getNewInputMap() {
        Map oldInputMap = (Map)this.input.getValue();
        Hashtable newInputMap = new Hashtable(32);
        if (oldInputMap != null) {
            newInputMap.putAll(oldInputMap);
        }
        return newInputMap;
    }

    protected long getOutputCountValue() {
        if (this.adapter != null) {
            return this.adapter.getOutputCountValue();
        }
        return 0L;
    }

    protected void handleInputEvent(int inputPin, boolean state) {
        Map newInputMap = this.getNewInputMap();
        newInputMap.put(GpioProfileService.INPUT_NAMES[inputPin], state ? Boolean.TRUE : Boolean.FALSE);
        this.input.setValue((Object)newInputMap, GenericDeviceGpioGpioProfile.getCurrentTimestamp());
    }

    private void initialize() {
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public void setGpioAdapterService(GenericGpioService adapter) {
        this.adapter = adapter;
        ((GenericGpioListenerService)this.adapter).setGpioListener(this.gpioListener);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("genericdevicegpiogpioprofile.notificationpriority", this.getNotificationPriority()));
    }

    protected void turnOffAllOutputs() {
        Hashtable<String, Boolean> outputs = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.getOutputCountValue()) {
            outputs.put(GpioProfileService.OUTPUT_NAMES[i], Boolean.FALSE);
            ++i;
        }
        this.updateOutputs(outputs, null);
    }

    protected void turnOnAllOutputs() {
        Hashtable<String, Boolean> outputs = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.getOutputCountValue()) {
            outputs.put(GpioProfileService.OUTPUT_NAMES[i], Boolean.TRUE);
            ++i;
        }
        this.updateOutputs(outputs, null);
    }

    protected void updateOutputs(Map fullState, Map individualRequest) {
        if (this.adapter != null) {
            this.adapter.updateOutputs(fullState);
        }
    }
}

