/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gps.nmea.transport;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.data.Degree;
import org.eclipse.soda.dk.data.LatitudeData;
import org.eclipse.soda.dk.data.LongitudeData;
import org.eclipse.soda.dk.data.PositionData;
import org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaTransport;
import org.eclipse.soda.dk.message.AsciiMessage;

public class GpsNmeaMessage
extends AsciiMessage {
    private boolean checksumValid = false;
    private int fieldCount;
    private int[] fieldInfo;

    public GpsNmeaMessage() {
        this(EscObject.EMPTY_BYTES);
    }

    public GpsNmeaMessage(byte[] bytes) {
        super(bytes);
        this.setBytes(bytes);
    }

    public Object get(Object fieldName) {
        if ("Latitude".equals(fieldName)) {
            return this.getLatitude();
        }
        if ("Longitude".equals(fieldName)) {
            return this.getLongitude();
        }
        if ("Position".equals(fieldName)) {
            LatitudeData latitude = this.getLatitude();
            LongitudeData longitude = this.getLongitude();
            if (latitude != null && longitude != null) {
                return new PositionData((Degree)latitude, (Degree)longitude);
            }
            return null;
        }
        return this.getData(Integer.parseInt((String)fieldName, 10));
    }

    public Object getData(int index) {
        if (index >= 0 && index < this.fieldCount) {
            return new String(this.getBytes(), this.fieldInfo[index], this.fieldInfo[index + 1] - this.fieldInfo[index] - 1);
        }
        return null;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int[] getFieldInfo() {
        if (this.fieldInfo == null) {
            this.fieldInfo = new int[80];
        }
        return this.fieldInfo;
    }

    public int getFieldPosition() throws RuntimeException {
        Object data = this.getData(0);
        if ("$GPGGA".equals(data)) {
            return 2;
        }
        if ("$GPRMC".equals(data)) {
            return 3;
        }
        if ("$GPGLL".equals(data)) {
            return 1;
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public LatitudeData getLatitude() {
        try {
            String data = String.valueOf(this.getData(this.getFieldPosition()));
            int value = Degree.parseNmeaDegree((String)data);
            if ("S".equals(this.getData(this.getFieldPosition() + 1))) {
                value = -value;
            }
            return new LatitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public LongitudeData getLongitude() {
        try {
            String data = String.valueOf(this.getData(this.getFieldPosition() + 2));
            int value = Degree.parseNmeaDegree((String)data);
            if ("W".equals(this.getData(this.getFieldPosition() + 3))) {
                value = -value;
            }
            return new LongitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean isChecksumValid() {
        return this.checksumValid;
    }

    public boolean isValid() {
        return this.getBytes()[0] == 36 && this.isChecksumValid();
    }

    public void setBytes(byte[] bytes) {
        int index;
        int offset;
        super.setBytes(bytes);
        if (bytes == null || bytes.length < 1) {
            return;
        }
        int length = bytes.length;
        int computedChecksum = 0;
        int runningChecksum = 36;
        this.fieldInfo = new int[length + 1];
        this.fieldCount = 0;
        int i = 0;
        while (i < length) {
            byte data = bytes[i];
            if (data == 42) {
                computedChecksum = runningChecksum;
            } else {
                runningChecksum ^= data;
            }
            if (data == 44 || data == 42 || data == 10 || data == 13) {
                ++this.fieldCount;
                this.getFieldInfo()[this.fieldCount] = i + 1;
            }
            ++i;
        }
        this.checksumValid = false;
        if (this.fieldCount == 0) {
            ++this.fieldCount;
            this.getFieldInfo()[this.fieldCount] = length + 1;
        } else if (this.fieldCount > 2 && (offset = this.fieldInfo[index = this.fieldCount - 2]) + 1 < length) {
            this.checksumValid = true;
            if (bytes[offset] != GpsNmeaTransport.HEX_TABLE[(computedChecksum &= 0xFF) >> 4]) {
                this.checksumValid = false;
            }
            if (bytes[offset + 1] != GpsNmeaTransport.HEX_TABLE[computedChecksum & 0xF]) {
                this.checksumValid = false;
            }
        }
    }
}

