/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.matrix.lcd.transport;

import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.matrix.lcd.transport.service.MatrixLcdTransportService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.serial.connection.SerialConnection;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class MatrixLcdTransport
extends ConnectionTransport
implements TransportService,
MatrixLcdTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.matrix.lcd.transport.MatrixLcdTransport";

    public int processInput(byte[] bytes, int length) throws Exception {
        this.fireMessageReceived(MatrixLcdTransport.getCurrentTimestamp(), (MessageService)new Message(bytes, 0, length));
        return length;
    }

    protected void write(MessageService message) throws Exception {
        byte[] messageBytes = message.getBytes();
        if (messageBytes.length > 2) {
            if (messageBytes[1] == 53) {
                super.write(new byte[]{messageBytes[2]});
            } else {
                super.write(message);
            }
        } else {
            super.write(message);
        }
        this.fireMessageReceived(MatrixLcdTransport.getCurrentTimestamp(), message);
    }

    public ConnectionService getDefaultConnection() {
        String type = this.getString("matrixlcdtransport.connection", "serial");
        if (type.equals("tcpip")) {
            return this.getDefaultTcpipConnection();
        }
        return this.getDefaultSerialConnection();
    }

    public SerialConnectionService getDefaultSerialConnection() {
        return new SerialConnection(this.getInt("matrixlcdtransport.comport", 1), this.getInt("matrixlcdtransport.baudrate", 19200), this.getInt("matrixlcdtransport.databits", 8), this.getInt("matrixlcdtransport.parity", 0), this.getInt("matrixlcdtransport.stopbits", 1), this.getInt("matrixlcdtransport.hardwareflowcontrol", 0), this.getInt("matrixlcdtransport.softwareflowcontrol", 0), this.getLong("matrixlcdtransport.readtotaltimeout", 1000L), this.getLong("matrixlcdtransport.readintervaltimeout", 100L), this.getLong("matrixlcdtransport.writetotaltimeout", 100L));
    }

    public TcpipConnectionService getDefaultTcpipConnection() {
        return new TcpipConnection(this.getString("matrixlcdtransport.localhost", "0.0.0.0"), this.getInt("matrixlcdtransport.localport", -1), this.getString("matrixlcdtransport.remotehost", "localhost"), this.getInt("matrixlcdtransport.remoteport", 9234), this.getInt("matrixlcdtransport.readtimeout", 1000), this.getInt("matrixlcdtransport.readsize", -1), this.getInt("matrixlcdtransport.writesize", -1), this.getInt("matrixlcdtransport.linger", -1));
    }

    public void setup() {
        super.setup();
        this.setRetryTime(this.getLong("matrixlcdtransport.retrytime", this.getRetryTime()));
        this.setPriority(this.getInt("matrixlcdtransport.priority", this.getPriority()));
        this.setNotificationPriority(this.getInt("matrixlcdtransport.notificationpriority", this.getNotificationPriority()));
        this.setTransmitRetries(this.getInt("matrixlcdtransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("matrixlcdtransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

