/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.servlet;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.testmanager.servlet.DeviceTestManagerServlet;
import org.eclipse.soda.dk.testmanager.servlet.HeaderValue;
import org.eclipse.soda.dk.testmanager.servlet.MimePart;

public class MimeMultiPart {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PartInputStream partInputStream;
    private String contentType;
    String boundary;
    String characterEncoding;

    public MimeMultiPart(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        String contentTypeAndAttr = request.getContentType();
        this.characterEncoding = request.getCharacterEncoding();
        if (contentTypeAndAttr != null) {
            HeaderValue headerValue = new HeaderValue(contentTypeAndAttr);
            this.contentType = headerValue.getValue();
            this.boundary = headerValue.getAttribute("boundary");
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public MimePart getNextPart() throws IOException {
        if (this.partInputStream == null) {
            this.partInputStream = new PartInputStream();
        }
        if (!this.partInputStream.isLastPart()) {
            this.partInputStream = new PartInputStream();
            return new MimePart(this.partInputStream);
        }
        return null;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public class PartInputStream
    extends FilterInputStream {
        private int count;
        private int pos;
        private byte[] buf = new byte[4096];
        private String line;
        private boolean atEnd;
        private boolean lastPart;

        public PartInputStream() throws IOException {
            super((InputStream)MimeMultiPart.this.getRequest().getInputStream());
        }

        public int available() throws IOException {
            if (this.buf == null) {
                throw new IOException(DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7250)));
            }
            return this.atEnd ? 0 : this.count - this.pos + super.available();
        }

        public void close() throws IOException {
            this.buf = null;
        }

        private void fillLine() throws UnsupportedEncodingException {
            this.line = this.getCharacterEncoding() == null ? new String(this.buf, this.pos, this.count) : new String(this.buf, this.pos, this.count, this.getCharacterEncoding());
            this.line = this.line.trim();
        }

        private int fillbuf() throws IOException {
            if (this.atEnd) {
                return -1;
            }
            int result = MimeMultiPart.this.getRequest().getInputStream().readLine(this.buf, 0, this.buf.length);
            this.pos = 0;
            if (result > 0) {
                this.count = result;
                this.fillLine();
                if (this.line.startsWith("--" + MimeMultiPart.this.boundary)) {
                    result = -1;
                    this.count = 0;
                    this.atEnd = true;
                    this.lastPart = this.line.endsWith(String.valueOf(MimeMultiPart.this.boundary) + "--");
                }
            } else {
                this.count = 0;
            }
            return result;
        }

        public String getCharacterEncoding() {
            return MimeMultiPart.this.characterEncoding;
        }

        public boolean isLastPart() throws IOException {
            while (!this.atEnd) {
                this.fillbuf();
            }
            return this.lastPart;
        }

        public int read() throws IOException {
            if (this.buf != null) {
                if (this.pos >= this.count && this.fillbuf() == -1) {
                    return -1;
                }
                if (this.count - this.pos > 0) {
                    return this.buf[this.pos++] & 0xFF;
                }
                return -1;
            }
            throw new IOException(DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7250)));
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.buf == null) {
                throw new IOException(DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7250)));
            }
            if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
                int required;
                if (length == 0) {
                    return 0;
                }
                int i = offset;
                if (this.pos < this.count) {
                    int copylength = this.count - this.pos >= length ? length : this.count - this.pos;
                    System.arraycopy(this.buf, this.pos, buffer, i, copylength);
                    this.pos += copylength;
                    if (copylength == length || this.in.available() == 0) {
                        return copylength;
                    }
                    i += copylength;
                    required = length - copylength;
                } else {
                    required = length;
                }
                while (true) {
                    if (this.fillbuf() == -1) {
                        return required == length ? -1 : length - required;
                    }
                    int read = this.count - this.pos >= required ? required : this.count - this.pos;
                    System.arraycopy(this.buf, this.pos, buffer, i, read);
                    this.pos += read;
                    if ((required -= read) == 0) {
                        return length;
                    }
                    if (this.in.available() == 0) {
                        return length - required;
                    }
                    i += read;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        protected String readLine() throws IOException {
            if (this.buf == null) {
                throw new IOException(DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7250)));
            }
            if (this.pos >= this.count && this.fillbuf() == -1) {
                return null;
            }
            this.pos = this.count;
            return this.line;
        }
    }
}

