/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testmanager.servlet.DeviceTestManagerServlet;
import org.eclipse.soda.dk.testmanager.servlet.MimeMultiPart;

public class MimePart {
    private MimeMultiPart.PartInputStream in;
    private Map headers;

    public MimePart(MimeMultiPart.PartInputStream in) throws IOException {
        this.in = in;
        this.headers = new Hashtable();
        this.parseHeaders();
    }

    public String getHeader(String key) {
        return (String)this.headers.get(key);
    }

    public Map getHeaders() {
        return this.headers;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public Reader getReader() throws UnsupportedEncodingException {
        String characterEncoding = this.in.getCharacterEncoding();
        if (characterEncoding == null) {
            return new InputStreamReader(this.in);
        }
        return new InputStreamReader((InputStream)this.in, characterEncoding);
    }

    protected void parseHeaders() throws IOException {
        boolean firstLine = true;
        String header = null;
        StringBuffer value = new StringBuffer(256);
        while (true) {
            String line;
            if ((line = this.in.readLine()) == null || line.length() == 0) {
                if (firstLine) break;
                this.headers.put(header, value.toString().trim());
                break;
            }
            char c = line.charAt(0);
            if (c == ' ' || c == '\t') {
                if (firstLine) {
                    Object[] parms = new Object[]{new Integer(line)};
                    throw new IOException(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7251)), (Object[])parms));
                }
                value.append(line.substring(1));
                continue;
            }
            if (!firstLine) {
                this.headers.put(header, value.toString().trim());
                value.setLength(0);
            }
            int colon = line.indexOf(58, 0);
            header = line.substring(0, colon).toLowerCase();
            value.append(line.substring(colon + 1));
            firstLine = false;
        }
    }
}

