/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.cm;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.soda.sat.core.framework.BundleActivationManagerOwnerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManagerOwner;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceAdvisor;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.ConfigurationData;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;

public class ManagedServiceActivationManager
implements IManagedServiceActivationManager {
    private static final String FAILED_TO_CREATE_IMPORTED_SERVICE_FILTER_FOR_PID_KEY = "ManagedServiceActivationManager.FailedToCreateImportedServiceFilterForPid";
    private static final String FAILED_TO_CREATE_OBJECT_FOR_PID_KEY = "ManagedServiceActivationManager.FailedToCreateObjectForPid";
    private static final String FAILED_TO_DESTROY_OBJECT_FOR_PID_KEY = "ManagedServiceActivationManager.FailedToDestroyObjectForPid";
    private static final String FAILED_TO_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY = "ManagedServiceActivationManager.FailedToHandleAcquiredOptionalImportedServiceServiceForPid";
    private static final String FAILED_TO_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY = "ManagedServiceActivationManager.FailedToHandleReleasedOptionalImportedServiceServiceForPid";
    private static final String FAILED_TO_START_BUNDLE_ACTIVATION_MANAGER_KEY = "ManagedServiceActivationManager.FailedToStartBundleActivationManager";
    private static final String FAILED_TO_STOP_BUNDLE_ACTIVATION_MANAGER_KEY = "ManagedServiceActivationManager.ManagedServiceActivationManager.FailedToStopBundleActivationManager";
    private static final String FAILED_TO_UPDATE_OBJECT_FOR_PID_KEY = "ManagedServiceActivationManager.FailedToUpdateObjectForPid";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IManagedServiceAdvisor advisor;
    private BundleContext bundleContext;
    private ConfigurationData configurationData;
    private final Object startLock = new Object();

    public ManagedServiceActivationManager(IManagedServiceAdvisor advisor) {
        this.setAdvisor(advisor);
    }

    private void create() {
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        Dictionary properties = this.getProperties();
        IBundleActivationManager manager = this.getBundleActivationManager();
        try {
            Object object = advisor.create(pid, properties, manager);
            this.setObject(object);
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_CREATE_OBJECT_FOR_PID_KEY);
        }
    }

    private IBundleActivationManagerOwner createBundleActivationManagerOwner() {
        return new BundleActivationManagerOwnerAdapter(){

            public void activate() {
                ManagedServiceActivationManager.this.create();
            }

            public void deactivate() {
                ManagedServiceActivationManager.this.destroy();
            }

            public String[] getImportedServiceNames() {
                return ManagedServiceActivationManager.this.getImportedServiceNames();
            }

            public String[] getOptionalImportedServiceNames() {
                return ManagedServiceActivationManager.this.getOptionalImportedServiceNames();
            }

            public void handleAcquiredOptionalImportedService(String serviceName, Object service) {
                ManagedServiceActivationManager.this.handleAcquiredOptionalImportedService(serviceName, service);
            }

            public void handleReleasedOptionalImportedService(String serviceName, Object service) {
                ManagedServiceActivationManager.this.handleReleasedOptionalImportedService(serviceName, service);
            }

            public void start() {
                ManagedServiceActivationManager.this.createImportedServiceFilters();
            }
        };
    }

    private Object createImportedServiceFilters() {
        Object object = null;
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        Dictionary oldProperties = this.getOldProperties();
        Dictionary properties = this.getProperties();
        IBundleActivationManager manager = this.getBundleActivationManager();
        try {
            advisor.createImportedServiceFilters(pid, oldProperties, properties, manager);
            object = this.getObject();
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_CREATE_IMPORTED_SERVICE_FILTER_FOR_PID_KEY);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void destroy() {
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        Object object = this.getObject();
        Dictionary properties = this.getProperties();
        IBundleActivationManager manager = this.getBundleActivationManager();
        try {
            try {
                advisor.destroy(pid, object, properties, manager);
            }
            catch (Throwable throwable) {
                this.logError(pid, throwable, FAILED_TO_DESTROY_OBJECT_FOR_PID_KEY);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setObject(null);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.setObject(null);
            return;
        }
    }

    private boolean equal(Dictionary dictionary1, Dictionary dictionary2) {
        int size2;
        boolean equal;
        if (dictionary1 == dictionary2) {
            return true;
        }
        if (dictionary1 == null || dictionary2 == null) {
            return false;
        }
        int size1 = dictionary1.size();
        boolean bl = equal = size1 == (size2 = dictionary2.size());
        if (!equal) {
            return false;
        }
        Enumeration keys = dictionary1.keys();
        while (equal && keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value1 = dictionary1.get(key);
            Object value2 = dictionary2.get(key);
            equal = value1.equals(value2);
        }
        return equal;
    }

    private IManagedServiceAdvisor getAdvisor() {
        return this.advisor;
    }

    private IBundleActivationManager getBundleActivationManager() {
        ConfigurationData data = this.getConfigurationData();
        if (data == null) {
            return null;
        }
        IBundleActivationManager manager = data.getBundleActivationManager();
        return manager;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private String getBundleSymbolicName() {
        BundleContext context = this.getBundleContext();
        Bundle bundle = context.getBundle();
        String symbolicName = bundle.getSymbolicName();
        return symbolicName;
    }

    private ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    private String[] getImportedServiceNames() {
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        Dictionary oldProperties = this.getOldProperties();
        Dictionary properties = this.getProperties();
        IBundleActivationManager manager = this.getBundleActivationManager();
        String[] names = advisor.getImportedServiceNames(pid, oldProperties, properties, manager);
        return names;
    }

    private Object getObject() {
        ConfigurationData data = this.getConfigurationData();
        Object object = data.getObject();
        return object;
    }

    private Dictionary getOldProperties() {
        ConfigurationData data = this.getConfigurationData();
        Dictionary properties = data.getOldProperties();
        return properties;
    }

    private String[] getOptionalImportedServiceNames() {
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        Dictionary oldProperties = this.getOldProperties();
        Dictionary properties = this.getProperties();
        IBundleActivationManager manager = this.getBundleActivationManager();
        String[] names = advisor.getOptionalImportedServiceNames(pid, oldProperties, properties, manager);
        return names;
    }

    private String getPid() {
        Dictionary properties = this.getProperties();
        String pid = this.getPid(properties);
        return pid;
    }

    private String getPid(Dictionary properties) {
        String pid = properties != null ? (String)properties.get("service.pid") : null;
        return pid;
    }

    private Dictionary getProperties() {
        ConfigurationData data = this.getConfigurationData();
        Dictionary properties = data != null ? data.getProperties() : null;
        return properties;
    }

    private Object getStartLock() {
        return this.startLock;
    }

    private void handleAcquiredOptionalImportedService(String importedServiceName, Object importedService) {
        Object object = this.getObject();
        if (object == null) {
            return;
        }
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        IBundleActivationManager manager = this.getBundleActivationManager();
        try {
            advisor.handleAcquiredOptionalImportedService(pid, object, importedServiceName, importedService, manager);
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString(FAILED_TO_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY);
            Object[] values = new Object[]{importedService, pid};
            String message = MessageFormatter.format(pattern, values);
            this.logError(message, throwable);
        }
    }

    private void handleReleasedOptionalImportedService(String importedServiceName, Object importedService) {
        Object object = this.getObject();
        if (object == null) {
            return;
        }
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        IBundleActivationManager manager = this.getBundleActivationManager();
        try {
            advisor.handleReleasedOptionalImportedService(pid, object, importedServiceName, importedService, manager);
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString(FAILED_TO_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY);
            Object[] values = new Object[]{importedService, pid};
            String message = MessageFormatter.format(pattern, values);
            this.logError(message, throwable);
        }
    }

    private boolean isStarted() {
        BundleContext bundleContext = this.getBundleContext();
        boolean started = bundleContext != null;
        return started;
    }

    private void logError(String message, Throwable throwable) {
        LogUtility.logError(this, message, throwable);
    }

    private void logError(String pid, Throwable throwable, String key) {
        String pattern = Messages.getString(key);
        String message = MessageFormatter.format(pattern, pid);
        this.logError(message, throwable);
    }

    private void printConfigurationOn(ICharBuffer buffer) {
        String pid = this.getPid();
        Object object = this.getObject();
        Dictionary properties = this.getProperties();
        Enumeration enumeration = properties.keys();
        buffer.append('\t');
        buffer.append("Persistent ID: ");
        buffer.append(pid);
        buffer.append(LINE_SEPARATOR);
        buffer.append('\t');
        buffer.append('\t');
        buffer.append("Object: ");
        buffer.append(object);
        buffer.append(LINE_SEPARATOR);
        buffer.append('\t');
        buffer.append('\t');
        buffer.append("Properties:");
        buffer.append(LINE_SEPARATOR);
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = properties.get(key);
            buffer.append('\t');
            buffer.append('\t');
            buffer.append('\t');
            buffer.append("Key=");
            buffer.append(key);
            buffer.append(", Value=");
            buffer.append(value);
            buffer.append(LINE_SEPARATOR);
        }
        buffer.append(LINE_SEPARATOR);
    }

    private void printOn(ICharBuffer buffer) {
        String value = super.toString();
        buffer.append(value);
        String bundleSymbolicName = this.getBundleSymbolicName();
        buffer.append(", bundleSymbolicName=");
        buffer.append(bundleSymbolicName);
        IManagedServiceAdvisor advisor = this.getAdvisor();
        buffer.append(", advisor=");
        buffer.append(advisor);
        buffer.append(LINE_SEPARATOR);
        this.printConfigurationOn(buffer);
    }

    private void setAdvisor(IManagedServiceAdvisor advisor) {
        Assertion.checkArgumentIsNotNull(advisor, "advisor");
        this.advisor = advisor;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void setConfigurationData(ConfigurationData configurationData) {
        this.configurationData = configurationData;
    }

    private void setObject(Object object) {
        ConfigurationData data = this.getConfigurationData();
        data.setObject(object);
    }

    private void setProperties(Dictionary properties) {
        ConfigurationData data = this.getConfigurationData();
        data.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) {
        Object lock;
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        Object object = lock = this.getStartLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setBundleContext(bundleContext);
        }
    }

    private void startBundleActivationManager() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        BundleContext bundleContext = this.getBundleContext();
        IBundleActivationManagerOwner owner = this.createBundleActivationManagerOwner();
        try {
            manager.start(bundleContext, owner);
        }
        catch (Exception exception) {
            String pid = this.getPid();
            this.logError(pid, exception, FAILED_TO_START_BUNDLE_ACTIVATION_MANAGER_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.stopBundleActivationManager();
            this.setBundleContext(null);
        }
    }

    private void stopBundleActivationManager() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        if (manager == null) {
            return;
        }
        try {
            manager.stop();
        }
        catch (Exception exception) {
            String pid = this.getPid();
            this.logError(pid, exception, FAILED_TO_STOP_BUNDLE_ACTIVATION_MANAGER_KEY);
        }
    }

    public final String toString() {
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(350);
        this.printOn(buffer);
        String result = buffer.toString();
        return result;
    }

    private void update() {
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        Object object = this.getObject();
        Dictionary oldProperties = this.getOldProperties();
        Dictionary properties = this.getProperties();
        IBundleActivationManager manager = this.getBundleActivationManager();
        Object updatedObject = advisor.update(pid, object, oldProperties, properties, manager);
        this.setObject(updatedObject);
    }

    private void update(Dictionary properties) {
        boolean update;
        Dictionary currentProperties = this.getProperties();
        boolean match = this.equal(currentProperties, properties);
        if (match) {
            return;
        }
        this.setProperties(properties);
        Object object = this.getObject();
        Object newObject = this.createImportedServiceFilters();
        boolean bl = update = object != null && object == newObject;
        if (!update) {
            return;
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary properties) throws ConfigurationException {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            ConfigurationData data = this.getConfigurationData();
            if (properties == null) {
                if (data == null) {
                    return;
                }
                this.stopBundleActivationManager();
                this.setConfigurationData(null);
            } else {
                try {
                    this.validateConfiguration(properties);
                    if (data == null) {
                        data = new ConfigurationData(properties);
                        this.setConfigurationData(data);
                        this.startBundleActivationManager();
                    } else {
                        this.update(properties);
                    }
                }
                catch (Throwable throwable) {
                    String pid = this.getPid(properties);
                    this.logError(pid, throwable, FAILED_TO_UPDATE_OBJECT_FOR_PID_KEY);
                }
            }
        }
    }

    private void validateConfiguration(Dictionary properties) throws ConfigurationException {
        IManagedServiceAdvisor advisor = this.getAdvisor();
        String pid = this.getPid();
        advisor.validateConfiguration(pid, properties);
    }
}

