/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.eclipse.soda.sat.core.util.MiscUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

class FrameworkManager {
    private static final String LOG_EVENTS_PROPERTY = "org.eclipse.soda.sat.core.internal.framework.log.events";
    private static final boolean DEFAULT_LOG_EVENTS = true;
    private static final boolean LOG_EVENTS = FrameworkManager.getBooleanProperty("org.eclipse.soda.sat.core.internal.framework.log.events", true);
    private static final String FRAMEWORK_ERROR_EVENT_HAS_OCCURRED_KEY = "FrameworkManager.ErrorEventOccurred";
    private static final String FRAMEWORK_INFO_EVENT_HAS_OCCURRED_KEY = "FrameworkManager.InfoEventOccurred";
    private static final String FRAMEWORK_WARNING_EVENT_HAS_OCCURRED_KEY = "FrameworkManager.WarningEventOccurred";
    private static final String UNKNOWN_BUNDLE_CONTEXT_KEY = "Common.UnknownBundleContext";
    private static final String UNKNOWN_FRAMEWORK_EVENT_KEY = "FrameworkManager.UnknownFrameworkEvent";
    private static final FrameworkManager INSTANCE = new FrameworkManager();
    private BundleContext bundleContext;
    private FrameworkListener frameworkListener;

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        MiscUtility utility = MiscUtility.getInstance();
        boolean value = utility.getBooleanProperty(key, defaultValue);
        return value;
    }

    static FrameworkManager getInstance() {
        return INSTANCE;
    }

    private FrameworkManager() {
        this.setFrameworkListener(this.createFrameworkListener());
    }

    private void checkBundleContextIsNotNull(BundleContext bundleContext) {
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
    }

    private void checkShutdownIsAllowed(BundleContext bundleContext) {
        BundleContext bc = this.getBundleContext();
        if (bundleContext.equals(bc)) {
            return;
        }
        String message = Messages.getString(UNKNOWN_BUNDLE_CONTEXT_KEY);
        throw new IllegalArgumentException(message);
    }

    private FrameworkListener createFrameworkListener() {
        return new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                FrameworkManager.this.frameworkEvent(event);
            }
        };
    }

    private void frameworkEvent(FrameworkEvent event) {
        if (!LOG_EVENTS) {
            return;
        }
        int type = event.getType();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                this.logFrameworkErrorEvent(event);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                this.logFrameworkWarningEvent(event);
                break;
            }
            case 32: {
                this.logFrameworkInfoEvent(event);
                break;
            }
            default: {
                this.logUnknownFrameworkEvent(event);
            }
        }
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private FrameworkListener getFrameworkListener() {
        return this.frameworkListener;
    }

    private void hookupFrameworkListener() {
        BundleContext bundleContext = this.getBundleContext();
        FrameworkListener listener = this.getFrameworkListener();
        bundleContext.addFrameworkListener(listener);
    }

    private boolean isStarted() {
        BundleContext bundleContext = this.getBundleContext();
        boolean started = bundleContext != null;
        return started;
    }

    private void logFrameworkErrorEvent(FrameworkEvent event) {
        String pattern = Messages.getString(FRAMEWORK_ERROR_EVENT_HAS_OCCURRED_KEY);
        Bundle bundle = event.getBundle();
        String message = MessageFormatter.format(pattern, bundle);
        Throwable throwable = event.getThrowable();
        LogUtility.logError(this, message, throwable);
    }

    private void logFrameworkInfoEvent(FrameworkEvent event) {
        String pattern = Messages.getString(FRAMEWORK_INFO_EVENT_HAS_OCCURRED_KEY);
        Bundle bundle = event.getBundle();
        String message = MessageFormatter.format(pattern, bundle);
        Throwable throwable = event.getThrowable();
        LogUtility.logInfo(this, message, throwable);
    }

    private void logFrameworkWarningEvent(FrameworkEvent event) {
        String pattern = Messages.getString(FRAMEWORK_WARNING_EVENT_HAS_OCCURRED_KEY);
        Bundle bundle = event.getBundle();
        String message = MessageFormatter.format(pattern, bundle);
        Throwable throwable = event.getThrowable();
        LogUtility.logWarning(this, message, throwable);
    }

    private void logUnknownFrameworkEvent(FrameworkEvent event) {
        String pattern = Messages.getString(UNKNOWN_FRAMEWORK_EVENT_KEY);
        String message = MessageFormatter.format(pattern, event);
        LogUtility.logDebug(this, message);
    }

    private void setBundleContext(BundleContext bundleContext) {
        if (this.bundleContext != null) {
            this.unhookFrameworkListener();
        }
        this.bundleContext = bundleContext;
        if (this.bundleContext != null) {
            this.hookupFrameworkListener();
        }
    }

    private void setFrameworkListener(FrameworkListener frameworkListener) {
        this.frameworkListener = frameworkListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(BundleContext bundleContext) {
        this.checkBundleContextIsNotNull(bundleContext);
        FrameworkManager frameworkManager = this;
        synchronized (frameworkManager) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.checkShutdownIsAllowed(bundleContext);
            this.setBundleContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startup(BundleContext bundleContext) {
        this.checkBundleContextIsNotNull(bundleContext);
        FrameworkManager frameworkManager = this;
        synchronized (frameworkManager) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setBundleContext(bundleContext);
        }
    }

    private void unhookFrameworkListener() {
        BundleContext bundleContext = this.getBundleContext();
        FrameworkListener listener = this.getFrameworkListener();
        bundleContext.removeFrameworkListener(listener);
    }
}

