/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.sat.core.internal.record.ServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.MiscUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class ExportServiceRecord
extends ServiceRecord
implements IExportServiceRecord {
    private static final String REGISTER_ADDITIONAL_PROPERTIES_PROPERTY = "org.eclipse.soda.sat.core.internal.record.register.additional.properties";
    private static final boolean DEFAULT_REGISTER_ADDITIONAL_PROPERTIES = true;
    private static final boolean REGISTER_ADDITIONAL_PROPERTIES = ExportServiceRecord.getBooleanProperty("org.eclipse.soda.sat.core.internal.record.register.additional.properties", true);
    private static final int PROPERTIES_INITIAL_CAPACITY = 29;
    private String[] names;
    private Dictionary properties;
    private volatile ServiceRegistration registration;

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        MiscUtility utility = MiscUtility.getInstance();
        boolean value = utility.getBooleanProperty(key, defaultValue);
        return value;
    }

    public ExportServiceRecord(BundleContext bundleContext, String[] names, Object service, Dictionary properties) {
        super(bundleContext);
        Assertion.checkArgumentIsNotNull(service, "service");
        this.setNames(names);
        this.setService(service);
        this.setProperties(properties);
        this.setServiceRegistration(null);
    }

    private void basicSetProperties(Dictionary properties) {
        this.properties = properties;
    }

    protected String createServiceFilter() {
        int length = this.estimateServiceFilterLength();
        StringBuffer buffer = new StringBuffer(length);
        this.createServiceFilterOn(buffer);
        String result = buffer.toString();
        return result;
    }

    private void createServiceFilterOn(StringBuffer buffer) {
        String[] names = this.getNames();
        if (names.length == 1) {
            String name = names[0];
            this.createServiceFilterOn(buffer, name);
        } else {
            buffer.append('(');
            buffer.append('|');
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                this.createServiceFilterOn(buffer, name);
                ++i;
            }
            buffer.append(')');
        }
    }

    private int estimateServiceFilterLength() {
        String[] names = this.getNames();
        int size = 3;
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            int length = name.length();
            size += 14 + length;
            ++i;
        }
        return size;
    }

    protected int estimateToStringBufferSize() {
        return super.estimateToStringBufferSize() + 250;
    }

    public String[] getNames() {
        return this.names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getProperties() {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            if (this.properties == null) {
                Hashtable properties = new Hashtable(29);
                this.basicSetProperties(properties);
            }
            return this.properties;
        }
    }

    public Object getProperty(String key) {
        Object property = super.getProperty(key);
        if (property != null) {
            return property;
        }
        Dictionary properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        property = properties.get(key);
        if (property == null) {
            this.signalUnknownProperty(key);
        }
        return property;
    }

    public String[] getPropertyKeys() {
        Collection<Object> collection;
        String[] keys = super.getPropertyKeys();
        int length = keys.length;
        if (length != 0) {
            return keys;
        }
        Dictionary properties = this.getProperties();
        if (properties == null) {
            return ServiceRecord.NO_PROPERTY_KEYS;
        }
        int size = properties.size();
        keys = new String[size];
        if (properties instanceof Hashtable) {
            Hashtable table = (Hashtable)properties;
            collection = table.keySet();
        } else {
            Enumeration enumeration = properties.keys();
            collection = new ArrayList(size);
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                collection.add(key);
            }
        }
        collection.toArray(keys);
        return keys;
    }

    public ServiceReference getServiceReference() {
        ServiceReference reference = null;
        ServiceRegistration registration = this.getServiceRegistration();
        if (registration != null) {
            reference = registration.getReference();
        }
        return reference;
    }

    private ServiceRegistration getServiceRegistration() {
        return this.registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnregisteringService(ServiceReference serviceReference) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.setServiceRegistration(null);
        }
    }

    public boolean isProxy() {
        return false;
    }

    public boolean isRegistered() {
        ServiceRegistration registration = this.getServiceRegistration();
        boolean registered = registration != null;
        return registered;
    }

    private void populateWithAdditionalProperties(Dictionary properties) {
        if (!REGISTER_ADDITIONAL_PROPERTIES) {
            return;
        }
        this.setBundleIdProperty(properties);
        this.setServiceVendorProperty(properties);
        this.setBundleVersionProperty(properties);
        this.setServiceRegistrationTimestampProperty(properties);
    }

    private void printNamesOn(StringBuffer buffer) {
        buffer.append(", names=");
        String[] names = this.getNames();
        int count = names.length;
        int i = 0;
        while (i < count) {
            String name = names[i];
            buffer.append((Object)name);
            if (i < count - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printNamesOn(buffer);
        this.printPropertiesOn(buffer);
        this.printServiceRegistrationOn(buffer);
    }

    private void printPropertiesOn(StringBuffer buffer) {
        Dictionary properties = this.getProperties();
        buffer.append(", properties=");
        buffer.append(properties);
    }

    private void printServiceRegistrationOn(StringBuffer buffer) {
        ServiceRegistration registration = this.getServiceRegistration();
        buffer.append(", registration=");
        this.printOn(buffer, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean registered = this.isRegistered();
            if (registered) {
                return;
            }
            this.registerAsServiceListener();
            this.registerServiceWithFramework();
        }
    }

    private void registerServiceWithFramework() {
        BundleContext bundleContext = this.getBundleContext();
        Object service = this.getService();
        String[] names = this.getNames();
        Dictionary properties = this.getProperties();
        this.populateWithAdditionalProperties(properties);
        ServiceRegistration registration = bundleContext.registerService(names, service, properties);
        this.setServiceRegistration(registration);
    }

    private void setBundleIdProperty(Dictionary properties) {
        String key = "bundle.id";
        Object value = properties.get(key);
        if (value != null) {
            return;
        }
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        long id = bundle.getBundleId();
        value = new Long(id);
        properties.put(key, value);
    }

    private void setBundleVersionProperty(Dictionary properties) {
        String key = "bundle.version";
        Object value = properties.get(key);
        if (value != null) {
            return;
        }
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        value = utility.getBundleVersion(bundle);
        if (value == null) {
            return;
        }
        properties.put(key, value);
    }

    private void setNames(String[] names) {
        Assertion.checkArgumentIsNotNull(names, "names");
        this.names = names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary properties) {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            this.basicSetProperties(properties);
            boolean registered = this.isRegistered();
            if (!registered) {
                return;
            }
            Dictionary registrationProperties = this.getProperties();
            this.populateWithAdditionalProperties(registrationProperties);
            ServiceRegistration registration = this.getServiceRegistration();
            registration.setProperties(registrationProperties);
        }
    }

    private void setServiceRegistration(ServiceRegistration registration) {
        this.registration = registration;
    }

    private void setServiceRegistrationTimestampProperty(Dictionary properties) {
        long now = System.currentTimeMillis();
        Long value = new Long(now);
        properties.put("service.registration.timestamp", value);
    }

    private void setServiceVendorProperty(Dictionary properties) {
        String key = "service.vendor";
        Object value = properties.get(key);
        if (value != null) {
            return;
        }
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        value = utility.getBundleVendor(bundle);
        if (value == null) {
            return;
        }
        properties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean registered = this.isRegistered();
            if (!registered) {
                return;
            }
            this.unregisterServiceWithFramework();
            this.unregisterAsServiceListener();
        }
    }

    private void unregisterServiceWithFramework() {
        ServiceRegistration registration = this.getServiceRegistration();
        try {
            registration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            this.setServiceRegistration(null);
        }
    }
}

