/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.container;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.soda.sat.core.internal.record.container.ServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerLenientOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;
import org.osgi.framework.Filter;

public final class ImportServiceRecordContainer
extends ServiceRecordContainer
implements IImportServiceRecordContainer {
    private static final String[] NO_SERVICE_NAMES = new String[0];
    private static IServiceRecordAction acquireAction;
    private static IServiceRecordAction collectUnacquiredServiceNamesAction;
    private static IServiceRecordAction isAcquiredAction;
    private static IServiceRecordAction releaseAction;
    private boolean acquired;
    private IImportServiceRecordContainerOwner owner;
    private IImportServiceRecordOwner serviceRecordOwner;
    static /* synthetic */ Class class$0;

    private static IServiceRecordAction createAcquireAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                IImportServiceRecordOwner owner = (IImportServiceRecordOwner)parameter;
                importServiceRecord.setOwner(owner);
                importServiceRecord.acquire();
                return true;
            }
        };
    }

    private static IServiceRecordAction createCollectUnacquiredServiceNamesAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                boolean acquired = importServiceRecord.isAcquired();
                if (!acquired) {
                    String name = importServiceRecord.getName();
                    Collection collection = (Collection)parameter;
                    collection.add(name);
                }
                return true;
            }
        };
    }

    private static IServiceRecordAction createIsAcquiredAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                boolean acquired = importServiceRecord.isAcquired();
                return acquired;
            }
        };
    }

    private static IServiceRecordAction createReleaseAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                importServiceRecord.release();
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getAcquireAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (acquireAction == null) {
                ImportServiceRecordContainer.setAcquireAction(ImportServiceRecordContainer.createAcquireAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return acquireAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getCollectUnacquiredServiceNamesAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (collectUnacquiredServiceNamesAction == null) {
                ImportServiceRecordContainer.setCollectUnacquiredServiceNamesAction(ImportServiceRecordContainer.createCollectUnacquiredServiceNamesAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return collectUnacquiredServiceNamesAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getIsAcquiredAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (isAcquiredAction == null) {
                ImportServiceRecordContainer.setIsAcquiredAction(ImportServiceRecordContainer.createIsAcquiredAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return isAcquiredAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getReleaseAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (releaseAction == null) {
                ImportServiceRecordContainer.setReleaseAction(ImportServiceRecordContainer.createReleaseAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return releaseAction;
        }
    }

    private static void setAcquireAction(IServiceRecordAction acquireAction) {
        ImportServiceRecordContainer.acquireAction = acquireAction;
    }

    private static void setCollectUnacquiredServiceNamesAction(IServiceRecordAction collectUnacquiredServiceNamesAction) {
        ImportServiceRecordContainer.collectUnacquiredServiceNamesAction = collectUnacquiredServiceNamesAction;
    }

    private static void setIsAcquiredAction(IServiceRecordAction isAcquiredAction) {
        ImportServiceRecordContainer.isAcquiredAction = isAcquiredAction;
    }

    private static void setReleaseAction(IServiceRecordAction releaseAction) {
        ImportServiceRecordContainer.releaseAction = releaseAction;
    }

    public ImportServiceRecordContainer() {
        this.setAcquired(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean acquired = this.getAcquired();
            if (acquired) {
                return;
            }
            boolean empty = this.isEmpty();
            if (empty) {
                this.setAcquired(true);
                IImportServiceRecordContainerOwner owner = this.getOwner();
                if (owner != null) {
                    owner.acquired(this);
                }
                return;
            }
            IServiceRecordAction action = ImportServiceRecordContainer.getAcquireAction();
            IImportServiceRecordOwner serviceRecordOwner = this.getServiceRecordOwner();
            this.doForEach(action, serviceRecordOwner);
            IImportServiceRecordContainerOwner owner = this.getOwner();
            boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
            if (!lenient) {
                return;
            }
            this.setAcquired(true);
            if (owner != null) {
                owner.acquired(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IImportServiceRecord record) {
        boolean added;
        Object lock;
        Assertion.checkArgumentIsNotNull(record, "record");
        Object object = lock = this.getLock();
        synchronized (object) {
            String name = record.getName();
            added = this.add(name, record);
            boolean acquired = this.getAcquired();
            if (acquired) {
                IImportServiceRecordOwner owner = this.getServiceRecordOwner();
                record.setOwner(owner);
                record.acquire();
                boolean recordAcquired = record.isAcquired();
                if (!recordAcquired) {
                    this.serviceReleased(record);
                }
            }
        }
        return added;
    }

    private IImportServiceRecordOwner createServiceRecordOwner() {
        return new IImportServiceRecordOwner(){

            public Object getLock() {
                return ImportServiceRecordContainer.this.getLock();
            }

            public void serviceAcquired(IImportServiceRecord record) {
                ImportServiceRecordContainer.this.serviceAcquired(record);
            }

            public void serviceReleased(IImportServiceRecord record) {
                ImportServiceRecordContainer.this.serviceReleased(record);
            }
        };
    }

    protected int createStringBufferSize() {
        return super.createStringBufferSize() + 100;
    }

    protected int createTableCapacity() {
        return 10;
    }

    private boolean getAcquired() {
        return this.acquired;
    }

    private Object getLock() {
        return this;
    }

    private IImportServiceRecordContainerOwner getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportServiceRecordOwner getServiceRecordOwner() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (this.serviceRecordOwner == null) {
                IImportServiceRecordOwner owner = this.createServiceRecordOwner();
                this.setServiceRecordOwner(owner);
            }
            return this.serviceRecordOwner;
        }
    }

    public String[] getUnacquiredServiceNames() {
        int sizeHint = this.basicSize();
        ArrayList names = new ArrayList(sizeHint);
        IServiceRecordAction action = ImportServiceRecordContainer.getCollectUnacquiredServiceNamesAction();
        this.doForEach(action, names);
        int size = names.size();
        if (size == 0) {
            return NO_SERVICE_NAMES;
        }
        String[] result = new String[size];
        names.toArray(result);
        return result;
    }

    public IImportServiceRecord getWithFilter(String name, Filter filter) {
        IImportServiceRecord record = null;
        if (filter == null) {
            record = (IImportServiceRecord)this.get(name);
        } else {
            boolean found = false;
            IServiceRecord[] records = this.getAll(name);
            int length = records.length;
            int index = 0;
            while (!found && index < length) {
                record = (IImportServiceRecord)records[index];
                Filter recordFilter = record.getFilter();
                found = filter.equals((Object)recordFilter);
                ++index;
            }
            record = found ? record : null;
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcquired() {
        Object lock;
        boolean acquired = false;
        Object object = lock = this.getLock();
        synchronized (object) {
            acquired = this.getAcquired();
            if (!acquired) {
                IServiceRecordAction action = ImportServiceRecordContainer.getIsAcquiredAction();
                acquired = this.doForEach(action, null);
            }
        }
        return acquired;
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        IImportServiceRecordContainerOwner owner = this.getOwner();
        buffer.append(", owner=");
        buffer.append(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean empty = this.isEmpty();
            if (empty) {
                this.setAcquired(false);
                IImportServiceRecordContainerOwner owner = this.getOwner();
                if (owner != null) {
                    owner.released(this);
                }
                return;
            }
            IServiceRecordAction action = ImportServiceRecordContainer.getReleaseAction();
            this.doForEach(action, null);
            IImportServiceRecordContainerOwner owner = this.getOwner();
            boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
            if (!lenient) {
                return;
            }
            this.setAcquired(false);
            if (owner != null) {
                owner.released(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IImportServiceRecord record) {
        boolean removed;
        Object lock;
        Assertion.checkArgumentIsNotNull(record, "record");
        String name = record.getName();
        Object object = lock = this.getLock();
        synchronized (object) {
            removed = this.remove(name, record);
            if (removed) {
                record.setOwner(null);
                record.release();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(String name) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            block5: {
                boolean acquired = this.getAcquired();
                if (!acquired) break block5;
                return false;
            }
            IServiceRecord[] records = this.getAll(name);
            int length = records.length;
            boolean removed = true;
            int index = 0;
            while (removed && index < length) {
                IImportServiceRecord record = (IImportServiceRecord)records[index];
                removed = this.remove(record);
                ++index;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceAcquired(IImportServiceRecord record) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            IImportServiceRecordContainerOwner owner = this.getOwner();
            boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
            if (lenient) {
                IImportServiceRecordContainerLenientOwner lenientOwner = (IImportServiceRecordContainerLenientOwner)owner;
                lenientOwner.serviceAcquired(this, record);
            } else {
                boolean acquired = this.isAcquired();
                if (!acquired) {
                    return;
                }
                this.setAcquired(true);
                if (owner != null) {
                    owner.acquired(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceReleased(IImportServiceRecord record) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            IImportServiceRecordContainerOwner owner = this.getOwner();
            boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
            if (lenient) {
                IImportServiceRecordContainerLenientOwner lenientOwner = (IImportServiceRecordContainerLenientOwner)owner;
                this.setAcquired(false);
                lenientOwner.serviceReleased(this, record);
            } else {
                boolean acquired = this.getAcquired();
                if (!acquired) {
                    return;
                }
                this.setAcquired(false);
                if (owner != null) {
                    owner.released(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAcquired(boolean acquired) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.acquired = acquired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(IImportServiceRecordContainerOwner owner) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.owner = owner;
        }
    }

    private void setServiceRecordOwner(IImportServiceRecordOwner serviceRecordOwner) {
        this.serviceRecordOwner = serviceRecordOwner;
    }
}

