/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.soda.sat.core.framework.interfaces.IFileLog;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;

public class FileLog
implements IFileLog {
    private static final String CREATED_LOG_FILE_KEY = "FileLog.CreatedLogFile";
    private static final String FILE_IS_NOT_OPEN_KEY = "FileLog.FileIsNotOpen";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final Long DEFAULT_TIME_WRAPPER = new Long(0L);
    private File file;
    private ILineWriter writer;
    private ThreadLocal threadLocal;
    private final Object lock = new Object();

    public FileLog(File file) {
        this.setFile(file);
    }

    private void checkIsOpen() throws IOException {
        boolean open = this.isOpen();
        if (open) {
            return;
        }
        String path = this.getAbsolutePath();
        String pattern = Messages.getString(FILE_IS_NOT_OPEN_KEY);
        String message = MessageFormatter.format(pattern, path);
        throw new IOException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean open = this.isOpen();
            if (!open) {
                return;
            }
            this.setThreadLocal(null);
            ILineWriter writer = this.getWriter();
            writer.close();
            this.setWriter(null);
        }
    }

    private ILineWriter createLineWriter() throws FileNotFoundException {
        File file = this.getFile();
        String path = file.getAbsolutePath();
        FileOutputStream outputStream = new FileOutputStream(path, false);
        String component = Messages.getString(SAT_CORE_KEY);
        String pattern = Messages.getString(CREATED_LOG_FILE_KEY);
        String message = MessageFormatter.format(pattern, path);
        LogUtility.logInfo((Object)component, message);
        FactoryUtility utility = FactoryUtility.getInstance();
        ILineWriter writer = utility.createLineWriter(outputStream);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() throws IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            File file;
            block4: {
                this.close();
                file = this.getFile();
                boolean exists = file.exists();
                if (exists) break block4;
                return true;
            }
            boolean deleted = file.delete();
            return deleted;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private String formatId(Object id) {
        Class<?> clazz;
        String qualifiedClassName;
        String value = id.toString();
        boolean match = value.startsWith(qualifiedClassName = (clazz = id.getClass()).getName());
        if (match) {
            int index = value.lastIndexOf(46) + 1;
            value = value.substring(index);
        }
        return value;
    }

    public String getAbsolutePath() {
        File file = this.getFile();
        String path = file.getAbsolutePath();
        return path;
    }

    private File getFile() {
        return this.file;
    }

    public String getFilename() {
        File file = this.getFile();
        String name = file.getName();
        return name;
    }

    private Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadLocal getThreadLocal() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (this.threadLocal == null) {
                ThreadLocal threadLocal = new ThreadLocal();
                this.setThreadLocal(threadLocal);
            }
            return this.threadLocal;
        }
    }

    private Long getTime() {
        ThreadLocal threadLocal = this.getThreadLocal();
        Long timeWrapper = (Long)threadLocal.get();
        if (timeWrapper == null) {
            timeWrapper = DEFAULT_TIME_WRAPPER;
            this.setTime(timeWrapper);
        }
        return timeWrapper;
    }

    private ILineWriter getWriter() {
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpen() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            ILineWriter writer = this.getWriter();
            boolean open = writer != null;
            return open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Object id, String message) throws IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.checkIsOpen();
            this.logMessage(id, message);
        }
    }

    private void logMessage(Object id, String message) throws IOException {
        Long timeWrapper = this.getTime();
        long time = timeWrapper;
        long now = System.currentTimeMillis();
        String nowValue = Long.toString(now);
        Long nowWrapper = new Long(now);
        this.setTime(nowWrapper);
        long duration = time == 0L ? 0L : now - time;
        String durationValue = Long.toString(duration);
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        String formattedId = this.formatId(id);
        String delimiter = ", ";
        ILineWriter writer = this.getWriter();
        writer.write(nowValue);
        writer.write(delimiter);
        writer.write(durationValue);
        writer.write(delimiter);
        writer.write(threadName);
        writer.write(delimiter);
        writer.write(formattedId);
        writer.write(delimiter);
        writer.write(message);
        writer.newLine();
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws FileNotFoundException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean open = this.isOpen();
            if (open) {
                return;
            }
            ILineWriter writer = this.createLineWriter();
            this.setWriter(writer);
        }
    }

    private void setFile(File file) {
        Assertion.checkArgumentIsNotNull(file, "file");
        this.file = file;
    }

    private void setThreadLocal(ThreadLocal threadLocal) {
        this.threadLocal = threadLocal;
    }

    private void setTime(Long timeWrapper) {
        ThreadLocal threadLocal = this.getThreadLocal();
        threadLocal.set(timeWrapper);
    }

    private void setWriter(ILineWriter writer) {
        this.writer = writer;
    }

    public String toString() {
        File file = this.getFile();
        String path = file.getAbsolutePath();
        return path;
    }
}

