/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;

public class LineWriter
implements ILineWriter {
    private static final int EIGHT_K_BYTES = 8192;
    private static final String UTF8_CHARACTER_ENCODING = "UTF-8";
    private static final String DEFAULT_CHARACTER_ENCODING = System.getProperty("file.encoding", "UTF-8");
    private BufferedWriter bufferedWriter;

    public LineWriter(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public LineWriter(OutputStream outputStream, int size) {
        this(outputStream, DEFAULT_CHARACTER_ENCODING, size);
    }

    public LineWriter(OutputStream outputStream, String characterEncoding) {
        this(outputStream, characterEncoding, 8192);
    }

    public LineWriter(OutputStream outputStream, String characterEncoding, int size) {
        this.setBufferWriter(this.createBufferedWriter(outputStream, characterEncoding, size));
    }

    public void close() throws IOException {
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        bufferedWriter.close();
    }

    private BufferedWriter createBufferedWriter(OutputStream outputStream, String encoding, int size) {
        OutputStreamWriter outputStreamWriter;
        Assertion.checkArgumentIsNotNull(outputStream, "outputStream");
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException exception) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, size);
        return bufferedWriter;
    }

    public void flush() throws IOException {
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        bufferedWriter.flush();
    }

    private BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public void newLine() throws IOException {
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        bufferedWriter.newLine();
    }

    private void setBufferWriter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public void write(String line) throws IOException {
        Assertion.checkArgumentIsNotNull(line, "line");
        BufferedWriter bufferedWriter = this.getBufferedWriter();
        int length = line.length();
        bufferedWriter.write(line, 0, length);
    }

    public void writeLine(String line) throws IOException {
        this.write(line);
        this.newLine();
    }
}

