/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.internal.dependency.servlet.bundle;

import java.util.Set;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.internal.dependency.model.BundleDependencyModel;
import org.eclipse.soda.sat.internal.dependency.servlet.BundleDependencyServlet;
import org.eclipse.soda.sat.internal.dependency.servlet.bundle.AbstractDependencyActivator;
import org.osgi.service.http.HttpService;

public class BundleDependencyServletActivator
extends AbstractDependencyActivator {
    private static final String HTTP_SERVICE_NAME;
    private BundleDependencyServlet servlet;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HTTP_SERVICE_NAME = clazz.getName();
    }

    protected void activate() {
        super.activate();
        BundleDependencyServlet servlet = new BundleDependencyServlet();
        this.setServlet(servlet);
        HttpService http = this.getHttpService();
        String port = this.getHttpServicePort();
        BundleDependencyModel model = this.getModel();
        servlet.bind(http, port, model);
    }

    protected void collectImportedServiceNames(Set serviceNames) {
        super.collectImportedServiceNames(serviceNames);
        serviceNames.add(HTTP_SERVICE_NAME);
    }

    protected void deactivate() {
        BundleDependencyServlet servlet = this.getServlet();
        servlet.unbind();
        this.setServlet(null);
        super.deactivate();
    }

    private HttpService getHttpService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (HttpService)this.getImportedService(clazz.getName());
    }

    private String getHttpServicePort() {
        String value;
        try {
            Object wrapper = this.getImportedServiceProperty(HTTP_SERVICE_NAME, "http.port");
            value = wrapper.toString();
        }
        catch (IllegalArgumentException exception) {
            value = null;
            String message = exception.getMessage();
            LogUtility.logDebug((Object)((Object)this), (String)message);
        }
        return value;
    }

    private BundleDependencyServlet getServlet() {
        return this.servlet;
    }

    private void setServlet(BundleDependencyServlet servlet) {
        this.servlet = servlet;
    }
}

