/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.internal.junit;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.runner.Version;
import junit.textui.TestRunner;
import org.eclipse.soda.sat.internal.junit.Queue;
import org.eclipse.soda.sat.junit.service.TestRunnerServerService;

public class TestRunnerServer
implements TestRunnerServerService {
    private boolean running;
    private Queue queue;
    private Thread thread;
    private final Object startupLock = new Object();

    public TestRunnerServer() {
        this.setQueue(new Queue());
    }

    private boolean canShutdown() {
        if (this.hasTests()) {
            return false;
        }
        return !this.isRunning();
    }

    private Runnable createRunnable() {
        Runnable runnable = new Runnable(){

            public void run() {
                TestRunnerServer server = TestRunnerServer.this;
                try {
                    while (!server.canShutdown()) {
                        server.process();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        return runnable;
    }

    private Queue getQueue() {
        return this.queue;
    }

    private Object getStartupLock() {
        return this.startupLock;
    }

    private Thread getThread() {
        return this.thread;
    }

    private boolean hasTests() {
        Queue queue = this.getQueue();
        boolean result = !queue.isEmpty();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        TestRunnerServer testRunnerServer = this;
        synchronized (testRunnerServer) {
            return this.running;
        }
    }

    private void printTestName(Test test) {
        if (!(test instanceof TestSuite)) {
            return;
        }
        TestSuite suite = (TestSuite)test;
        String name = suite.getName();
        System.out.print("JUnit ");
        System.out.print(Version.id());
        System.out.print(" - Running Test Suite: ");
        System.out.println(name);
    }

    private void process() throws InterruptedException {
        Queue queue = this.getQueue();
        Test test = (Test)queue.remove();
        this.printTestName(test);
        TestRunner.run((Test)test);
    }

    public void run(Test test) {
        Queue queue = this.getQueue();
        queue.add(test);
    }

    private void setQueue(Queue queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean running) {
        TestRunnerServer testRunnerServer = this;
        synchronized (testRunnerServer) {
            this.running = running;
        }
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object lock;
        Object object = lock = this.getStartupLock();
        synchronized (object) {
            boolean running = this.isRunning();
            if (!running) {
                return;
            }
            this.setRunning(false);
            this.shutdownThread();
            this.setQueue(null);
        }
    }

    private void shutdownThread() {
        Thread thread = this.getThread();
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.setThread(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        Object lock;
        Object object = lock = this.getStartupLock();
        synchronized (object) {
            boolean running = this.isRunning();
            if (running) {
                return;
            }
            this.setRunning(true);
            this.startupThread();
        }
    }

    private void startupThread() {
        Runnable runnable = this.createRunnable();
        Thread thread = new Thread(runnable, "TestRunnerServer");
        this.setThread(thread);
        thread.start();
    }
}

