/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.log.writer.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogWriter {
    private static final String THRESHOLD_PROPERTY = "org.eclipse.soda.sat.log.writer.internal.threshold";
    private static final String DEBUG_THRESHOLD_STRING = "debug";
    private static final String INFO_THRESHOLD_STRING = "info";
    private static final String WARNING_THRESHOLD_STRING = "warning";
    private static final String ERROR_THRESHOLD_STRING = "error";
    private static final int DEBUG_THRESHOLD = 0;
    private static final int INFO_THRESHOLD = 1;
    private static final int WARNING_THRESHOLD = 2;
    private static final int ERROR_THRESHOLD = 3;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int threshold;
    private LogReaderService reader;
    private LogListener listener;
    private ICharBuffer buffer;

    public LogWriter() {
        this.initialize();
        this.setBuffer(this.createBuffer());
    }

    public void bind(LogReaderService reader) {
        this.setReader(reader);
        this.startup();
    }

    private ICharBuffer createBuffer() {
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(250);
        return buffer;
    }

    private LogListener createListener() {
        return new LogListener(){

            public void logged(LogEntry entry) {
                LogWriter.this.logged(entry);
            }
        };
    }

    private void drainLog() {
        LogEntry entry;
        LogReaderService reader = this.getReader();
        Enumeration enumeration = reader.getLog();
        ArrayList<LogEntry> list = new ArrayList<LogEntry>(100);
        while (enumeration.hasMoreElements()) {
            entry = (LogEntry)enumeration.nextElement();
            list.add(entry);
        }
        int size = list.size();
        int i = size - 1;
        while (i >= 0) {
            entry = (LogEntry)list.get(i);
            this.logged(entry);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatLogMessage(ServiceReference reference, int level, String message) {
        String logMessage;
        ICharBuffer buffer;
        String levelText = this.getLevelText(level);
        ICharBuffer iCharBuffer = buffer = this.getBuffer();
        synchronized (iCharBuffer) {
            buffer.setLength(0);
            buffer.append('[');
            buffer.append(levelText);
            buffer.append(']');
            buffer.append(' ');
            buffer.append(message);
            if (reference != null) {
                List names;
                boolean empty;
                Bundle bundle = reference.getBundle();
                if (bundle != null) {
                    String symbolicName = bundle.getSymbolicName();
                    long id = bundle.getBundleId();
                    buffer.append(',');
                    buffer.append("bundle");
                    buffer.append('=');
                    buffer.append(symbolicName);
                    buffer.append(' ');
                    buffer.append('[');
                    buffer.append(id);
                    buffer.append(']');
                }
                if (!(empty = (names = this.getServiceNames(reference)).isEmpty())) {
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append("services");
                    buffer.append('=');
                    buffer.append('[');
                    Iterator iterator = names.iterator();
                    while (iterator.hasNext()) {
                        Object name = iterator.next();
                        buffer.append(name);
                        if (!iterator.hasNext()) continue;
                        buffer.append(',');
                        buffer.append(' ');
                    }
                    buffer.append(']');
                }
            }
            buffer.append(LINE_SEPARATOR);
            logMessage = buffer.toString();
        }
        return logMessage;
    }

    private ICharBuffer getBuffer() {
        return this.buffer;
    }

    private String getLevelText(int level) {
        String text;
        switch (level) {
            case 1: {
                text = "ERROR";
                break;
            }
            case 2: {
                text = "WARNING";
                break;
            }
            case 3: {
                text = "INFO";
                break;
            }
            case 4: {
                text = "DEBUG";
                break;
            }
            default: {
                text = "<UNKNOWN>";
            }
        }
        return text;
    }

    private LogListener getListener() {
        return this.listener;
    }

    private OutputStream getOutputStream(int level) {
        PrintStream stream = level == 3 || level == 4 ? System.out : System.err;
        return stream;
    }

    private LogReaderService getReader() {
        return this.reader;
    }

    private List getServiceNames(ServiceReference reference) {
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        List names = utility.getServiceNames(reference);
        return names;
    }

    private int getThreshold() {
        return this.threshold;
    }

    private void initialize() {
        int threshold;
        String value = System.getProperty(THRESHOLD_PROPERTY, DEBUG_THRESHOLD_STRING);
        if (DEBUG_THRESHOLD_STRING.equalsIgnoreCase(value)) {
            threshold = 0;
        } else if (INFO_THRESHOLD_STRING.equalsIgnoreCase(value)) {
            threshold = 1;
        } else if (WARNING_THRESHOLD_STRING.equalsIgnoreCase(value)) {
            threshold = 2;
        } else if (ERROR_THRESHOLD_STRING.equalsIgnoreCase(value)) {
            threshold = 3;
        } else {
            throw new RuntimeException("Illegal threshold property value: org.eclipse.soda.sat.log.writer.internal.threshold=" + value);
        }
        this.setThreshold(threshold);
        LogUtility.setLoggingLevel((int)4);
    }

    private void logged(LogEntry entry) {
        int level = entry.getLevel();
        int threshold = this.getThreshold();
        OutputStream stream = this.getOutputStream(level);
        switch (level) {
            case 1: {
                if (threshold > 3) break;
                this.logToStream(entry, stream);
                break;
            }
            case 2: {
                if (threshold > 2) break;
                this.logToStream(entry, stream);
                break;
            }
            case 3: {
                if (threshold > 1) break;
                this.logToStream(entry, stream);
                break;
            }
            case 4: {
                if (threshold > 0) break;
                this.logToStream(entry, stream);
                break;
            }
        }
    }

    private void logToStream(LogEntry entry, OutputStream stream) {
        ServiceReference reference = entry.getServiceReference();
        int level = entry.getLevel();
        String message = entry.getMessage();
        String logMessage = this.formatLogMessage(reference, level, message);
        byte[] bytes = logMessage.getBytes();
        try {
            stream.write(bytes);
            stream.flush();
            Throwable throwable = entry.getException();
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void setBuffer(ICharBuffer buffer) {
        this.buffer = buffer;
    }

    private void setListener(LogListener listener) {
        LogReaderService reader = this.getReader();
        if (this.listener != null) {
            reader.removeLogListener(this.listener);
        }
        this.listener = listener;
        if (this.listener != null) {
            reader.addLogListener(this.listener);
        }
    }

    private void setReader(LogReaderService reader) {
        this.reader = reader;
    }

    private void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        LogListener listener = this.getListener();
        LogWriter logWriter = this;
        synchronized (logWriter) {
            if (listener == null) {
                return;
            }
            this.setListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup() {
        LogWriter logWriter = this;
        synchronized (logWriter) {
            if (this.listener != null) {
                return;
            }
            LogListener listener = this.createListener();
            this.setListener(listener);
        }
        this.drainLog();
    }

    public void unbind() {
        this.shutdown();
        this.setReader(null);
    }
}

