/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.internal.Field;
import org.eclipse.soda.sat.plugin.activator.internal.Method;
import org.eclipse.soda.sat.plugin.activator.internal.Parameter;
import org.eclipse.soda.sat.plugin.activator.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.util.ITypeModel;
import org.eclipse.soda.sat.plugin.activator.util.TypeNameSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivatorGenerator {
    private static final String UNRECOGNIZED_LOAD_PROPERTIES_POLICY_KEY = "ActivatorGenerator.UnrecognizedLoadPropertiesPolicy";
    private static final String UNRECOGNIZED_START_ASYNCHRONOUSLY_PRIORITY_DELTA_KEY = "ActivatorGenerator.UnrecognizedStartAsynchronouslyPriorityDelta";
    private static final String UNRECOGNIZED_UNINSTALL_POLICY_KEY = "ActivatorGenerator.UnrecognizedUninstallPolicy";
    private static final char INDENT = '\t';
    private static final char SPACE = ' ';
    private static final String JKW_CLASS = "class";
    private static final String JKW_ELSE = "else";
    private static final String JKW_EXTENDS = "extends";
    private static final String JKW_IF = "if";
    private static final String JKW_IMPORT = "import";
    private static final String JKW_NEW = "new";
    private static final String JKW_NULL = "null";
    private static final String JKW_PACKAGE = "package";
    private static final String JKW_PRIVATE = "private";
    private static final String JKW_PROTECTED = "protected";
    private static final String JKW_PUBLIC = "public";
    private static final String JKW_RETURN = "return";
    private static final String JKW_SUPER = "super";
    private static final String JKW_THIS = "this";
    private static final String JKW_THROWS = "throws";
    private static final String JKW_TRUE = "true";
    private static final String TN_BASE_BUNDLE_ACTIVATOR = "org.eclipse.soda.sat.core.framework.BaseBundleActivator";
    private static final String TN_DICTIONARY = "java.util.Dictionary";
    private static final String TN_HASHTABLE = "java.util.Hashtable";
    private static final String TN_IPROXY_SERVICE_HANDLER = "org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler";
    private static final String TN_INPUT_STREAM = "java.io.InputStream";
    private static final String TN_IO_EXCEPTION = "java.io.IOException";
    private static final String TN_OBJECT = "Object";
    private static final String TN_PROXY_SERVICE_HANDLER_ADAPTER = "org.eclipse.soda.sat.core.framework.ProxyServiceHandlerAdapter";
    private static final String TN_STRING = "String";
    private static final String TN_THREAD = "Thread";
    private static final String MN_ACTIVATE = "activate";
    private static final String MN_ADD_EXPORTED_PROXY_SERVICE = "addExportedProxyService";
    private static final String MN_ADD_EXPORTED_SERVICE = "addExportedService";
    private static final String MN_ADD_OPTIONAL_IMPORTED_SERVICE_FILTER = "addOptionalImportedServiceFilter";
    private static final String MN_ADD_IMPORTED_SERVICE_FILTER = "addImportedServiceFilter";
    private static final String MN_CREATE_SERVICE = "createService";
    private static final String MN_DEACTIVATE = "deactivate";
    private static final String MN_EQUALS = "equals";
    private static final String MN_GET_ASYNC_START_PRIORITY = "getAsyncStartPriority";
    private static final String MN_GET_OPTIONAL_IMPORTED_SERVICE_NAMES = "getOptionalImportedServiceNames";
    private static final String MN_GET_FILE_PROPERTIES_INPUT_STREAM = "getFilePropertiesInputStream";
    private static final String MN_GET_IMPORTED_SERVICE = "getImportedService";
    private static final String MN_GET_IMPORTED_SERVICE_NAMES = "getImportedServiceNames";
    private static final String MN_GET_NAME = "getName";
    private static final String MN_GET_PROPERTIES_INPUT_STREAM = "getPropertiesInputStream";
    private static final String MN_GET_RESOURCE_PROPERTIES_INPUT_STREAM = "getResourcePropertiesInputStream";
    private static final String MN_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE = "handleAcquiredOptionalImportedService";
    private static final String MN_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE = "handleReleasedOptionalImportedService";
    private static final String MN_IS_START_ASYNC = "isStartAsync";
    private static final String MN_IS_TRANSIENT = "isTransient";
    private static final String MN_IS_UNINSTALLABLE = "isUninstallable";
    private static final String MN_START = "start";
    private static final String MN_STOP = "stop";
    private static final char JT_CLOSE_BRACE = '}';
    private static final char JT_CLOSE_BRACKET = ']';
    private static final char JT_CLOSE_PARENTHESIS = ')';
    private static final char JT_COMMA = ',';
    private static final String JT_COMMENT_LINE = "//";
    private static final char JT_DOT = '.';
    private static final char JT_EQUAL = '=';
    private static final char JT_MINUS = '-';
    private static final char JT_OPEN_BRACE = '{';
    private static final char JT_OPEN_BRACKET = '[';
    private static final char JT_OPEN_PARENTHESIS = '(';
    private static final char JT_PLUS = '+';
    private static final char JT_QUOTE = '\"';
    private static final char JT_SEMICOLON = ';';
    private static final String JT_ARRAY_DECLARATION = "[]";
    private static final String JT_NON_NSL_COMMENT_LINE = "//$NON-NLS-1$";
    private static final String JT_TODO_COMMENT_LINE = "// TODO ";
    private static final String VN_HANDLER = "handler";
    private static final String VN_PROPERTIES = "properties";
    private static final String VN_SERVICE = "service";
    private static final String VN_SERVICE_NAME = "serviceName";
    private static final String JAVA_LANG_PACKAGE_PREFIX = "java.lang.";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Map<String, String> importedTypes;
    private List<Method> methods;
    private List<Field> fields;
    private ITypeModel typeModel;
    private IActivatorWizardModel wizardModel;

    ActivatorGenerator(IActivatorWizardModel model, ITypeModel typeModel) {
        this.setWizardModel(model);
        this.setTypeModel(typeModel);
        this.setImportedTypes(new HashMap<String, String>(31));
        this.setMethods(new ArrayList<Method>(25));
        this.setFields(new ArrayList<Field>(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addField(Field field) {
        List<Field> fields;
        List<Field> list = fields = this.getFields();
        synchronized (list) {
            boolean exists = fields.contains(field);
            if (exists) {
                return;
            }
            fields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addImportedType(String typeName) {
        Map<String, String> map;
        if (typeName == null) {
            return null;
        }
        if (typeName.indexOf(46) == -1) {
            return typeName;
        }
        String unqualifiedTypeName = this.toUnqualifiedTypeName(typeName);
        String typeNamePackage = this.toPackageName(typeName);
        if (typeNamePackage.equals(JAVA_LANG_PACKAGE_PREFIX)) {
            return unqualifiedTypeName;
        }
        IActivatorWizardModel model = this.getWizardModel();
        String packageName = model.getPackageName();
        if (packageName != null && packageName.length() != 0 && typeName.startsWith(packageName)) {
            return unqualifiedTypeName;
        }
        Map<String, String> map2 = map = this.getImportedTypes();
        synchronized (map2) {
            String value = map.get(unqualifiedTypeName);
            boolean match = typeName.equals(value);
            if (match) {
                return unqualifiedTypeName;
            }
            if (value == null) {
                map.put(unqualifiedTypeName, typeName);
                return unqualifiedTypeName;
            }
            return typeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMethod(Method method) {
        List<Method> methods;
        List<Method> list = methods = this.getMethods();
        synchronized (list) {
            boolean exists = methods.contains(method);
            if (exists) {
                return;
            }
            methods.add(method);
        }
    }

    private void buildActivateAndDeactivateMethods() {
        IActivatorWizardModel model = this.getWizardModel();
        boolean build = model.getCustomActivateAndDeactivate();
        if (!build) {
            return;
        }
        this.buildActivateMethod();
        this.buildDeactivateMethod();
    }

    private void buildActivateMethod() {
        String methodName = MN_ACTIVATE;
        Method method = new Method(methodName);
        method.beProtected();
        StringBuffer buffer = new StringBuffer(75);
        IActivatorWizardModel model = this.getWizardModel();
        boolean hasExportedServices = model.hasExportedServices();
        if (hasExportedServices) {
            List<IExportedServiceDetails> allExportedServices = model.getExportedServicesDetails();
            int size = allExportedServices.size();
            if (size == 1) {
                IExportedServiceDetails details = allExportedServices.get(0);
                if (details.isProxy()) {
                    this.buildAddExportedProxyServiceOn(buffer, details);
                } else {
                    this.buildAddExportedServiceOn(buffer, details);
                }
            } else {
                for (IExportedServiceDetails details : allExportedServices) {
                    Method addExportedServiceMethod = this.buildAddExportedService(details);
                    String name = addExportedServiceMethod.getName();
                    this.indent(buffer, 2);
                    buffer.append(name);
                    buffer.append('(');
                    buffer.append(')');
                    buffer.append(';');
                }
            }
        } else {
            this.indent(buffer, 2);
            buffer.append(JT_TODO_COMMENT_LINE);
            buffer.append("Implement");
            this.space(buffer);
            buffer.append(methodName);
            buffer.append('(');
            buffer.append(')');
        }
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private void buildAddExportedProxyServiceOn(StringBuffer buffer, IExportedServiceDetails details) {
        String implementationClassName = null;
        IType type = details.getImplementationClass();
        if (type != null) {
            String fullyQualifiedImplementationClassName = type.getFullyQualifiedName();
            this.addImportedType(fullyQualifiedImplementationClassName);
            implementationClassName = this.toUnqualifiedTypeName(fullyQualifiedImplementationClassName);
        }
        boolean storedInField = details.isStoredInField();
        boolean hasProperties = details.hasProperties();
        String proxyServiceHandlerType = this.addImportedType(TN_IPROXY_SERVICE_HANDLER);
        String proxyServiceHandlerAdapterType = this.addImportedType(TN_PROXY_SERVICE_HANDLER_ADAPTER);
        this.indent(buffer, 2);
        buffer.append(proxyServiceHandlerType);
        this.space(buffer);
        buffer.append(VN_HANDLER);
        this.space(buffer);
        buffer.append('=');
        this.space(buffer);
        buffer.append(JKW_NEW);
        this.space(buffer);
        buffer.append(proxyServiceHandlerAdapterType);
        buffer.append('(');
        buffer.append(')');
        this.space(buffer);
        buffer.append('{');
        this.indent(buffer, 3);
        buffer.append(JKW_PUBLIC);
        this.space(buffer);
        buffer.append(TN_OBJECT);
        this.space(buffer);
        buffer.append(MN_CREATE_SERVICE);
        buffer.append('(');
        buffer.append(')');
        this.space(buffer);
        buffer.append('{');
        if (implementationClassName == null) {
            this.indent(buffer, 4);
            buffer.append(JT_TODO_COMMENT_LINE);
            buffer.append("Initialize service");
        }
        this.indent(buffer, 4);
        String name = details.getName();
        String typeName = this.toUnqualifiedTypeName(name);
        String fieldName = null;
        String className = null;
        if (storedInField) {
            String fieldTypeName = implementationClassName == null ? typeName : this.toUnqualifiedTypeName(implementationClassName);
            fieldName = this.toFieldName(typeName);
            Field field = new Field(fieldTypeName, fieldName);
            this.addField(field);
            IActivatorWizardModel model = this.getWizardModel();
            className = model.getClassName();
            buffer.append(className);
            buffer.append('.');
            buffer.append(JKW_THIS);
            buffer.append('.');
            buffer.append(fieldName);
        } else {
            buffer.append(typeName);
            this.space(buffer);
            buffer.append(VN_SERVICE);
        }
        this.space(buffer);
        buffer.append('=');
        this.space(buffer);
        if (implementationClassName == null) {
            buffer.append(JKW_NULL);
        } else {
            buffer.append(JKW_NEW);
            this.space(buffer);
            buffer.append(implementationClassName);
            buffer.append('(');
            buffer.append(')');
        }
        buffer.append(';');
        this.indent(buffer, 4);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        if (storedInField) {
            buffer.append(className);
            buffer.append('.');
            buffer.append(JKW_THIS);
            buffer.append('.');
            buffer.append(fieldName);
        } else {
            buffer.append(VN_SERVICE);
        }
        buffer.append(';');
        this.indent(buffer, 3);
        buffer.append('}');
        this.indent(buffer, 2);
        buffer.append('}');
        buffer.append(';');
        this.newLine(buffer);
        if (hasProperties) {
            String hashtableType = this.addImportedType(TN_HASHTABLE);
            String dictionaryType = this.addImportedType(TN_DICTIONARY);
            this.indent(buffer, 2);
            buffer.append(JT_TODO_COMMENT_LINE);
            buffer.append("Initialize properties");
            this.indent(buffer, 2);
            buffer.append(dictionaryType);
            this.space(buffer);
            buffer.append(VN_PROPERTIES);
            this.space(buffer);
            buffer.append('=');
            this.space(buffer);
            buffer.append(JKW_NEW);
            this.space(buffer);
            buffer.append(hashtableType);
            buffer.append('(');
            buffer.append(17);
            buffer.append(')');
            buffer.append(';');
        }
        this.indent(buffer, 2);
        buffer.append(MN_ADD_EXPORTED_PROXY_SERVICE);
        buffer.append('(');
        buffer.append(typeName);
        buffer.append('.');
        buffer.append(JKW_CLASS);
        buffer.append(',');
        this.space(buffer);
        buffer.append(VN_HANDLER);
        buffer.append(',');
        this.space(buffer);
        if (hasProperties) {
            buffer.append(VN_PROPERTIES);
        } else {
            buffer.append(JKW_NULL);
        }
        buffer.append(')');
        buffer.append(';');
    }

    private Method buildAddExportedService(IExportedServiceDetails details) {
        String serviceName = details.getName();
        this.addImportedType(serviceName);
        String typeName = this.toUnqualifiedTypeName(serviceName);
        typeName = this.toCapitalized(typeName);
        String methodName = "addExported" + typeName;
        Method method = new Method(methodName);
        StringBuffer buffer = new StringBuffer(500);
        if (details.isProxy()) {
            this.buildAddExportedProxyServiceOn(buffer, details);
        } else {
            this.buildAddExportedServiceOn(buffer, details);
        }
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
        return method;
    }

    private void buildAddExportedServiceOn(StringBuffer buffer, IExportedServiceDetails details) {
        String fullyQualifiedTypeName = details.getName();
        String typeName = this.toUnqualifiedTypeName(fullyQualifiedTypeName);
        String serviceName = this.toServiceName(fullyQualifiedTypeName);
        IType type = details.getImplementationClass();
        String implementationClassName = null;
        if (type != null) {
            String fullyQualifiedImplementationClassName = type.getFullyQualifiedName();
            implementationClassName = this.toUnqualifiedTypeName(fullyQualifiedImplementationClassName);
            this.addImportedType(fullyQualifiedImplementationClassName);
        }
        boolean storedInField = details.isStoredInField();
        boolean hasProperties = details.hasProperties();
        if (type == null) {
            this.indent(buffer, 2);
            buffer.append(JT_TODO_COMMENT_LINE);
            buffer.append("Initialize service");
        }
        if (hasProperties) {
            if (type == null) {
                buffer.append(" and ");
            } else {
                this.indent(buffer, 2);
                buffer.append(JT_TODO_COMMENT_LINE);
                buffer.append("Initialize ");
            }
            buffer.append(VN_PROPERTIES);
        }
        this.indent(buffer, 2);
        String fieldName = null;
        if (storedInField) {
            String fieldTypeName = type == null ? typeName : this.toUnqualifiedTypeName(implementationClassName);
            fieldName = this.toFieldName(typeName);
            Field field = new Field(fieldTypeName, fieldName);
            this.addField(field);
            buffer.append(JKW_THIS);
            buffer.append('.');
            buffer.append(fieldName);
        } else {
            buffer.append(typeName);
            this.space(buffer);
            buffer.append(VN_SERVICE);
        }
        this.space(buffer);
        buffer.append('=');
        this.space(buffer);
        if (implementationClassName == null) {
            buffer.append(JKW_NULL);
        } else {
            buffer.append(JKW_NEW);
            this.space(buffer);
            buffer.append(implementationClassName);
            buffer.append('(');
            buffer.append(')');
        }
        buffer.append(';');
        if (hasProperties) {
            String hashtableType = this.addImportedType(TN_HASHTABLE);
            String dictionaryType = this.addImportedType(TN_DICTIONARY);
            this.indent(buffer, 2);
            buffer.append(dictionaryType);
            this.space(buffer);
            buffer.append(VN_PROPERTIES);
            this.space(buffer);
            buffer.append('=');
            this.space(buffer);
            buffer.append(JKW_NEW);
            this.space(buffer);
            buffer.append(hashtableType);
            buffer.append('(');
            buffer.append(17);
            buffer.append(')');
            buffer.append(';');
        }
        this.indent(buffer, 2);
        buffer.append(MN_ADD_EXPORTED_SERVICE);
        buffer.append('(');
        buffer.append(serviceName);
        buffer.append(',');
        this.space(buffer);
        if (storedInField) {
            buffer.append(JKW_THIS);
            buffer.append('.');
            buffer.append(fieldName);
        } else {
            buffer.append(VN_SERVICE);
        }
        buffer.append(',');
        this.space(buffer);
        if (hasProperties) {
            buffer.append(VN_PROPERTIES);
        } else {
            buffer.append(JKW_NULL);
        }
        buffer.append(')');
        buffer.append(';');
    }

    private void buildArrayOfServiceNamesOn(StringBuffer buffer, List<String> names) {
        buffer.append(JKW_NEW);
        this.space(buffer);
        buffer.append(TN_STRING);
        buffer.append(JT_ARRAY_DECLARATION);
        this.space(buffer);
        buffer.append('{');
        boolean empty = names.isEmpty();
        if (!empty) {
            int size = names.size();
            String lastName = names.get(size - 1);
            for (String fullyQualifiedTypeName : names) {
                this.indent(buffer, 3);
                String serviceName = this.toServiceName(fullyQualifiedTypeName);
                buffer.append(serviceName);
                boolean last = fullyQualifiedTypeName.equals(lastName);
                if (last) continue;
                buffer.append(',');
            }
        }
        this.indent(buffer, 2);
        buffer.append('}');
        buffer.append(';');
    }

    private void buildDeactivateMethod() {
        int length;
        String methodName = MN_DEACTIVATE;
        Method method = new Method(methodName);
        method.beProtected();
        StringBuffer buffer = new StringBuffer(75);
        IActivatorWizardModel model = this.getWizardModel();
        boolean hasExportedServices = model.hasExportedServices();
        if (hasExportedServices) {
            List<IExportedServiceDetails> allExportedServices = model.getExportedServicesDetails();
            int size = allExportedServices.size();
            if (size == 1) {
                IExportedServiceDetails details = allExportedServices.get(0);
                boolean storedInField = details.isStoredInField();
                if (storedInField) {
                    this.buildRemoveExportedServiceOn(buffer, details);
                }
            } else {
                for (IExportedServiceDetails details : allExportedServices) {
                    boolean storedInField = details.isStoredInField();
                    if (!storedInField) continue;
                    Method removeExportedServiceMethod = this.buildRemoveExportedService(details);
                    String name = removeExportedServiceMethod.getName();
                    this.indent(buffer, 2);
                    buffer.append(name);
                    buffer.append('(');
                    buffer.append(')');
                    buffer.append(';');
                }
            }
        }
        if ((length = buffer.length()) == 0) {
            this.indent(buffer, 2);
            buffer.append(JT_TODO_COMMENT_LINE);
            buffer.append("Implement");
            this.space(buffer);
            buffer.append(methodName);
            buffer.append('(');
            buffer.append(')');
        }
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private void buildHandleOptionalImportedServiceMethod(List<String> names, String methodName) {
        Method method = new Method(methodName);
        method.beProtected();
        method.addParameter(new Parameter(TN_STRING, VN_SERVICE_NAME));
        method.addParameter(new Parameter(TN_OBJECT, VN_SERVICE));
        StringBuffer buffer = new StringBuffer(250);
        this.indent(buffer, 2);
        for (String fullyQualifiedTypeName : names) {
            String serviceName = this.toServiceName(fullyQualifiedTypeName);
            String unqualifiedName = this.toUnqualifiedTypeName(fullyQualifiedTypeName);
            buffer.append(JKW_IF);
            this.space(buffer);
            buffer.append('(');
            buffer.append(VN_SERVICE_NAME);
            buffer.append('.');
            buffer.append(MN_EQUALS);
            buffer.append('(');
            buffer.append(serviceName);
            buffer.append(')');
            buffer.append(')');
            this.space(buffer);
            buffer.append('{');
            this.indent(buffer, 3);
            buffer.append(JT_TODO_COMMENT_LINE);
            buffer.append("Handle");
            this.space(buffer);
            buffer.append(unqualifiedName);
            this.indent(buffer, 2);
            buffer.append('}');
            this.space(buffer);
            buffer.append(JKW_ELSE);
            this.space(buffer);
        }
        buffer.append('{');
        this.indent(buffer, 3);
        buffer.append(JKW_SUPER);
        buffer.append('.');
        buffer.append(methodName);
        buffer.append('(');
        buffer.append(VN_SERVICE_NAME);
        buffer.append(',');
        this.space(buffer);
        buffer.append(VN_SERVICE);
        buffer.append(')');
        buffer.append(';');
        this.indent(buffer, 2);
        buffer.append('}');
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private void buildImportedServiceFilterOn(StringBuffer buffer, String methodName, Map<String, String> filteredImportedServices) {
        Set<String> set = filteredImportedServices.keySet();
        ArrayList<String> list = new ArrayList<String>(set);
        TypeNameSorter.sort(list);
        for (String name : list) {
            this.indent(buffer, 2);
            String filter = filteredImportedServices.get(name);
            this.buildImportedServiceFilterOn(buffer, methodName, name, filter);
        }
    }

    private void buildImportedServiceFilterOn(StringBuffer buffer, String methodName, String fullyQualifiedTypeName, String filter) {
        buffer.append(methodName);
        buffer.append('(');
        String filteredServiceName = this.toServiceName(fullyQualifiedTypeName);
        buffer.append(filteredServiceName);
        buffer.append(',');
        this.space(buffer);
        buffer.append('\"');
        buffer.append(filter);
        buffer.append('\"');
        buffer.append(')');
        buffer.append(';');
        this.space(buffer);
        buffer.append(JT_NON_NSL_COMMENT_LINE);
    }

    private void buildMethods() {
        this.buildStartAndStopMethods();
        this.buildActivateAndDeactivateMethods();
        this.buildRequiredImportedServicesMethods();
        this.buildOptionalImportedServicesMethods();
        this.buildStartAsynchronouslyMethods();
        this.buildUninstallPolicyMethods();
        this.buildPropertiesInputStreamMethods();
    }

    private void buildOptionalImportedServicesMethods() {
        boolean build;
        IActivatorWizardModel model = this.getWizardModel();
        List<String> names = model.getOptionalImportedServices();
        boolean bl = build = !names.isEmpty();
        if (!build) {
            return;
        }
        Method method = new Method(MN_GET_OPTIONAL_IMPORTED_SERVICE_NAMES);
        method.beProtected();
        method.setReturnType("String[]");
        StringBuffer buffer = new StringBuffer(125);
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        this.buildArrayOfServiceNamesOn(buffer, names);
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
        this.buildHandleOptionalImportedServiceMethod(names, MN_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE);
        this.buildHandleOptionalImportedServiceMethod(names, MN_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE);
    }

    private void buildPropertiesInputStreamMethods() {
        String sourceMethodName;
        boolean build;
        IActivatorWizardModel model = this.getWizardModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean bl = build = policy != 0;
        if (!build) {
            return;
        }
        String returnType = this.addImportedType(TN_INPUT_STREAM);
        Method method = new Method(MN_GET_PROPERTIES_INPUT_STREAM);
        method.beProtected();
        method.setReturnType(returnType);
        String ioe = this.addImportedType(TN_IO_EXCEPTION);
        method.addDeclaredException(ioe);
        StringBuffer buffer = new StringBuffer(125);
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        if (policy == 2) {
            sourceMethodName = MN_GET_FILE_PROPERTIES_INPUT_STREAM;
        } else if (policy == 1) {
            sourceMethodName = MN_GET_RESOURCE_PROPERTIES_INPUT_STREAM;
        } else {
            this.logErrorUnrecognizedPropertyPolicy(policy);
            return;
        }
        buffer.append(sourceMethodName);
        buffer.append('(');
        boolean usingDefault = model.isUsingDefaultPropertiesFilename();
        if (!usingDefault) {
            String filename = model.getPropertiesFilename();
            buffer.append('\"');
            buffer.append(filename);
            buffer.append('\"');
        }
        buffer.append(')');
        buffer.append(';');
        if (!usingDefault) {
            this.space(buffer);
            buffer.append(JT_NON_NSL_COMMENT_LINE);
        }
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private Method buildRemoveExportedService(IExportedServiceDetails details) {
        String serviceName = details.getName();
        this.addImportedType(serviceName);
        String typeName = this.toUnqualifiedTypeName(serviceName);
        typeName = this.toCapitalized(typeName);
        String methodName = "removeExported" + typeName;
        Method method = new Method(methodName);
        StringBuffer buffer = new StringBuffer(500);
        this.buildRemoveExportedServiceOn(buffer, details);
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
        return method;
    }

    private void buildRemoveExportedServiceOn(StringBuffer buffer, IExportedServiceDetails details) {
        String fullyQualifiedTypeName = details.getName();
        String typeName = this.toUnqualifiedTypeName(fullyQualifiedTypeName);
        String fieldName = this.toFieldName(typeName);
        this.indent(buffer, 2);
        buffer.append(JKW_THIS);
        buffer.append('.');
        buffer.append(fieldName);
        this.space(buffer);
        buffer.append('=');
        this.space(buffer);
        buffer.append(JKW_NULL);
        buffer.append(';');
    }

    private void buildRequiredImportedServiceGetterMethods(String fullyQualifiedTypeName) {
        boolean build;
        IActivatorWizardModel model = this.getWizardModel();
        List<String> names = model.getRequiredImportedServices();
        boolean bl = build = !names.isEmpty();
        if (!build) {
            return;
        }
        String unqualifiedClassName = this.toUnqualifiedTypeName(fullyQualifiedTypeName);
        unqualifiedClassName = this.toCapitalized(unqualifiedClassName);
        String methodName = "get" + unqualifiedClassName;
        String type = this.addImportedType(fullyQualifiedTypeName);
        String serviceName = this.toServiceName(fullyQualifiedTypeName);
        Method method = new Method(methodName);
        method.bePrivate();
        method.setReturnType(type);
        StringBuffer buffer = new StringBuffer(125);
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        buffer.append('(');
        buffer.append(type);
        buffer.append(')');
        this.space(buffer);
        buffer.append(MN_GET_IMPORTED_SERVICE);
        buffer.append('(');
        buffer.append(serviceName);
        buffer.append(')');
        buffer.append(';');
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private void buildRequiredImportedServicesMethods() {
        boolean build;
        IActivatorWizardModel model = this.getWizardModel();
        List<String> names = model.getRequiredImportedServices();
        boolean bl = build = !names.isEmpty();
        if (!build) {
            return;
        }
        Method method = new Method(MN_GET_IMPORTED_SERVICE_NAMES);
        method.beProtected();
        method.setReturnType("String[]");
        StringBuffer buffer = new StringBuffer(125);
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        this.buildArrayOfServiceNamesOn(buffer, names);
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
        for (String name : names) {
            this.buildRequiredImportedServiceGetterMethods(name);
        }
    }

    private void buildStartAndStopMethods() {
        IActivatorWizardModel model = this.getWizardModel();
        Map<String, String> filteredRequiredImportedServices = model.getFilteredRequiredImportedServices();
        boolean noFilteredRequiredImportedServices = filteredRequiredImportedServices.isEmpty();
        Map<String, String> filteredOptionalImportedServices = model.getFilteredOptionalImportedServices();
        boolean noFilteredOptionalImportedServices = filteredOptionalImportedServices.isEmpty();
        boolean noFilteredImportedServices = noFilteredRequiredImportedServices && noFilteredOptionalImportedServices;
        boolean customStartAndStop = model.getCustomStartAndStop();
        if (noFilteredImportedServices && !customStartAndStop) {
            return;
        }
        StringBuffer buffer = new StringBuffer(125);
        Method method = new Method(MN_START);
        method.beProtected();
        this.indent(buffer, 2);
        buffer.append(JT_TODO_COMMENT_LINE);
        if (noFilteredImportedServices) {
            buffer.append("Implement");
            this.space(buffer);
            buffer.append(MN_START);
            buffer.append('(');
            buffer.append(')');
        } else {
            buffer.append("Define imported service filters");
            this.buildImportedServiceFilterOn(buffer, MN_ADD_IMPORTED_SERVICE_FILTER, filteredRequiredImportedServices);
            this.buildImportedServiceFilterOn(buffer, MN_ADD_OPTIONAL_IMPORTED_SERVICE_FILTER, filteredOptionalImportedServices);
        }
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
        this.reset(buffer);
        method = new Method(MN_STOP);
        method.beProtected();
        this.indent(buffer, 2);
        buffer.append(JT_TODO_COMMENT_LINE);
        buffer.append("Implement");
        this.space(buffer);
        buffer.append(MN_STOP);
        buffer.append('(');
        buffer.append(')');
        contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private void buildStartAsynchronouslyMethods() {
        IActivatorWizardModel model = this.getWizardModel();
        boolean build = model.getStartAsynchronously();
        if (!build) {
            return;
        }
        StringBuffer buffer = new StringBuffer(30);
        Method method = new Method(MN_IS_START_ASYNC);
        method.beProtected();
        method.setReturnType("boolean");
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        buffer.append(JKW_TRUE);
        buffer.append(';');
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
        int delta = model.getStartAsynchronouslyNormalPriorityDelta();
        if (delta == 0) {
            return;
        }
        method = new Method(MN_GET_ASYNC_START_PRIORITY);
        method.beProtected();
        method.setReturnType("int");
        this.reset(buffer);
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        buffer.append(TN_THREAD);
        buffer.append('.');
        buffer.append("NORM_PRIORITY");
        this.space(buffer);
        if (delta == -1) {
            buffer.append('-');
        } else if (delta == 1) {
            buffer.append('+');
        } else {
            this.logErrorUnrecognizedStartAsynchronouslyPriorityDelta(delta);
            return;
        }
        this.space(buffer);
        buffer.append(1);
        buffer.append(';');
        contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    private void buildUninstallPolicyMethods() {
        boolean build;
        IActivatorWizardModel model = this.getWizardModel();
        int policy = model.getUninstallPolicy();
        boolean bl = build = policy != 0;
        if (!build) {
            return;
        }
        String name = null;
        if (policy == 2) {
            name = MN_IS_TRANSIENT;
        } else if (policy == 1) {
            name = MN_IS_UNINSTALLABLE;
        } else {
            this.logErrorUnrecognizedUninstallPolicy(policy);
            return;
        }
        StringBuffer buffer = new StringBuffer(30);
        Method method = new Method(name);
        method.beProtected();
        method.setReturnType("boolean");
        this.indent(buffer, 2);
        buffer.append(JKW_RETURN);
        this.space(buffer);
        buffer.append(JKW_TRUE);
        buffer.append(';');
        String contents = buffer.toString();
        method.setContents(contents);
        this.addMethod(method);
    }

    String generate() {
        this.purge();
        this.addImportedType(TN_BASE_BUNDLE_ACTIVATOR);
        this.buildMethods();
        StringBuffer buffer = new StringBuffer(5120);
        this.generateClassOn(buffer);
        String value = buffer.toString();
        return value;
    }

    private void generateClassDeclarationOn(StringBuffer buffer) {
        IActivatorWizardModel model = this.getWizardModel();
        String className = model.getClassName();
        buffer.append(JKW_PUBLIC);
        this.space(buffer);
        buffer.append(JKW_CLASS);
        this.space(buffer);
        buffer.append(className);
        this.space(buffer);
        buffer.append(JKW_EXTENDS);
        this.space(buffer);
        String superclass = this.toUnqualifiedTypeName(TN_BASE_BUNDLE_ACTIVATOR);
        buffer.append(superclass);
    }

    private void generateClassOn(StringBuffer buffer) {
        this.generatePackageStatementOn(buffer);
        this.generateImportStatementsOn(buffer);
        this.generateClassDeclarationOn(buffer);
        this.space(buffer);
        buffer.append('{');
        this.generateFieldsOn(buffer);
        this.generateMethodsOn(buffer);
        buffer.append('}');
    }

    private void generateFieldNameOn(StringBuffer buffer, Field field) {
        String name = field.getName();
        buffer.append(name);
        buffer.append(';');
    }

    private void generateFieldOn(StringBuffer buffer, Field field) {
        this.generateFieldVisibilityOn(buffer);
        this.generateFieldTypeOn(buffer, field);
        this.generateFieldNameOn(buffer, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFieldsOn(StringBuffer buffer) {
        List<Field> list;
        List<Field> list2 = list = this.getFields();
        synchronized (list2) {
            boolean empty = list.isEmpty();
            if (empty) {
                return;
            }
            Collections.sort(list);
            for (Field field : list) {
                this.generateFieldOn(buffer, field);
            }
        }
        this.newLine(buffer);
    }

    private void generateFieldTypeOn(StringBuffer buffer, Field field) {
        String type = field.getType();
        buffer.append(type);
        this.space(buffer);
    }

    private void generateFieldVisibilityOn(StringBuffer buffer) {
        this.indent(buffer);
        buffer.append(JKW_PRIVATE);
        this.space(buffer);
    }

    private void generateImportStatementsOn(StringBuffer buffer) {
        Map<String, String> map = this.getImportedTypes();
        Collection<String> values = map.values();
        ArrayList<String> list = new ArrayList<String>(values);
        Collections.sort(list);
        for (String type : list) {
            buffer.append(JKW_IMPORT);
            this.space(buffer);
            buffer.append(type);
            buffer.append(';');
            this.newLine(buffer);
        }
        this.newLine(buffer);
    }

    private void generateMethodContentsOn(StringBuffer buffer, Method method) {
        this.space(buffer);
        buffer.append('{');
        String contents = method.getContents();
        buffer.append(contents);
        this.indent(buffer, 1);
        buffer.append('}');
        this.newLine(buffer);
    }

    private void generateMethodDeclaredExceptionsOn(StringBuffer buffer, Method method) {
        List<String> list = method.getDeclaredExceptions();
        boolean empty = list.isEmpty();
        if (empty) {
            return;
        }
        this.space(buffer);
        buffer.append(JKW_THROWS);
        this.space(buffer);
        int size = list.size();
        String lastException = list.get(size - 1);
        for (String exception : list) {
            buffer.append(exception);
            boolean last = exception.equals(lastException);
            if (last) continue;
            buffer.append(',');
            this.space(buffer);
        }
    }

    private void generateMethodNameOn(StringBuffer buffer, Method method) {
        String name = method.getName();
        buffer.append(name);
    }

    private void generateMethodOn(StringBuffer buffer, Method method) {
        this.generateMethodVisibilityOn(buffer, method);
        this.generateMethodReturnTypeOn(buffer, method);
        this.generateMethodNameOn(buffer, method);
        this.generateMethodParametersOn(buffer, method);
        this.generateMethodDeclaredExceptionsOn(buffer, method);
        this.generateMethodContentsOn(buffer, method);
    }

    private void generateMethodParametersOn(StringBuffer buffer, Method method) {
        buffer.append('(');
        List<Parameter> parameters = method.getParameters();
        boolean empty = parameters.isEmpty();
        if (!empty) {
            int size = parameters.size();
            Parameter lastParameter = parameters.get(size - 1);
            for (Parameter parameter : parameters) {
                String parameterType = parameter.getType();
                buffer.append(parameterType);
                buffer.append(' ');
                String parameterName = parameter.getName();
                buffer.append(parameterName);
                boolean last = parameter.equals(lastParameter);
                if (last) continue;
                buffer.append(',');
                buffer.append(' ');
            }
        }
        buffer.append(')');
    }

    private void generateMethodReturnTypeOn(StringBuffer buffer, Method method) {
        String returnType = method.getReturnType();
        buffer.append(returnType);
        this.space(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMethodsOn(StringBuffer buffer) {
        List<Method> list = this.getMethods();
        boolean empty = list.isEmpty();
        if (empty) {
            this.newLine(buffer);
        } else {
            List<Method> list2 = list;
            synchronized (list2) {
                Collections.sort(list);
                for (Method method : list) {
                    this.generateMethodOn(buffer, method);
                }
            }
        }
    }

    private void generateMethodVisibilityOn(StringBuffer buffer, Method method) {
        this.indent(buffer);
        String visibility = null;
        if (method.isPrivate()) {
            visibility = JKW_PRIVATE;
        } else if (method.isProtected()) {
            visibility = JKW_PROTECTED;
        } else if (method.isPublic()) {
            visibility = JKW_PUBLIC;
        } else if (method.isPackagePrivate()) {
            return;
        }
        buffer.append(visibility);
        this.space(buffer);
    }

    private void generatePackageStatementOn(StringBuffer buffer) {
        IActivatorWizardModel model = this.getWizardModel();
        String packageName = model.getPackageName();
        if (packageName == null || packageName.length() == 0) {
            return;
        }
        buffer.append(JKW_PACKAGE);
        this.space(buffer);
        buffer.append(packageName);
        buffer.append(';');
        this.newLine(buffer);
        this.newLine(buffer);
    }

    private List<Field> getFields() {
        return this.fields;
    }

    private Map<String, String> getImportedTypes() {
        return this.importedTypes;
    }

    private List<Method> getMethods() {
        return this.methods;
    }

    private ITypeModel getTypeModel() {
        return this.typeModel;
    }

    private IActivatorWizardModel getWizardModel() {
        return this.wizardModel;
    }

    private boolean hasServiceNameField(String fullyQualifiedTypeName) {
        ITypeModel typeModel = this.getTypeModel();
        boolean result = typeModel.hasServiceNameField(fullyQualifiedTypeName);
        return result;
    }

    private void indent(StringBuffer buffer) {
        this.indent(buffer, 1);
    }

    private void indent(StringBuffer buffer, int level) {
        this.newLine(buffer);
        int i = 0;
        while (i < level) {
            buffer.append('\t');
            ++i;
        }
    }

    private void logError(String message) {
        this.logError(message, null);
    }

    private void logError(String message, Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, message, throwable);
    }

    private void logErrorUnrecognizedPropertyPolicy(int policy) {
        String pattern = Messages.getString(UNRECOGNIZED_LOAD_PROPERTIES_POLICY_KEY);
        Object[] values = new Object[]{new Integer(policy)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void logErrorUnrecognizedStartAsynchronouslyPriorityDelta(int delta) {
        String pattern = Messages.getString(UNRECOGNIZED_START_ASYNCHRONOUSLY_PRIORITY_DELTA_KEY);
        Object[] values = new Object[]{new Integer(delta)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void logErrorUnrecognizedUninstallPolicy(int policy) {
        String pattern = Messages.getString(UNRECOGNIZED_UNINSTALL_POLICY_KEY);
        Object[] values = new Object[]{new Integer(policy)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void newLine(StringBuffer buffer) {
        buffer.append(NEW_LINE);
    }

    private void purge() {
        this.purgeImportedTypes();
        this.purgeMethods();
    }

    private void purgeImportedTypes() {
        Map<String, String> map = this.getImportedTypes();
        map.clear();
    }

    private void purgeMethods() {
        ArrayList methods = (ArrayList)this.getMethods();
        Collection clone = (Collection)methods.clone();
        methods.removeAll(clone);
    }

    private void reset(StringBuffer buffer) {
        buffer.setLength(0);
    }

    private void setFields(List<Field> fields) {
        this.fields = fields;
    }

    private void setImportedTypes(Map<String, String> importedTypes) {
        this.importedTypes = importedTypes;
    }

    private void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    private void setTypeModel(ITypeModel typeModel) {
        this.typeModel = typeModel;
    }

    private void setWizardModel(IActivatorWizardModel model) {
        this.wizardModel = model;
    }

    private void space(StringBuffer buffer) {
        buffer.append(' ');
    }

    private String toCapitalized(String typeName) {
        char ch = typeName.charAt(0);
        boolean uppercase = Character.isUpperCase(ch);
        if (uppercase) {
            return typeName;
        }
        char[] typeNameChars = typeName.toCharArray();
        typeNameChars[0] = Character.toUpperCase(ch);
        String result = new String(typeNameChars);
        return result;
    }

    private String toFieldName(String typeName) {
        String fieldName;
        char[] typeNameChars = typeName.toCharArray();
        char ch = typeNameChars[0];
        boolean uppercase = Character.isUpperCase(ch);
        if (uppercase) {
            typeNameChars[0] = ch = Character.toLowerCase(ch);
            fieldName = new String(typeNameChars);
        } else {
            fieldName = new String("_" + typeName);
        }
        return fieldName;
    }

    private String toPackageName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new String();
        }
        String packageName = name.substring(0, index);
        return packageName;
    }

    private String toServiceName(String fullyQualifiedTypeName) {
        String type = this.addImportedType(fullyQualifiedTypeName);
        StringBuffer buffer = new StringBuffer(125);
        buffer.append(type);
        buffer.append('.');
        boolean hasServiceNameField = this.hasServiceNameField(fullyQualifiedTypeName);
        if (hasServiceNameField) {
            buffer.append("SERVICE_NAME");
        } else {
            buffer.append(JKW_CLASS);
            buffer.append('.');
            buffer.append(MN_GET_NAME);
            buffer.append('(');
            buffer.append(')');
        }
        String serviceName = buffer.toString();
        return serviceName;
    }

    private String toUnqualifiedTypeName(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        String result = name.substring(index + 1);
        return result;
    }
}

