/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.sat.plugin.activator.IServiceDetails;
import org.eclipse.soda.sat.plugin.activator.bundle.Activator;

public abstract class ServiceDetails
implements IServiceDetails {
    private IType type;
    private IJavaProject javaProject;
    private boolean fromManifestHeader;

    protected ServiceDetails(IType type, IJavaProject javaProject) {
        this.setType(type);
        this.setJavaProject(javaProject);
        this.setFromManifestHeader(false);
    }

    public int compareTo(IServiceDetails object) {
        String thisName = this.getName();
        String thatName = object.getName();
        int result = thisName.compareTo(thatName);
        return result;
    }

    protected final IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public String getName() {
        IType type = this.getType();
        String name = type.getFullyQualifiedName();
        return name;
    }

    public IType getType() {
        return this.type;
    }

    public boolean isClass() {
        boolean result = false;
        IType type = this.getType();
        try {
            result = type.isClass();
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        return result;
    }

    public boolean isFromManifestHeader() {
        return this.fromManifestHeader;
    }

    public boolean isInterface() {
        boolean result = false;
        IType type = this.getType();
        try {
            result = type.isInterface();
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        return result;
    }

    protected final void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    public void setFromManifestHeader(boolean fromManifestHeader) {
        this.fromManifestHeader = fromManifestHeader;
    }

    private void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", name=" + this.getName();
    }
}

