/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.bundle.Activator;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.BundleDependencyCompositeBuilder;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BundleDependencyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION_KEY = "BundleDependencyPreferencePage.Description";
    private static final String DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET_KEY = "BundleDependencyPreferencePage.DoNotRemindMeToInstallDependencyServlet";
    private static final String OPTIONS_KEY = "BundleDependencyPreferencePage.Options";
    private static final String SHOW_ALL_BUNDLES_KEY = "Common.ShowAllBundles";
    private static final String TARGET_KEY = "BundleDependencyPreferencePage.Target";
    private static final char COLON_CHARACTER = ':';
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.dependency.ui.preferences";
    private BundleDependencyCompositeBuilder builder;
    private Button doNotRemindMeToInstallDependencyServletButton;
    private Button showAllBundlesButton;

    public BundleDependencyPreferencePage() {
        String description = String.valueOf(Messages.getString(DESCRIPTION_KEY)) + ':';
        this.setDescription(description);
    }

    private Button buildCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    private Composite buildComposite(Composite parent) {
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp((Control)parent, HELP_CONTEXT_ID);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.buildTargetComposite(composite);
        this.buildOptionsComposite(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void buildDisplayInstallDependencyServletReminderButton(Composite parent) {
        String value = Messages.getString(DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setDoNotRemindMeToInstallDependencyServletButton(button);
    }

    private void buildOptionsComposite(Composite parent) {
        Group group = new Group(parent, 0);
        String value = Messages.getString(OPTIONS_KEY);
        group.setText(value);
        GridLayout layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        this.buildShowAllBundlesButton((Composite)group);
        this.buildDisplayInstallDependencyServletReminderButton((Composite)group);
    }

    private void buildShowAllBundlesButton(Composite parent) {
        String value = Messages.getString(SHOW_ALL_BUNDLES_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setShowAllBundlesButton(button);
    }

    private void buildTargetComposite(Composite parent) {
        Group group = new Group(parent, 0);
        String value = Messages.getString(TARGET_KEY);
        group.setText(value);
        GridLayout layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        builder.build((Composite)group);
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.buildComposite(parent);
        this.initialize();
        this.hookupModifyListener();
        return composite;
    }

    private ModifyListener createModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleDependencyPreferencePage.this.handleModifiedText();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleDependencyCompositeBuilder getBuilder() {
        BundleDependencyPreferencePage bundleDependencyPreferencePage = this;
        synchronized (bundleDependencyPreferencePage) {
            if (this.builder == null) {
                this.setBuilder(new BundleDependencyCompositeBuilder());
            }
        }
        return this.builder;
    }

    private Button getDoNotRemindMeToInstallDependencyServletButton() {
        return this.doNotRemindMeToInstallDependencyServletButton;
    }

    private IBundleDependencyPreferences getModel() {
        Activator activator = Activator.getDefault();
        IBundleDependencyPreferences model = activator.getPreferences();
        return model;
    }

    private Button getShowAllBundlesButton() {
        return this.showAllBundlesButton;
    }

    private void handleModifiedText() {
        this.validate();
        this.updateErrorMessage();
    }

    private void hookupModifyListener() {
        ModifyListener listener = this.createModifyListener();
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        builder.addModifyListener(listener);
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        IBundleDependencyPreferences model = this.getModel();
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String host = model.getHost();
        builder.setHost(host);
        String port = model.getPort();
        builder.setPort(port);
        String servletAlias = model.getServletAlias();
        builder.setServletAlias(servletAlias);
        String pollFrequency = model.getPollFrequency();
        builder.setPollFrequency(pollFrequency);
        boolean showAllBundles = model.getShowAllBundles();
        Button showAllBundlesButton = this.getShowAllBundlesButton();
        showAllBundlesButton.setSelection(showAllBundles);
        boolean reminder = model.getDoNotRemindMeToInstallDependencyServlet();
        Button reminderButton = this.getDoNotRemindMeToInstallDependencyServletButton();
        reminderButton.setSelection(reminder);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return false;
        }
        valid = this.validate();
        return valid;
    }

    protected void performDefaults() {
        IBundleDependencyPreferences model = this.getModel();
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String host = model.getDefaultHost();
        builder.setHost(host);
        String port = model.getDefaultPort();
        builder.setPort(port);
        String servletAlias = model.getDefaultServletAlias();
        builder.setServletAlias(servletAlias);
        String pollFrequency = model.getDefaultPollFrequency();
        builder.setPollFrequency(pollFrequency);
        Button showAllBundlesButton = this.getShowAllBundlesButton();
        boolean state = model.getDefaultShowAllBundles();
        showAllBundlesButton.setSelection(state);
        Button reminderButton = this.getDoNotRemindMeToInstallDependencyServletButton();
        boolean reminder = model.getDefaultDoNotRemindMeToInstallDependencyServlet();
        reminderButton.setSelection(reminder);
        super.performDefaults();
    }

    public boolean performOk() {
        boolean valid = this.isValid();
        if (valid) {
            this.savePreferences();
        }
        this.updateErrorMessage();
        return valid;
    }

    private void savePreferences() {
        IBundleDependencyPreferences model = this.getModel();
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String host = builder.getHost();
        model.setHost(host);
        String port = builder.getPort();
        model.setPort(port);
        String servletAlias = builder.getServletAlias();
        model.setServletAlias(servletAlias);
        String pollFrequency = builder.getPollFrequency();
        model.setPollFrequency(pollFrequency);
        Button showAllBundlesButton = this.getShowAllBundlesButton();
        boolean state = showAllBundlesButton.getSelection();
        model.setShowAllBundles(state);
        Button reminderButton = this.getDoNotRemindMeToInstallDependencyServletButton();
        boolean reminder = reminderButton.getSelection();
        model.setDoNotRemindMeToInstallDependencyServlet(reminder);
        model.save();
    }

    private void setBuilder(BundleDependencyCompositeBuilder builder) {
        this.builder = builder;
    }

    private void setDoNotRemindMeToInstallDependencyServletButton(Button displayInstallDependencyServletReminderButton) {
        this.doNotRemindMeToInstallDependencyServletButton = displayInstallDependencyServletReminderButton;
    }

    private void setShowAllBundlesButton(Button showAllBundlesButton) {
        this.showAllBundlesButton = showAllBundlesButton;
    }

    protected void updateApplyButton() {
        super.updateApplyButton();
        this.updateErrorMessage();
    }

    private void updateErrorMessage() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String message = builder.getErrorMessage();
        this.setErrorMessage(message);
    }

    private boolean validate() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        boolean valid = builder.isValid();
        return valid;
    }
}

