/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitEditorEnvironment;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormEditor;
import org.eclipse.soda.devicekit.editor.dkml.DkmlConfiguration;
import org.eclipse.soda.devicekit.editor.dkml.DkmlDocumentProvider;
import org.eclipse.soda.devicekit.editor.dkml.DkmlModel;
import org.eclipse.soda.devicekit.editor.dkml.EditorMessages;
import org.eclipse.soda.devicekit.editor.dkml.FormattedDkml;
import org.eclipse.soda.devicekit.editor.dkml.IDeviceKitEditorPage;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedCenter;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedEvent;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedListener;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElementLink;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class DeviceKitSourcePage
extends TextEditor
implements IDeviceKitEditorPage,
DkmlResourceChangedListener,
IEditorMatchingStrategy,
IFormPage {
    public static final String FORMAT = "dkml.format";
    private Control control;
    private int index = -1;
    private boolean active = false;
    private boolean changed = false;
    private IDocumentListener documentListener = new DocumentListener();
    private IFile file;
    private DkmlDocumentProvider documentProvider;
    private DkmlModel dkmlModel;
    private boolean dirty;
    private FormatAction fa;
    private DeviceKitFormEditor editor;
    private static final String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.soda.devicekit.editor.dkml.DeviceKitEditorMessages";
    private static final ResourceBundle DeviceKitEditorMessages = ResourceBundle.getBundle("org.eclipse.soda.devicekit.editor.dkml.DeviceKitEditorMessages");

    public DeviceKitSourcePage() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new DkmlConfiguration(this.getPreferenceStore(), this));
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public void changed() {
        this.changed = true;
    }

    public void close(boolean save) {
        this.removeListeners();
        this.removeResourceErrors();
        super.close(save);
    }

    public boolean contextMenuAboutToShow(IMenuManager manager) {
        return false;
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction contentAssist = new ContentAssistAction(DeviceKitEditorMessages, "ContentAssistProposal.", (ITextEditor)this);
        contentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)contentAssist);
        this.markAsStateDependentAction("ContentAssist", true);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        document.addDocumentListener(this.documentListener);
        Control[] children = parent.getChildren();
        Control lastChild = children[children.length - 1];
        this.setControl(lastChild);
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getModel().saveFile(this.getFile(), true)) {
                this.getModel().updateModel(this.file);
                this.setDirty(false);
                this.fireSaveNeeded();
                this.changed = false;
                DeviceKitFormEditor deviceKitFormEditor = this.getDeviceKitFormEditor();
                if (deviceKitFormEditor != null) {
                    deviceKitFormEditor.updateContents();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getFormatAction());
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator(IDEActionFactory.ADD_TASK.getId()));
        menu.add((IContributionItem)new Separator("GotoLine"));
        this.addAction(menu, "group.rest", FORMAT);
        this.addAction(menu, "group.rest", "GotoLine");
        this.addAction(menu, "group.find", ITextEditorActionConstants.FIND);
        this.addAction(menu, "group.find", "FindNext");
        this.addAction(menu, "group.find", "FindPrevious");
        this.addAction(menu, "group.rest", IDEActionFactory.ADD_TASK.getId());
        super.editorContextMenuAboutToShow(menu);
    }

    public void fireSaveNeeded() {
        this.firePropertyChange(257);
    }

    public void formatDkml() {
        try {
            String contents = this.getCurrentDocContents();
            this.setContents(contents, true);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)DeviceKitEditorPlugin.getActiveWorkbenchShell(), (String)"Device Kit Error", (String)Nls.format((String)EditorMessages.getString("DeviceKitMultiPageEditor.error.format"), (Object)this.getFile().getName()));
        }
    }

    public Control getControl() {
        return this.control;
    }

    public String getCurrentDocContents() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    public DeviceKitFormEditor getDeviceKitFormEditor() {
        return this.editor;
    }

    public IDocumentProvider getDocumentProvider() {
        DeviceKitFormEditor deviceKitFormEditor = this.getDeviceKitFormEditor();
        if (deviceKitFormEditor != null) {
            return deviceKitFormEditor.getDocumentProvider();
        }
        if (this.documentProvider == null) {
            this.documentProvider = new DkmlDocumentProvider();
        }
        return this.documentProvider;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IFile getFile() {
        DeviceKitFormEditor deviceKitFormEditor = this.getDeviceKitFormEditor();
        if (deviceKitFormEditor != null) {
            return deviceKitFormEditor.getFile();
        }
        IEditorInput input = this.getEditorInput();
        if (this.file == null && input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return this.file;
    }

    protected Action getFormatAction() {
        if (this.fa == null) {
            this.fa = new FormatAction();
            this.fa.setText("Format");
        }
        return this.fa;
    }

    public String getId() {
        return "sourcePage";
    }

    public int getIndex() {
        return this.index;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public DkmlModel getModel() {
        DeviceKitFormEditor deviceKitFormEditor = this.getDeviceKitFormEditor();
        if (deviceKitFormEditor != null) {
            return deviceKitFormEditor.getModel();
        }
        if (this.dkmlModel == null) {
            this.dkmlModel = new DkmlModel(this.getFile(), this.getDocumentProvider(), this.getEditorInput());
        }
        return this.dkmlModel;
    }

    public String getPageContents() {
        return null;
    }

    public Control getPartControl() {
        return this.getControl();
    }

    public IFile getReferencedFile(String name) {
        return this.getModel().getReferencedFile(name);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setInput(input);
        this.initEditor();
        try {
            this.initModel();
        }
        catch (CoreException e) {
            throw new PartInitException(e.getMessage());
        }
    }

    public void initEditor() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        this.initXml();
    }

    public void initialize(FormEditor editor) {
    }

    private void initModel() throws CoreException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            DeviceKitFormEditor deviceKitFormEditor;
            IDocumentProvider documentProvider = this.getDocumentProvider();
            documentProvider.connect((Object)editorInput);
            IAnnotationModel amodel = documentProvider.getAnnotationModel((Object)editorInput);
            if (amodel != null) {
                amodel.connect(documentProvider.getDocument((Object)editorInput));
            }
            this.dkmlModel = (deviceKitFormEditor = this.getDeviceKitFormEditor()) != null ? deviceKitFormEditor.getModel() : new DkmlModel(this.getFile(), documentProvider, editorInput);
        }
    }

    private void initXml() {
        IEditorSite site = this.getEditorSite();
        DeviceKitEditorEnvironment.connect(this);
        this.setDocumentProvider(this.getDocumentProvider());
        DkmlResourceChangedCenter.getInstance().addResouceChangeListener(this);
        site.setSelectionProvider(site.getSelectionProvider());
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean isSource() {
        return true;
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        return true;
    }

    public void partClosed(IWorkbenchPart part) {
        this.removeListeners();
        this.removeResourceErrors();
    }

    public void preShow() {
        this.changed = false;
    }

    public void removeListeners() {
        DkmlResourceChangedCenter.getInstance().removeResourceChangeListener(this);
    }

    private void removeResourceErrors() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
            catch (CoreException coreException) {}
        }
    }

    public void resourceChanged(DkmlResourceChangedEvent event) {
        this.update();
    }

    public void select(TagElement element, boolean selectReal) {
        String findString;
        String contents = this.getCurrentDocContents();
        int index = contents.indexOf(findString = this.selectString(element, selectReal));
        if (index >= 0) {
            int length = findString.length();
            int lastIndex = contents.lastIndexOf(findString);
            if (lastIndex != index) {
                TagElement parentElement = element.getParent();
                String findStringParent = this.selectString(parentElement, selectReal);
                int parentIndex = contents.indexOf(findStringParent);
                if (index >= 0 && (index = contents.indexOf(findString, parentIndex)) < 0) {
                    index = parentIndex;
                }
            }
            if (findString.startsWith(" ")) {
                this.selectAndReveal(index + 1, length - 1);
            } else {
                this.selectAndReveal(index, length);
            }
        }
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public String selectString(TagElement element, boolean selectReal) {
        String rawId = element.getIdRaw();
        StringBuffer buffer = new StringBuffer(64);
        if (rawId != null && rawId.length() > 0) {
            if (element instanceof TagElementLink && !selectReal) {
                buffer.append(" idref=\"");
            } else {
                buffer.append(" id=\"");
            }
            buffer.append(rawId);
            buffer.append('\"');
        } else {
            String idref = element.getIdRef();
            if (idref != null && idref.length() > 0) {
                buffer.append(" idref=\"");
                buffer.append(idref);
                buffer.append('\"');
            } else {
                String name = element.getAttribute("name");
                if (name != null && name.length() > 0) {
                    buffer.append(" name=\"");
                    buffer.append(name);
                    buffer.append('\"');
                } else {
                    String tagName = element.getTagName();
                    buffer.append('<');
                    buffer.append(tagName);
                }
            }
        }
        String findString = buffer.toString();
        return findString;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setContents(String contents, boolean format) {
        try {
            String newContents = contents;
            if (format) {
                FormattedDkml xml = new FormattedDkml(contents);
                newContents = xml.getFormattedString();
            }
            this.getFile().setContents((InputStream)new ByteArrayInputStream(newContents.getBytes()), true, true, this.getProgressMonitor());
            this.getDocumentProvider().getDocument((Object)this.getEditorInput()).set(newContents);
            DeviceKitFormEditor deviceKitFormEditor = this.getDeviceKitFormEditor();
            if (deviceKitFormEditor != null) {
                deviceKitFormEditor.updateContents();
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)DeviceKitEditorPlugin.getActiveWorkbenchShell(), (String)"Device Kit Error", (String)Nls.format((String)EditorMessages.getString("DeviceKitMultiPageEditor.error.format"), (Object)this.getFile().getName()));
        }
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEditor(DeviceKitFormEditor editor) {
        this.editor = editor;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void update() {
        String newContents = null;
        DkmlModel model = this.getModel();
        String o = model.getTagContents();
        if (o == null) {
            return;
        }
        newContents = o;
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        doc.set(newContents);
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            DeviceKitSourcePage.this.getModel().setChanged(true);
            DeviceKitSourcePage.this.getModel().updateFile(DeviceKitSourcePage.this.getFile(), DeviceKitSourcePage.this.getDocumentProvider().getDocument((Object)DeviceKitSourcePage.this.getEditorInput()).get());
            DeviceKitSourcePage.this.setDirty(true);
            DeviceKitSourcePage.this.fireSaveNeeded();
        }
    }

    class FormatAction
    extends Action {
        public FormatAction() {
            this.setId(DeviceKitSourcePage.FORMAT);
        }

        public void run() {
            DeviceKitSourcePage.this.formatDkml();
        }
    }
}

