/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.java;

import org.eclipse.soda.devicekit.generator.internal.print.java.JavaPrinter;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IParameter;
import org.eclipse.soda.devicekit.generator.utilty.NLSUtil;

public class MethodPrinter
extends JavaPrinter {
    private IMethod fMethod;

    public MethodPrinter(IMethod method) {
        this(method, 0);
    }

    public MethodPrinter(IMethod method, int indentation) {
        super(indentation);
        this.fMethod = method;
        this.printMethod();
    }

    protected IMethod getMethod() {
        return this.fMethod;
    }

    protected void printMethod() {
        this.printJavaDocComment(this.fMethod.getComment());
        this.printMethodDeclaration();
        if (this.fMethod.isClass()) {
            this.printStartBlock();
            this.incrementIndent();
            this.printMethodBody();
            this.decrementIndent();
            this.printIndentation();
            this.printEndBlock();
        } else {
            this.printEndStatement();
            this.printNewLine();
        }
    }

    private void printMethodBody() {
        String[] contents = this.fMethod.getContents();
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                this.printWithIndent(contents[i]);
                this.print(NLSUtil.printNLSS(contents[i]));
                this.printNewLine();
                ++i;
            }
        }
    }

    private void printMethodDeclaration() {
        this.printWithIndent(this.fMethod.getIdentifiers());
        if (this.fMethod.getReturnType() != null && this.fMethod.getReturnType().length() > 0) {
            this.print(this.fMethod.getReturnType());
            this.printSpace();
        } else if (!this.fMethod.isConstructor()) {
            this.print("void");
            this.printSpace();
        }
        this.print(this.fMethod.getName());
        this.printLeftParen();
        this.printMethodParameters();
        this.printRightParen();
        this.printThrownExceptions();
    }

    private void printMethodParameters() {
        IParameter[] parameters = this.fMethod.getParameters();
        if (parameters == null || parameters.length == 0) {
            return;
        }
        int count = parameters.length;
        int lastComma = count - 2;
        int i = 0;
        while (i < parameters.length) {
            IParameter parameter = parameters[i];
            this.print("final");
            this.printSpace();
            this.print(parameter.getType());
            this.printSpace();
            this.print(parameter.getName());
            String description = parameter.getDescription();
            if (i <= lastComma) {
                this.printComma();
                this.printSpace();
            }
            if (description != null && description.length() > 0) {
                this.print("\t// ");
                this.print(description);
                this.print("\n\t\t");
            }
            ++i;
        }
    }

    private void printThrownExceptions() {
        String[] exceptions = this.fMethod.getThrownExceptions();
        if (exceptions == null || exceptions.length == 0) {
            return;
        }
        int count = exceptions.length;
        int lastComma = count - 2;
        this.printSpace();
        this.print("throws");
        this.printSpace();
        int i = 0;
        while (i < exceptions.length) {
            this.print(exceptions[i]);
            if (i <= lastComma) {
                this.printComma();
                this.printSpace();
            }
            ++i;
        }
    }
}

