/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public class DkDeviceBundleGenerator
extends DkDeviceGenerator {
    public DkDeviceBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map properties, int bundleType) {
        super(model, generatedInfo, properties, bundleType);
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
            this.getBuildModel().addAdditionalBundles(this.getMainPackage());
        }
        if (!this.isAbstract() && this.doGenerateBundleActivator()) {
            this.generateBundleActivatorClass();
        }
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    public String getDSReference() {
        String service;
        if (this.getTransportServiceElement() != null && (service = this.getTransportServiceElement().getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                service = String.valueOf(pack) + '.' + service;
            }
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append("\t<reference bind=\"setTransport\" cardinality=\"1..1\"\r\n");
            buffer.append("\t\tinterface=\"");
            buffer.append(service);
            buffer.append("\"\r\n");
            String name = DeviceKitUtilities.stripPackage(service);
            buffer.append("\t\tname=\"");
            buffer.append(name);
            buffer.append("\" policy=\"static\" unbind=\"unsetTransport\"/>\r\n");
            return buffer.toString();
        }
        return "";
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected List getManifestExportPackages() {
        ArrayList<String> result = new ArrayList<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected List getManifestExportServices() {
        List vector = super.getManifestExportServices();
        vector.add(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.get(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        String corePack;
        String serviceDevicePack;
        String baseBundleActivatorPack;
        List result = super.getManifestImportPackages();
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String connectionBundlePack = DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE;
        if (!result.contains(connectionBundlePack)) {
            result.add(connectionBundlePack);
        }
        if (this.bundleType != 4 && !result.contains(baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR))) {
            result.add(baseBundleActivatorPack);
        }
        if (!result.contains(serviceDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE))) {
            result.add(serviceDevicePack);
        }
        if (!result.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            result.add(corePack);
        }
        List importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected List getManifestImportServices() {
        String service;
        List vector = super.getManifestImportServices();
        if (this.getTransportServiceElement() != null && (service = this.getTransportServiceElement().getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                service = String.valueOf(pack) + '.' + service;
            }
            vector.add(service);
        }
        return vector;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        switch (this.bundleType) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
                break;
            }
            case 3: {
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
            }
        }
        return result;
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save(progressMonitor);
            if (ba != null) {
                result.add(ba);
            }
        }
        this.saveCommon(progressMonitor);
        return result;
    }
}

