/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.java;

import org.eclipse.soda.devicekit.generator.print.IndentationPrinter;

public abstract class JavaPrinter
extends IndentationPrinter {
    public static final boolean NLS = true;

    protected JavaPrinter() {
    }

    protected JavaPrinter(int indent) {
        super(indent);
    }

    protected void printComma() {
        this.print(',');
    }

    private void printCommentLine(String comment) {
        this.printlnWithIndent(" * " + comment);
    }

    protected void printEndBlock() {
        this.println('}');
    }

    private void printEndJavaComment() {
        this.printlnWithIndent(" */");
    }

    protected void printEndStatement() {
        this.print(';');
    }

    protected void printEquals() {
        this.printSpace();
        this.print('=');
        this.printSpace();
    }

    protected void printImport(String imp) {
        if (imp != null && imp.length() > 0) {
            this.print("import");
            this.printSpace();
            this.print(imp);
            this.printEndStatement();
            this.printNewLine();
        }
    }

    protected void printJavaComment(String[] comment) {
        if (comment != null && comment.length > 0) {
            int i = 0;
            while (i < comment.length) {
                this.printIndentation();
                if (i == 0) {
                    this.print('/');
                } else {
                    this.printSpace();
                }
                this.print('*');
                this.printSpace();
                this.println(comment[i]);
                ++i;
            }
            this.printEndJavaComment();
        }
    }

    protected void printJavaCopyrightComment(String[] comment) {
        if (comment != null && comment.length > 0) {
            this.printIndentation();
            int length = comment.length;
            int max = 0;
            int i = 0;
            while (i < length) {
                max = Math.max(max, comment[i].length());
                ++i;
            }
            this.print(" /***");
            int j = 0;
            while (j < max) {
                this.print('*');
                ++j;
            }
            this.println('*');
            i = 0;
            while (i < comment.length) {
                this.printIndentation();
                this.printSpace();
                this.print('*');
                this.printSpace();
                int size = comment[i].length();
                if (size > 0) {
                    this.print(comment[i]);
                }
                int j2 = 0;
                while (j2 < max - size) {
                    this.print(' ');
                    ++j2;
                }
                this.printSpace();
                this.println('*');
                ++i;
            }
            this.printIndentation();
            this.print(" **");
            j = 0;
            while (j < max) {
                this.print('*');
                ++j;
            }
            this.println("*/");
        }
    }

    protected void printJavaDocComment(String[] comment) {
        if (comment != null) {
            this.printStartJavaDocComment();
            int i = 0;
            while (i < comment.length) {
                this.printCommentLine(comment[i]);
                ++i;
            }
            this.printEndJavaComment();
        }
    }

    protected void printLeftParen() {
        this.print('(');
    }

    protected void printPackageStatment(String pack) {
        if (pack != null && pack.length() > 0) {
            this.print("package");
            this.printSpace();
            this.print(pack);
            this.printEndStatement();
            this.printNewLine();
        }
    }

    protected void printRightParen() {
        this.print(')');
    }

    protected void printStartBlock() {
        this.println('{');
    }

    private void printStartJavaDocComment() {
        this.printlnWithIndent("/**");
    }
}

