/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkConcreteTestGenerator
extends DkDeviceTestGenerator {
    public DkConcreteTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    public DkConcreteTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected String getModelName() {
        List concretes = this.fTest.getAllChildrenWithTagCode(18);
        TagElement concrete = (TagElement)concretes.get(0);
        String name = concrete.getImplementation();
        if (name != null && name.indexOf(46) == -1) {
            String pack = DeviceKitUtilities.getPackageFromClassName(name, this.getPackageBase());
            name = String.valueOf(pack) + '.' + name;
        }
        return name;
    }

    protected String getModelServiceName() {
        List concretes = this.fTest.getAllChildrenWithTagCode(18);
        String service = null;
        TagElement concrete = (TagElement)concretes.get(0);
        service = concrete.getAttribute("service") != null ? concrete.getAttribute("service") : concrete.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    protected boolean isAbstract() {
        List cons = this.getMainElement().getAllChildrenWithTagCode(18);
        ConcreteElement con = (ConcreteElement)cons.get(0);
        String abs = con.getAttribute("abstract");
        return abs != null && abs.equals("true");
    }
}

