/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkProfileTestAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkProfileTestAgentGenerator
extends DkTestAgentGenerator {
    protected JavaFileModel fAbstractTestcaseModel;
    protected List targetProfileModels;

    protected DkProfileTestAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkProfileTestAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    private void addProfileServiceImports(JavaFileModel testcase, List targetProfiles) {
        int i = 0;
        while (i < targetProfiles.size()) {
            MainTagElement mainElement = ((DeviceKitTagModel)targetProfiles.get(i)).getMainElement();
            String profileService = String.valueOf(mainElement.getId()) + "Service";
            String packageBase = mainElement.getPackageBase();
            String servicePackage = DeviceKitUtilities.getPackageFromClassName(profileService, packageBase);
            testcase.addImport(String.valueOf(servicePackage) + '.' + profileService);
            ++i;
        }
    }

    protected Set codeAbstractTestcaseExternalKeys(IType abstractTestcase, DeviceKitTagModel dkTagModel, List targetProfiles) {
        TreeSet<String> externalKeys = new TreeSet<String>();
        MainTagElement mainTag = dkTagModel.getMainElement();
        String profileName = mainTag.getId();
        String profileService = DeviceKitUtilities.stripPackage(mainTag.getServiceNameFull());
        String statusField = CodeUtilities.fieldName(String.valueOf(profileService) + "Status" + "ExternalKey");
        this.codeField(abstractTestcase, statusField, "String", 4L, new String[0], null);
        externalKeys.add(this.getAbstractTestcasePropertyFieldContent(statusField, "status", profileService));
        this.codeAbstractTestcaseGetMethod(abstractTestcase, String.valueOf(profileName) + "Status", statusField, DeviceKitUtilities.stripPackage("java.util.Dictionary"));
        String capabilitiesField = CodeUtilities.fieldName(String.valueOf(profileService) + "Capabilities" + "ExternalKey");
        this.codeField(abstractTestcase, capabilitiesField, "String", 4L, new String[0], null);
        externalKeys.add(this.getAbstractTestcasePropertyFieldContent(capabilitiesField, "capabilities", profileService));
        this.codeAbstractTestcaseGetMethod(abstractTestcase, String.valueOf(profileName) + "Capabilities", capabilitiesField, DeviceKitUtilities.stripPackage("java.util.Dictionary"));
        String configurationField = CodeUtilities.fieldName(String.valueOf(profileService) + "Configuration" + "ExternalKey");
        this.codeField(abstractTestcase, configurationField, "String", 4L, new String[0], null);
        externalKeys.add(this.getAbstractTestcasePropertyFieldContent(configurationField, "configuration", profileService));
        this.codeAbstractTestcaseGetMethod(abstractTestcase, String.valueOf(profileName) + "Configuration", configurationField, DeviceKitUtilities.stripPackage("java.util.Dictionary"));
        List allExternalKeys = mainTag.getAllChildrenWithTagCodes(new int[]{1, 2, 3});
        List referencedProfiles = mainTag.getAllChildrenWithTagCode(85);
        if (referencedProfiles.size() > 0) {
            List referencedKeys = ((TagElement)referencedProfiles.get(0)).getAllChildrenWithTagCodes(new int[]{79, 80, 81}, new int[]{86, 94});
            allExternalKeys.addAll(referencedKeys);
        }
        int i = 0;
        while (i < allExternalKeys.size()) {
            TagElement element = (TagElement)allExternalKeys.get(i);
            String id = element.getId();
            String serviceType = element.getParent().getServiceNameFull();
            this.fAbstractTestcaseModel.addImport(serviceType);
            String serviceName = DeviceKitUtilities.stripPackage(serviceType);
            String refProfile = serviceName.substring(0, serviceName.length() - "Service".length());
            String fieldName = CodeUtilities.fieldName(String.valueOf(serviceName) + id + "ExternalKey");
            int tagCode = element.getTagCode();
            this.codeField(abstractTestcase, fieldName, "String", 4L, new String[0], null);
            externalKeys.add(this.getAbstractTestcasePropertyFieldContent(fieldName, id, serviceName));
            if (tagCode == 2) {
                this.codeAbstractTestcaseGetMethod(abstractTestcase, id, fieldName, element.getAttribute("type"));
                this.codeAbstractTestcaseReadMethod(abstractTestcase, id, fieldName, element.getAttribute("type"));
                this.codeAbstractTestcaseWriteMethod(abstractTestcase, id, fieldName, element.getAttribute("type"));
            } else if (tagCode == 80 && !targetProfiles.contains(refProfile)) {
                this.codeAbstractTestcaseReportMethod(abstractTestcase, id, fieldName);
            }
            ++i;
        }
        return externalKeys;
    }

    protected void codeAbstractTestcaseGetMethod(IType abstractTestcase, String id, String fieldName, String type) {
        String methodName = CodeUtilities.methodName("get" + id);
        StringBuffer contents = new StringBuffer();
        contents.append("return ");
        contents.append("(" + type + ") ");
        contents.append("getMeasurement(this." + fieldName + ");\n");
        String[] exception = new String[]{"InterruptedException"};
        this.codeMethod(abstractTestcase, methodName, new String[0], type, 4L, contents.toString(), new KeyValuePair[0], exception);
    }

    protected void codeAbstractTestcasePropertiesMethod(IType abstractTestcase, String content) {
        String[] comment = new String[]{"Get CONNECTION_KEYS and settings from the properties"};
        this.codeMethod(abstractTestcase, "getKeysAndSettingsFromProperties", comment, "void", 4L, content);
    }

    protected void codeAbstractTestcaseReadMethod(IType abstractTestcase, String id, String fieldName, String type) {
        String methodName = CodeUtilities.methodName("read" + id);
        StringBuffer contents = new StringBuffer();
        contents.append("return ");
        contents.append("(" + type + ") ");
        contents.append("readMeasurement(this." + fieldName + ");\n");
        String[] exception = new String[]{"InterruptedException"};
        this.codeMethod(abstractTestcase, methodName, new String[0], type, 4L, contents.toString(), new KeyValuePair[0], exception);
    }

    protected void codeAbstractTestcaseReportMethod(IType abstractTestcase, String id, String fieldName) {
        String methodName = CodeUtilities.methodName("report" + id);
        String contents = "reportMeasurement(this." + fieldName + ", dataValue);\n";
        String[] exception = new String[]{};
        KeyValuePair[] parameters = new KeyValuePair[]{new KeyValuePair(DeviceKitUtilities.stripPackage("java.util.Map"), "dataValue")};
        this.codeMethod(abstractTestcase, methodName, new String[0], "void", 4L, contents.toString(), parameters, exception);
    }

    protected void codeAbstractTestcaseWriteMethod(IType abstractTestcase, String id, String fieldName, String type) {
        String methodName = CodeUtilities.methodName("write" + id);
        String contents = "writeMeasurement(this." + fieldName + ", dataValue);\n";
        String[] exception = new String[]{"InterruptedException"};
        KeyValuePair[] parameters = new KeyValuePair[]{new KeyValuePair(type, "dataValue")};
        this.codeMethod(abstractTestcase, methodName, new String[0], "void", 4L, contents.toString(), parameters, exception);
    }

    protected void codeTest000_DisconnectMethod(IType testcase, List targetProfiles) {
        String mainClassName = this.getMainClassName();
        String[] exceptions = new String[]{"InterruptedException", DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_IOEXCEPTION)};
        StringBuffer test000Content = new StringBuffer();
        test000Content.append("requestConfirmation(");
        test000Content.append(String.valueOf(mainClassName) + ".DefaultResourceBundle.getString(Integer.toString(" + mainClassName + '.' + "DISCONNECT_READER" + ")));\n");
        int i = 0;
        while (i < targetProfiles.size()) {
            String profileId = ((DeviceKitTagModel)targetProfiles.get(i)).getMainElement().getId();
            test000Content.append("waitForProfileState(" + profileId + "Service" + '.' + profileId + ", ");
            test000Content.append("ProfileService.ALIVE);\n");
            ++i;
        }
        this.codeMethod(testcase, "test000_Disconnect", new String[0], "void", 1L, test000Content.toString(), new KeyValuePair[0], exceptions);
    }

    protected void codeTest010_ReconnectMethod(IType testcase, List targetProfiles) {
        String mainClassName = this.getMainClassName();
        String[] exceptions = new String[]{"InterruptedException", DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_IOEXCEPTION)};
        StringBuffer test010Content = new StringBuffer();
        test010Content.append("requestConfirmation(");
        test010Content.append(String.valueOf(mainClassName) + ".DefaultResourceBundle.getString(Integer.toString(" + mainClassName + '.' + "RECONNECT_READER" + ")));\n");
        int i = 0;
        while (i < targetProfiles.size()) {
            String profileId = ((DeviceKitTagModel)targetProfiles.get(i)).getMainElement().getId();
            test010Content.append("waitForProfileState(" + profileId + "Service" + '.' + profileId + ", ");
            test010Content.append("ProfileService.STARTED);\n");
            ++i;
        }
        this.codeMethod(testcase, "test010_Reconnect", new String[0], "void", 1L, test010Content.toString(), new KeyValuePair[0], exceptions);
    }

    protected void codeTestcaseSetupMethod(IType testcase, List targetProfiles) {
        StringBuffer setupContent = new StringBuffer();
        setupContent.append("super.setUp();\n");
        if (targetProfiles != null) {
            int i = 0;
            while (i < targetProfiles.size()) {
                String profileId = ((DeviceKitTagModel)targetProfiles.get(i)).getMainElement().getId();
                setupContent.append("waitForProfileStart(" + profileId + "Service" + '.' + profileId + ");\n");
                ++i;
            }
        }
        this.codeMethod(testcase, "setUp", new String[0], "void", 4L, setupContent.toString(), new KeyValuePair[0], new String[]{"Exception"});
    }

    protected IType createAbstractTestcaseType() throws Exception {
        String className = this.getTestcaseClassName("Abstract");
        String testPack = this.getMainPackage();
        this.fAbstractTestcaseModel = new JavaFileModel(className);
        this.fAbstractTestcaseModel.setComment(this.getCopyright());
        this.fAbstractTestcaseModel.setPackage(testPack);
        IType abstractTestcase = this.createClass(this.fAbstractTestcaseModel, testPack, className, this.getSourceFolderName());
        abstractTestcase.setComment(this.getMainClassComment());
        abstractTestcase.setSuperClass(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_ABSTRACT_PROFILE_TESTCASE));
        this.codeConstructorTestcase(abstractTestcase);
        this.fAbstractTestcaseModel.addImport(DeviceKitGenerationConstants.CLASS_ABSTRACT_PROFILE_TESTCASE);
        this.fAbstractTestcaseModel.addImport("java.util.Dictionary");
        this.fAbstractTestcaseModel.addImport("java.util.Map");
        this.addTestcase(this.fAbstractTestcaseModel);
        List profileModels = this.getTargetProfileModels();
        TreeSet externalKeys = new TreeSet();
        int i = 0;
        while (i < profileModels.size()) {
            externalKeys.addAll(this.codeAbstractTestcaseExternalKeys(abstractTestcase, (DeviceKitTagModel)profileModels.get(i), profileModels));
            ++i;
        }
        StringBuffer properties_method_buffer = new StringBuffer(2048);
        properties_method_buffer.append("super.getKeysAndSettingsFromProperties();\n");
        Iterator keys = externalKeys.iterator();
        while (keys.hasNext()) {
            properties_method_buffer.append((String)keys.next());
        }
        this.codeAbstractTestcasePropertiesMethod(abstractTestcase, properties_method_buffer.toString());
        return abstractTestcase;
    }

    protected IType createDisconnectTestcaseType() throws Exception {
        List targetProfiles = this.getTargetProfileModels();
        String className = this.getTestcaseClassName("Disconnect");
        String testPack = this.getMainPackage();
        JavaFileModel fDisconnectTestcaseModel = new JavaFileModel(className);
        fDisconnectTestcaseModel.setComment(this.getCopyright());
        fDisconnectTestcaseModel.setPackage(testPack);
        fDisconnectTestcaseModel.addImport(DeviceKitGenerationConstants.CLASS_IOEXCEPTION);
        IType disconnectTestcase = this.createClass(fDisconnectTestcaseModel, testPack, className, this.getSourceFolderName());
        this.addTestcase(fDisconnectTestcaseModel);
        disconnectTestcase.setComment(this.getMainClassComment());
        disconnectTestcase.setSuperClass(this.getTestcaseClassName("Abstract"));
        this.codeConstructorTestcase(disconnectTestcase);
        fDisconnectTestcaseModel.addImport(DeviceKitGenerationConstants.CLASS_TEST_AGENT);
        this.addProfileServiceImports(fDisconnectTestcaseModel, targetProfiles);
        fDisconnectTestcaseModel.addImport(DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE);
        this.codeMainTestcase(disconnectTestcase);
        this.codeTestcaseSetupMethod(disconnectTestcase, null);
        this.codeTest000_DisconnectMethod(disconnectTestcase, targetProfiles);
        this.codeTest010_ReconnectMethod(disconnectTestcase, targetProfiles);
        return disconnectTestcase;
    }

    protected void generateTestCases() throws Exception {
        List list = this.getMainElement().getAllChildrenWithTagCode(71);
        int i = 0;
        while (i < list.size()) {
            TestCaseElement testcase = (TestCaseElement)list.get(i);
            String testcaseId = testcase.getId();
            if (testcaseId.equals(this.getTestcaseClassName("Abstract"))) {
                this.createAbstractTestcaseType();
            } else if (testcaseId.equals(this.getTestcaseClassName("Disconnect"))) {
                this.createDisconnectTestcaseType();
            } else {
                this.createTestcaseType(testcase);
            }
            ++i;
        }
    }

    private String getAbstractTestcasePropertyFieldContent(String fieldName, String key, String profileService) {
        StringBuffer properties_buffer = new StringBuffer();
        properties_buffer.append("this.");
        properties_buffer.append(String.valueOf(fieldName) + " = prependPrefix(");
        String betterKey = CodeUtilities.validStaticIdentifier(key);
        properties_buffer.append(String.valueOf(profileService) + '.' + betterKey + "_EXTERNAL_KEY" + ");\n");
        return properties_buffer.toString();
    }

    protected String[][] getExtraMsgFieldValues() {
        return new String[][]{{"DISCONNECT_READER", "DISCONNECT_READER".toLowerCase()}, {"RECONNECT_READER", "RECONNECT_READER".toLowerCase()}};
    }

    protected DeviceKitTagModel getTargetProfileModel(String profileXmlPath) throws Exception {
        String profileXmlPathCorrect = profileXmlPath;
        int indexPound = profileXmlPathCorrect.indexOf(35);
        if (indexPound > 0) {
            profileXmlPathCorrect = profileXmlPathCorrect.substring(0, indexPound);
        }
        String profileXMLFullPath = String.valueOf(String.valueOf(Platform.getLocation())) + '/' + profileXmlPathCorrect;
        int index = profileXmlPathCorrect.indexOf(47);
        String profileProjectName = profileXmlPathCorrect.substring(0, index);
        String profileXMLSubPath = profileXmlPathCorrect.substring(index + 1);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(profileProjectName);
        IFile profileXML = project.getFile(profileXMLSubPath);
        List references = new DkmlReferenceResolver(profileXML).getReferences();
        DeviceKitTagModel profileModel = new DeviceKitTagModel(new File(profileXMLFullPath), references);
        profileModel.build();
        return profileModel;
    }

    private List getTargetProfileModels() throws Exception {
        if (this.targetProfileModels != null) {
            return this.targetProfileModels;
        }
        DeviceKitTagModel model = this.getModel();
        MainTagElement mainElement = model.getMainElement();
        List profiles = mainElement.getProfileChildren();
        class ProfileModelList
        extends ArrayList {
            private static final long serialVersionUID = 0L;
            private List profileNames;
            final /* synthetic */ DkProfileTestAgentGenerator this$0;

            ProfileModelList(DkProfileTestAgentGenerator dkProfileTestAgentGenerator) {
                this.this$0 = dkProfileTestAgentGenerator;
                this.profileNames = new ArrayList<E>();
            }

            public boolean add(Object profile) {
                if (profile instanceof DeviceKitTagModel) {
                    String profileName = ((DeviceKitTagModel)profile).getMainElement().getId();
                    this.profileNames.add(profileName);
                }
                return super.add(profile);
            }

            public boolean contains(Object elem) {
                if (elem instanceof String) {
                    return this.profileNames.contains(elem);
                }
                return super.contains(elem);
            }
        }
        this.targetProfileModels = new ProfileModelList(this);
        int i = 0;
        while (i < profiles.size()) {
            String profileStr = ((TagElement)profiles.get(i)).getIdRef();
            if (profileStr != null) {
                DeviceKitTagModel profileModel = this.getTargetProfileModel(profileStr);
                this.targetProfileModels.add(profileModel);
            }
            ++i;
        }
        return this.targetProfileModels;
    }
}

