/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.soda.devicekit.generator.model.BytesGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public abstract class BlockElement
extends GeneralParameterElement {
    protected BlockElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getBytesCodeString() {
        if (this.getValueValue() == null) {
            return "";
        }
        BytesGenerator bytesGenerator = new BytesGenerator();
        this.updateBytes(bytesGenerator);
        StringBuffer buffer = new StringBuffer(1024);
        String comment = bytesGenerator.getCodeComment();
        if (comment.length() > 0) {
            buffer.append('\n');
            buffer.append(comment);
            buffer.append('\n');
        }
        buffer.append(bytesGenerator.getBytesCode());
        return buffer.toString();
    }

    public boolean isConstantParameter() {
        return true;
    }

    public void updateBytes(BytesGenerator bytesGenerator, boolean filterValid) {
        Object value = this.getValueValue();
        int length = this.getBitLengthValue(this.getLengthDefault(value));
        StringBuffer buffer = new StringBuffer(128);
        String commentId = this.getId();
        if (commentId == null && (commentId = this.getIdRef()) == null) {
            commentId = "";
        }
        buffer.append(commentId);
        if (value != null && !(value instanceof byte[])) {
            buffer.append(" (");
            buffer.append(commentId);
            buffer.append(')');
        }
        String comment = buffer.toString();
        if (value instanceof Double) {
            double doubleValue = ((Number)value).doubleValue();
            long longValue = Double.doubleToLongBits(doubleValue);
            bytesGenerator.add(length, longValue, true, comment);
        } else if (value instanceof Float) {
            float floatValue = ((Number)value).floatValue();
            long longValue = Float.floatToIntBits(floatValue);
            bytesGenerator.add(length, longValue, true, comment);
        } else if (value instanceof Character) {
            char charValue = ((Character)value).charValue();
            bytesGenerator.add(length, charValue, true, comment);
        } else if (value instanceof Boolean) {
            long longValue = (Boolean)value != false ? 1 : 0;
            bytesGenerator.add(length, longValue, true, comment);
        } else if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            bytesGenerator.add(length, longValue, true, comment);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            int correctLength = length == 0 ? bytes.length << 3 : length;
            bytesGenerator.add(correctLength, bytes, true, comment);
        } else if (value instanceof String) {
            byte[] bytes = value.toString().getBytes();
            int correctLength = length == 0 ? bytes.length << 3 : length;
            bytesGenerator.add(correctLength, bytes, true, comment);
        } else if (value instanceof BigInteger) {
            byte[] bytes = ((BigInteger)value).toByteArray();
            int correctLength = length == 0 ? bytes.length << 3 : length;
            bytesGenerator.add(correctLength, bytes, true, comment);
        } else if (value instanceof BigDecimal) {
            byte[] bytes = ((BigDecimal)value).toBigInteger().toByteArray();
            int correctLength = length == 0 ? bytes.length << 3 : length;
            bytesGenerator.add(correctLength, bytes, true, comment);
        } else {
            super.updateBytes(bytesGenerator, filterValid);
        }
    }
}

