/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandsElement;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.ExportedServiceElement;
import org.eclipse.soda.devicekit.generator.model.elements.GroupElement;
import org.eclipse.soda.devicekit.generator.model.elements.ImportElement;
import org.eclipse.soda.devicekit.generator.model.elements.InitializeMeasurementsElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileParentElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileUsesElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProtocolElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReceiverElement;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportServiceElement;
import org.eclipse.soda.devicekit.generator.model.elements.UdpTransportElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class DeviceElement
extends MainTagElement {
    private String fInitializeMeasurements;
    private String fPriority;

    public DeviceElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public DeviceElement(Node node, TagElement parent, boolean followReferences) {
        super(node, parent, null, followReferences);
    }

    protected void buildChildren() {
        String name = this.getAttribute("bundle");
        if (name == null) {
            name = this.getId();
        }
        if (name != null) {
            if (!name.toLowerCase().endsWith("device")) {
                name = String.valueOf(name) + "Device";
            }
            TagElement root = this.getParent();
            while (root != null && !(root instanceof RootElement)) {
                root = root.getParent();
            }
        }
        super.buildChildren();
    }

    public List getConfigurations() {
        List result = new ArrayList();
        List controls = this.getAllChildrenWithTagCodes(new int[]{1, 19, 2, 3});
        int i = 0;
        while (i < controls.size()) {
            ControlItem ci = (ControlItem)controls.get(i);
            List configurations = ci.getAllChildrenWithTagCode(70);
            if (configurations != null) {
                result = DeviceKitUtilities.mergeLists(result, configurations);
            }
            ++i;
        }
        return result;
    }

    public String getInitializeMeasurements() {
        return this.fInitializeMeasurements;
    }

    public String getPriority() {
        return this.fPriority;
    }

    public List getRequiredBundles() {
        List list = this.getTransportServiceChildren();
        TagElement element = this.getTransportElement();
        if (element != null) {
            list.add(element);
            list.addAll(element.getRequiredBundles());
        }
        return list;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
    }

    public int getTagCode() {
        return 8;
    }

    protected void handleAdapter(Node node) {
        AdapterElement ese = new AdapterElement(node, this);
        this.addChild(ese);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("command".equals(childNodeName)) {
            this.handleCommand(childNode);
        } else if ("commandref".equals(childNodeName)) {
            this.handleCommandRef(childNode);
        } else if ("signal".equals(childNodeName)) {
            this.handleSignal(childNode);
        } else if ("signalref".equals(childNodeName)) {
            this.handleSignalRef(childNode);
        } else if ("measurement".equals(childNodeName)) {
            this.handleMeasurement(childNode);
        } else if ("measurementref".equals(childNodeName)) {
            this.handleMeasurementRef(childNode);
        } else if ("initializemeasurements".equals(childNodeName)) {
            this.handleInitializeMeasurements(childNode);
        } else if ("priority".equals(childNodeName)) {
            this.setPriority(ParserUtilities.extractData(childNode));
        } else if ("commands".equals(childNodeName)) {
            this.handleCommands(childNode);
        } else if ("exportservice".equals(childNodeName)) {
            this.handleExportedService(childNode);
        } else if ("device".equals(childNodeName)) {
            this.handleDevice(childNode);
        } else if ("adapter".equals(childNodeName)) {
            this.handleAdapter(childNode);
        } else if ("profile".equals(childNodeName)) {
            this.handleProfile(childNode);
        } else if ("profileparent".equals(childNodeName)) {
            this.handleProfileParent(childNode);
        } else if ("profileuses".equals(childNodeName)) {
            this.handleProfileUses(childNode);
        } else if ("protocol".equals(childNodeName)) {
            this.handleProtocol(childNode);
        } else if ("group".equals(childNodeName)) {
            this.handleGroup(childNode);
        } else if ("import".equals(childNodeName)) {
            this.handleImport(childNode);
        } else if ("transport".equals(childNodeName)) {
            this.handleTransport(childNode);
        } else if ("receiver".equals(childNodeName)) {
            this.handleReceiver(childNode);
        } else if ("transportservice".equals(childNodeName)) {
            this.handleTransportService(childNode);
        } else if ("udptransport".equals(childNodeName)) {
            this.handleUdpTransport(childNode);
        } else if ("udp".equals(childNodeName)) {
            this.handleUdpTransport(childNode);
        } else if ("spec".equals(childNodeName)) {
            this.handleSpec(childNode);
        } else if ("commandreceived".equals(childNodeName)) {
            this.setCommandReceived(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleCommand(Node node) {
        CommandElement ce = new CommandElement(node, this);
        this.addChild(ce);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addCommand(ce.getId(), ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleCommandRef(Node node) {
        CommandRefElement ce = new CommandRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleCommands(Node node) {
        CommandsElement ce = new CommandsElement(node, this);
        this.addChild(ce);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addCommand(ce.getId(), ce);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleDevice(Node node) {
        DeviceLinkElement ese = new DeviceLinkElement(node, this);
        this.addChild(ese);
    }

    private void handleExportedService(Node node) {
        ExportedServiceElement ese = new ExportedServiceElement(node, this);
        this.addChild(ese);
    }

    protected void handleGroup(Node node) {
        GroupElement ese = new GroupElement(node, this);
        this.addChild(ese);
    }

    private void handleImport(Node node) {
        ImportElement ie = new ImportElement(node, this);
        this.addChild(ie);
    }

    protected void handleInitializeMeasurements(Node node) {
        this.addChild(new InitializeMeasurementsElement(node, this));
    }

    private void handleMeasurement(Node node) {
        MeasurementElement me = new MeasurementElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMeasurement(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMeasurementRef(Node node) {
        MeasurementRefElement ce = new MeasurementRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    protected void handleProfile(Node node) {
        ProfileElement ese = new ProfileElement(node, this);
        this.addChild(ese);
    }

    private void handleProfileParent(Node childNode) {
        ProfileParentElement ese = new ProfileParentElement(childNode, this);
        this.addChild(ese);
    }

    private void handleProfileUses(Node childNode) {
        ProfileUsesElement ese = new ProfileUsesElement(childNode, this);
        this.addChild(ese);
    }

    protected void handleProtocol(Node node) {
        ProtocolElement ese = new ProtocolElement(node, this);
        this.addChild(ese);
    }

    protected void handleReceiver(Node node) {
        ReceiverElement te = new ReceiverElement(node, this);
        this.addChild(te);
    }

    private void handleSignalRef(Node node) {
        SignalRefElement ce = new SignalRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    protected void handleSpec(Node node) {
        SpecElement se = new SpecElement(node, this);
        this.addChild(se);
        if (se.getId() != null) {
            try {
                TagElement.collection.addSpec(se.getId(), se);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleTransport(Node node) {
        TransportElement te = new TransportElement(node, this);
        this.addChild(te);
    }

    private void handleTransportService(Node node) {
        TransportServiceElement element = new TransportServiceElement(node, this);
        this.addChild(element);
    }

    protected void handleUdpTransport(Node node) {
        UdpTransportElement udpe = new UdpTransportElement(node, this);
        this.addChild(udpe);
    }

    private void setCommandReceived(String commandReceived) {
        this.commandReceived = commandReceived;
    }

    protected void setPriority(String priority) {
        this.fPriority = priority;
    }
}

