/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.elements.CommandRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class DeviceLinkElement
extends DeviceElement {
    public DeviceLinkElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("commandref".equals(childNodeName)) {
            this.handleCommandRef(childNode);
        } else if ("measurementref".equals(childNodeName)) {
            this.handleMeasurementRef(childNode);
        } else if ("signalref".equals(childNodeName)) {
            this.handleSignalRef(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleCommandRef(Node node) {
        CommandRefElement ce = new CommandRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleMeasurementRef(Node node) {
        MeasurementRefElement ce = new MeasurementRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleSignalRef(Node node) {
        SignalRefElement ce = new SignalRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }
}

