/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.BarcodeProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.GpioProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.InventoryProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.WriteProfileElement;
import org.w3c.dom.Node;

public class GenericAdapterElement
extends AdapterElement {
    private static int[] GENERIC_INTERFACES_CODES = new int[]{161, 162, 163, 164};

    public GenericAdapterElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public GenericAdapterElement(Node node, TagElement parent, boolean followReferences) {
        super(node, parent, followReferences);
    }

    public String[] getImplementedGenericInterfaces() {
        List genericInterfaces = this.getChildrenWithTagCodes(GENERIC_INTERFACES_CODES);
        String[] interfaces = new String[genericInterfaces.size()];
        int i = 0;
        while (i < genericInterfaces.size()) {
            TagElement element = (TagElement)genericInterfaces.get(i);
            int tagCode = element.getTagCode();
            switch (tagCode) {
                case 161: {
                    interfaces[i] = DeviceKitGenerationConstants.INTERFACE_GENERIC_INVENTORY_SERVICE;
                    break;
                }
                case 162: {
                    interfaces[i] = DeviceKitGenerationConstants.INTERFACE_GENERIC_GPIO_SERVICE;
                    break;
                }
                case 163: {
                    interfaces[i] = DeviceKitGenerationConstants.INTERFACE_GENERIC_WRITE_SERVICE;
                    break;
                }
                case 164: {
                    interfaces[i] = DeviceKitGenerationConstants.INTERFACE_GENERIC_BARCODE_SERVICE;
                }
            }
            ++i;
        }
        return interfaces;
    }

    public String[] getImplementedInterfaces() {
        String[] genericInterfaces = this.getImplementedGenericInterfaces();
        String[] superInterfaces = super.getImplementedInterfaces();
        if (genericInterfaces.length > 0) {
            String[] interfaces = new String[genericInterfaces.length + superInterfaces.length];
            int i = 0;
            while (i < superInterfaces.length) {
                interfaces[i] = superInterfaces[i];
                ++i;
            }
            i = 0;
            while (i < genericInterfaces.length) {
                interfaces[superInterfaces.length + i] = genericInterfaces[i];
                ++i;
            }
            return interfaces;
        }
        return super.getImplementedInterfaces();
    }

    public List getRequiredBundles() {
        return super.getRequiredBundles();
    }

    public String getServiceType() {
        return super.getServiceType();
    }

    public String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_GENERIC_ADAPTER;
    }

    public int getTagCode() {
        return 160;
    }

    protected void handleBarcodeProfile(Node node) {
        BarcodeProfileElement child = new BarcodeProfileElement(node, this);
        this.addChild(child);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("inventoryprofile".equals(childNodeName)) {
            this.handleInventoryProfile(childNode);
        } else if ("gpioprofile".equals(childNodeName)) {
            this.handleGpioProfile(childNode);
        } else if ("writeprofile".equals(childNodeName)) {
            this.handleWriteProfile(childNode);
        } else if ("barcodeprofile".equals(childNodeName)) {
            this.handleBarcodeProfile(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleGpioProfile(Node node) {
        GpioProfileElement child = new GpioProfileElement(node, this);
        this.addChild(child);
    }

    protected void handleInventoryProfile(Node node) {
        InventoryProfileElement child = new InventoryProfileElement(node, this);
        this.addChild(child);
    }

    protected void handleWriteProfile(Node node) {
        WriteProfileElement child = new WriteProfileElement(node, this);
        this.addChild(child);
    }
}

