/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.internal.model.java.JavaElement;
import org.eclipse.soda.devicekit.generator.internal.model.java.JgfMessages;
import org.eclipse.soda.devicekit.generator.internal.model.java.Type;
import org.eclipse.soda.devicekit.generator.internal.print.java.JavaFileModelPrinter;
import org.eclipse.soda.devicekit.generator.model.java.IJavaModel;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.save.java.IJavaSaver;

public class JavaFileModel
extends JavaElement
implements IJavaModel {
    private ArrayList fImports;
    private IType fType;
    private String fPackage;
    private IJavaSaver fSaver;
    private long fSortOrder;

    public JavaFileModel(String fileName) {
        this(fileName, null, null, 0L);
    }

    public JavaFileModel(String fileName, IJavaSaver saver, String pack, long sortOrder) {
        super(fileName);
        this.fPackage = pack;
        this.fSaver = saver;
        this.fSortOrder = sortOrder;
        this.fImports = new ArrayList();
    }

    public void addImport(String imp) {
        if (!this.fImports.contains(imp) && this.isValidImport(imp)) {
            this.fImports.add(imp);
        }
    }

    public IType createClass(String pack, String name) throws JavaModelException {
        return this.createType(pack, name, 1);
    }

    public IType createInterface(String pack, String name) throws JavaModelException {
        return this.createType(pack, name, 0);
    }

    protected IType createType(String pack, String name, int fileType) throws JavaModelException {
        if (!name.equals(this.getName())) {
            throw new JavaModelException(JgfMessages.getString("org.eclipse.soda.devicekit.generator.java.error.typename"));
        }
        this.fType = new Type(pack, name, fileType);
        return this.fType;
    }

    public String getContents() {
        return this.print(0);
    }

    public String[] getImports() {
        String[] imports = new String[this.fImports.size()];
        this.fImports.toArray(imports);
        return imports;
    }

    public String getPackage() {
        return this.fPackage;
    }

    public long getSortOrder() {
        return this.fSortOrder;
    }

    public IType getType() {
        return this.fType;
    }

    private boolean isValidImport(String imp) {
        if (imp.indexOf("[]") > 0) {
            return false;
        }
        return imp.indexOf(46) != -1;
    }

    public String print(int indentation) {
        return new JavaFileModelPrinter(this).getContents();
    }

    public Object save(IProgressMonitor progressMonitor) throws Exception {
        if (this.fSaver != null) {
            return this.fSaver.save(this, progressMonitor);
        }
        return null;
    }

    public void setPackage(String pack) {
        this.fPackage = pack;
    }

    public void setSaver(IJavaSaver saver) {
        this.fSaver = saver;
    }

    public void setSortOrder(long sortOrder) {
        this.fSortOrder = sortOrder;
    }
}

