/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.save.java;

import java.util.ArrayList;
import org.eclipse.soda.devicekit.generator.model.java.IJavaElement;
import org.eclipse.soda.devicekit.generator.utilty.BitField;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;

public class JavaElementSorter {
    private long fSortOrder;
    private IJavaElement[] fElements;

    public JavaElementSorter(long sortOrder) {
        this.fSortOrder = sortOrder;
    }

    private boolean doSort(short ordering) {
        BitField bf = new BitField(this.fSortOrder);
        return bf.isSet(ordering);
    }

    private IJavaElement[] merge(IJavaElement[] f1, IJavaElement[] f2) {
        IJavaElement[] result = new IJavaElement[f1.length + f2.length];
        System.arraycopy(f1, 0, result, 0, f1.length);
        System.arraycopy(f2, 0, result, f1.length, f2.length);
        return result;
    }

    private IJavaElement[] sort() {
        if (this.doSort((short)2)) {
            return this.sortStatics();
        }
        if (this.doSort((short)1)) {
            return this.sortAlpha(this.fElements);
        }
        return this.fElements;
    }

    public IJavaElement[] sort(IJavaElement[] elements) {
        this.fElements = elements;
        return this.sort();
    }

    private IJavaElement[] sortAlpha(IJavaElement[] elements) {
        SortedSet set = new SortedSet(elements);
        IJavaElement[] result = new IJavaElement[set.size()];
        result = set.toArray(result);
        return result;
    }

    private IJavaElement[] sortStatics() {
        ArrayList<IJavaElement> nonStatics = new ArrayList<IJavaElement>();
        ArrayList<IJavaElement> statics = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < this.fElements.length) {
            if (this.fElements[i].hasIdentifier((short)16)) {
                statics.add(this.fElements[i]);
            } else {
                nonStatics.add(this.fElements[i]);
            }
            ++i;
        }
        IJavaElement[] sElements = new IJavaElement[statics.size()];
        IJavaElement[] nsElements = new IJavaElement[nonStatics.size()];
        sElements = statics.toArray(sElements);
        nsElements = nonStatics.toArray(nsElements);
        if (this.doSort((short)1)) {
            nsElements = this.sortAlpha(nsElements);
        }
        return this.merge(sElements, nsElements);
    }
}

