/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.sim;

import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public abstract class DkDeviceSimGenerator
extends DkDeviceTestGenerator {
    private TestElement fTest;
    private String pack;

    protected DkDeviceSimGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    private void codeConnectionRecFileNameField(IType test) {
        String value = this.getBaseName();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("getStaticString(\"");
        buffer.append(value.toLowerCase());
        buffer.append(".connectionrec\", \"");
        buffer.append(value);
        buffer.append("ConnectionRec.xml\");");
        value = buffer.toString();
        this.codeField(test, "CONNECTION_REC_FILENAME", "String", 50L, "Field CONNECTION_REC_FILENAME.", value);
    }

    protected void codeConstructors(IType monitorTest) {
        String name = this.getMainClassName();
        String contents = this.getConstructorContents();
        String returnType = null;
        String comment = String.valueOf(name) + '.';
        this.codeMethod(monitorTest, name, comment, returnType, 1L, contents);
    }

    protected void codeFields(IType test) {
        this.codeConnectionRecFileNameField(test);
        this.codeTransportRecFileNameField(test);
    }

    protected void codeMethods(IType test) {
        this.codeMain(test);
        this.codeStart(test);
        this.codeStop(test);
    }

    protected void codeRun(IType monitorTest) {
        this.codeMethod(monitorTest, "run", "run.", "void", 1L, "super.run();\n");
    }

    private void codeTransportRecFileNameField(IType test) {
        String value = this.getBaseName();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("getStaticString(\"");
        buffer.append(value.toLowerCase());
        buffer.append(".transportrec\", \"");
        buffer.append(value);
        buffer.append("TransportRec.xml\");");
        value = buffer.toString();
        this.codeField(test, "TRANSPORT_REC_FILENAME", "String", 50L, "Field TRANSPORT_REC_FILENAME.", value);
    }

    private IType createTestType() throws Exception {
        this.fTest = this.getTestElement();
        this.setTestElement(this.fTest);
        this.setMainTagElement(this.fTest);
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
        this.setMainClassName(this.getSimTestName(className));
        this.setPackageBase(this.fTest.getPackageBase());
        this.pack = DeviceKitUtilities.getPackageFromClassName(this.getMainClassName(), this.getPackageBase());
        this.setMainPackage(this.pack);
        String testName = this.getMainClassName();
        String testPackage = this.getMainPackage();
        this.fTestModel = new JavaFileModel(testName);
        this.fTestModel.setComment(this.getCopyright());
        this.fTestModel.setPackage(testPackage);
        IType test = this.createClass(this.fTestModel, testPackage, testName, this.getSourceFolderName());
        String superClass = this.getSuperClass();
        test.setSuperClass(DeviceKitUtilities.stripPackage(superClass));
        this.fTestModel.addImport(superClass);
        String[] interfaces = this.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            test.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            this.fTestModel.addImport(interfaces[i]);
            ++i;
        }
        return test;
    }

    protected void generateSpecificClass() throws JavaModelException {
        try {
            IType test = this.createTestType();
            this.codeConstructors(test);
            this.codeFields(test);
            this.codeMethods(test);
            this.generateCustomMainItems();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract String getBaseName();

    protected abstract String getConstructorContents();

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceFqn()};
    }

    protected String getManifestBundleName() {
        return this.getMainClassName();
    }

    protected abstract String getSimTestName(String var1);

    protected String getSuperClass() {
        return DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
    }
}

