/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.team;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class TeamUtilties {
    public static String baseline = "Eclipse3_3";

    public static void addFileVersionInformation(File srcDir, String filename, StringBuffer buffer, String version) {
        try {
            URI uri = URIUtil.toURI((String)(String.valueOf(srcDir.getAbsolutePath()) + '/' + filename));
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wsRoot = ws.getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files != null && files.length == 1) {
                TeamUtilties.addFileVersionInformation(files[0], buffer, version);
            }
        }
        catch (Exception exception) {}
    }

    public static void addFileVersionInformation(IFile file, StringBuffer buffer, String version) {
        int count = 0;
        String last = "";
        boolean baselineFound = false;
        IProject project = file.getProject();
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)project);
        if (repositoryProvider != null) {
            IFileHistoryProvider fileHistoryProvider = repositoryProvider.getFileHistoryProvider();
            IFileRevision workspaceFileRevision = fileHistoryProvider.getWorkspaceFileRevision((IResource)file);
            if (workspaceFileRevision == null) {
                return;
            }
            if (!workspaceFileRevision.exists()) {
                return;
            }
            try {
                workspaceFileRevision = workspaceFileRevision.withAllProperties((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                return;
            }
            String workspaceRevision = workspaceFileRevision.getContentIdentifier();
            long workspaceTimestamp = workspaceFileRevision.getTimestamp();
            IFileHistory fileHistory = fileHistoryProvider.getFileHistoryFor((IResource)file, 0, (IProgressMonitor)new NullProgressMonitor());
            IFileRevision[] fileRevisions = fileHistory.getFileRevisions();
            if (fileRevisions != null) {
                int i = 0;
                while (i < fileRevisions.length) {
                    CVSFileRevision cvsFile;
                    long timestamp;
                    IFileRevision fileRevision = fileRevisions[i];
                    if (fileRevision.exists() && fileRevision instanceof CVSFileRevision && (timestamp = (cvsFile = (CVSFileRevision)fileRevision).getTimestamp()) <= workspaceTimestamp) {
                        String names;
                        String revision = cvsFile.getContentIdentifier();
                        boolean isCurrent = workspaceRevision.equals(revision);
                        String comment = cvsFile.getComment().trim();
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(timestamp);
                        URI uri = cvsFile.getURI();
                        String path = uri != null ? uri.getPath() : "";
                        String url = "";
                        if (uri != null && path.startsWith("/org.eclipse")) {
                            url = "http://dev.eclipse.org/viewcvs/index.cgi" + path + "?root=Technology_Project";
                        }
                        ITag[] fileTags = cvsFile.getTags();
                        StringBuffer namesBuffer = new StringBuffer(512);
                        String bestName = "";
                        String lastName = "";
                        if (fileTags != null) {
                            int k = 0;
                            while (k < fileTags.length) {
                                String name = fileTags[k].getName();
                                if (k > 0) {
                                    namesBuffer.append(", \r");
                                    lastName = name;
                                } else {
                                    bestName = name;
                                }
                                namesBuffer.append(name);
                                ++count;
                                ++k;
                            }
                        }
                        if ((names = namesBuffer.toString()).indexOf(TeamUtilties.getBaseline()) >= 0) {
                            bestName = "<em title=\"Baseline file.\">" + TeamUtilties.getBaseline() + "</em>";
                        } else if (lastName.length() > 0) {
                            bestName = String.valueOf(bestName) + " .. " + lastName;
                        }
                        StringBuffer entryBuffer = new StringBuffer(256);
                        entryBuffer.append("<tr><td align=\"left\" title=\"");
                        entryBuffer.append(names);
                        entryBuffer.append("\">");
                        entryBuffer.append(bestName);
                        entryBuffer.append("</td><td align=\"left\">\r\n");
                        TeamUtilties.formatDate(calendar, entryBuffer);
                        entryBuffer.append("</td><td align=\"left\">\r\n");
                        if (isCurrent) {
                            entryBuffer.append("<b>");
                            entryBuffer.append(revision);
                            entryBuffer.append("</b>");
                        } else {
                            entryBuffer.append(revision);
                        }
                        boolean goodComment = false;
                        if (comment.length() > 0 && comment.indexOf("empty log") == -1) {
                            entryBuffer.append("</td><td align=\"left\">\r\n");
                            entryBuffer.append(comment);
                            goodComment = true;
                        }
                        entryBuffer.append("</td></tr>\r\n");
                        if (isCurrent) {
                            buffer.append("<hr/>\r\n");
                            if (path.startsWith("/org.eclipse")) {
                                buffer.append("<a title=\"Bugzilla link\" href=\"");
                                buffer.append("https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Equinox&component=Incubator.DeviceKit");
                                buffer.append("\">");
                                buffer.append("Bugzilla:");
                                buffer.append("</a>&nbsp;");
                                buffer.append("<a href=\"");
                                buffer.append("https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Equinox&component=Incubator.DeviceKit");
                                buffer.append("\">");
                                buffer.append("https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Equinox&component=Incubator.DeviceKit");
                                buffer.append("</a><br/>");
                            }
                            buffer.append("CVS File: ");
                            TeamUtilties.printPath(path, url, buffer);
                            buffer.append(" (");
                            buffer.append(workspaceRevision);
                            buffer.append(')');
                            buffer.append("</a>");
                            buffer.append("\r\n<table width=\"auto\">\r\n");
                            buffer.append("<tr>\r\n");
                            buffer.append("<th>Tag(s)</th>\r\n");
                            buffer.append("<th>Timestamp</th>\r\n");
                            buffer.append("<th>Revision</th>\r\n");
                            buffer.append("<th>Comment</th>\r\n");
                            buffer.append("</tr>\r\n");
                            buffer.append(entryBuffer.toString());
                        } else if (names.indexOf(TeamUtilties.getBaseline()) >= 0) {
                            if (!baselineFound) {
                                buffer.append(entryBuffer.toString());
                                baselineFound = true;
                            }
                            last = "";
                        } else if (i < 10) {
                            if (bestName.length() > 0 || goodComment) {
                                buffer.append(entryBuffer.toString());
                                last = "";
                            }
                        } else {
                            last = entryBuffer.toString();
                        }
                    }
                    ++i;
                }
            }
        }
        if (count > 0) {
            if (last.length() > 0) {
                buffer.append(last);
            }
            buffer.append("</table>\r\n");
        }
    }

    public static void formatDate(Calendar calendar, StringBuffer entryBuffer) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        entryBuffer.append(year);
        entryBuffer.append('-');
        if (month < 10) {
            entryBuffer.append('0');
        }
        entryBuffer.append(month);
        entryBuffer.append('-');
        if (day < 10) {
            entryBuffer.append('0');
        }
        entryBuffer.append(day);
    }

    public static String getBaseline() {
        return baseline;
    }

    public static InputStream getBranchStream(File srcDir, String filename) {
        return TeamUtilties.getBranchStream(srcDir, filename, TeamUtilties.getBaseline());
    }

    public static InputStream getBranchStream(File srcDir, String filename, String baseline) {
        try {
            URI uri = URIUtil.toURI((String)(String.valueOf(srcDir.getAbsolutePath()) + '/' + filename));
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wsRoot = ws.getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files != null && files.length == 1) {
                InputStream branchIS = TeamUtilties.getBranchStream(files[0], baseline);
                return branchIS;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static InputStream getBranchStream(IFile file, String baseline) {
        RepositoryProvider repositoryProvider;
        IProject project = file.getProject();
        boolean isShared = RepositoryProvider.isShared((IProject)project);
        if (isShared && (repositoryProvider = RepositoryProvider.getProvider((IProject)project)) != null) {
            ICVSRemoteFile fileVersion = TeamUtilties.getFileVersion(file, baseline);
            try {
                if (fileVersion != null) {
                    return fileVersion.getContents((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static String[] getBranchStreamIds(File srcDir, String filename) {
        try {
            URI uri = URIUtil.toURI((String)(String.valueOf(srcDir.getAbsolutePath()) + '/' + filename));
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wsRoot = ws.getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files != null && files.length == 1) {
                String[] ids = TeamUtilties.getBranchStreamIds(files[0]);
                return ids;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String[] getBranchStreamIds(IFile file) {
        RepositoryProvider repositoryProvider;
        IProject project = file.getProject();
        boolean isShared = RepositoryProvider.isShared((IProject)project);
        if (isShared && (repositoryProvider = RepositoryProvider.getProvider((IProject)project)) != null) {
            String[] ids = TeamUtilties.getFileVersionInformation(file);
            try {
                if (ids != null) {
                    return ids;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static ICVSRemoteFile getFileVersion(IFile file, String baseline) {
        IFileHistoryProvider fileHistoryProvider;
        IFileHistory fileHistory;
        IFileRevision[] fileRevisions;
        IProject project = file.getProject();
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)project);
        if (repositoryProvider != null && (fileRevisions = (fileHistory = (fileHistoryProvider = repositoryProvider.getFileHistoryProvider()).getFileHistoryFor((IResource)file, 0, (IProgressMonitor)new NullProgressMonitor())).getFileRevisions()) != null) {
            int i = 0;
            while (i < fileRevisions.length) {
                CVSFileRevision cvsFile;
                ITag[] fileTags;
                IFileRevision fileRevision = fileRevisions[i];
                if (fileRevision.exists() && fileRevision instanceof CVSFileRevision && (fileTags = (cvsFile = (CVSFileRevision)fileRevision).getTags()) != null) {
                    int k = 0;
                    while (k < fileTags.length) {
                        String name = fileTags[k].getName();
                        if (name.equals(baseline)) {
                            ICVSRemoteFile remoteFile = cvsFile.getCVSRemoteFile();
                            return remoteFile;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static String[] getFileVersionInformation(IFile file) {
        IFileHistoryProvider fileHistoryProvider;
        IFileHistory fileHistory;
        IFileRevision[] fileRevisions;
        ArrayList<String> list = new ArrayList<String>();
        IProject project = file.getProject();
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)project);
        if (repositoryProvider != null && (fileRevisions = (fileHistory = (fileHistoryProvider = repositoryProvider.getFileHistoryProvider()).getFileHistoryFor((IResource)file, 0, (IProgressMonitor)new NullProgressMonitor())).getFileRevisions()) != null) {
            int i = 0;
            while (i < fileRevisions.length) {
                ITag[] tags;
                IFileRevision fileRevision = fileRevisions[i];
                if (fileRevision.exists() && (tags = fileRevision.getTags()) != null) {
                    int j = 0;
                    while (j < tags.length) {
                        CVSFileRevision cvsFile;
                        ITag[] fileTags;
                        if (fileRevision instanceof CVSFileRevision && (fileTags = (cvsFile = (CVSFileRevision)fileRevision).getTags()) != null) {
                            int k = 0;
                            while (k < tags.length) {
                                String name = fileTags[k].getName();
                                list.add(name);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        int size = list.size();
        String[] ids = new String[size];
        ids = list.toArray(ids);
        return ids;
    }

    public static String getFileVersionInformationHtml(File srcDir, String filename, String version) {
        StringBuffer buffer = new StringBuffer(2048);
        TeamUtilties.addFileVersionInformation(srcDir, filename, buffer, version);
        return buffer.toString();
    }

    public static IFile getIFile(File srcDir, String filename) {
        try {
            URI uri = URIUtil.toURI((String)(String.valueOf(srcDir.getAbsolutePath()) + '/' + filename));
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wsRoot = ws.getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files != null && files.length == 1) {
                return files[0];
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static CVSTag[] getTags(ICVSFolder remoteFolder) {
        if (remoteFolder != null) {
            CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(remoteFolder, 1);
            if (tags != null && tags.length > 0) {
                return tags;
            }
            ICVSFolder remoteParent = remoteFolder.getParent();
            if (remoteParent != null) {
                return TeamUtilties.getTags(remoteParent);
            }
        }
        return null;
    }

    public static void printPath(String path, String url, StringBuffer buffer) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        int depth = 1;
        buffer.append("<code>\r\n");
        int number = tokenizer.countTokens();
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            ++count;
            String token = tokenizer.nextToken();
            buffer.append("<br/>");
            int i = 0;
            while (i < depth) {
                buffer.append("&nbsp;&nbsp;");
                ++i;
            }
            if (count == number && url.length() > 0) {
                buffer.append("<a href=\"");
                buffer.append(url);
                buffer.append("\">");
                buffer.append(token);
                buffer.append("</a>");
            } else {
                buffer.append(token);
            }
            buffer.append("\r\n");
            ++depth;
        }
        buffer.append("</code>\r\n");
    }

    public static void setBaseline(String baseline) {
        TeamUtilties.baseline = baseline;
    }
}

