/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.templates;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.soda.devicekit.generator.templates.DeviceKitVersion;
import org.eclipse.soda.devicekit.generator.templates.SystemVariables;

public class GeneratorContextType
extends TemplateContextType {
    public static final String NAME = "org.eclipse.soda.devicekit.generator.templates.contexttype";
    public static final String CUSTOM_TEMPLATES = "org.eclipse.soda.devicekit.generator.templates.customtemplates";

    public GeneratorContextType() {
        this(NAME);
        this.addResolvers();
    }

    public GeneratorContextType(String id) {
        super(id);
    }

    public GeneratorContextType(String id, String name) {
        super(id, name);
        this.addResolvers();
    }

    protected void addResolvers() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver((TemplateVariableResolver)new DeviceKitVersion());
        Properties systemProperties = System.getProperties();
        Iterator<Map.Entry<Object, Object>> iterator = systemProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = "system_" + String.valueOf(entry.getKey()).replace('.', '_');
            String value = String.valueOf(entry.getValue());
            this.addResolver((TemplateVariableResolver)new SystemVariables(key, key, value));
        }
    }
}

