/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.GenericAdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkGenericAdapterGenerator
extends DkDeviceGenerator {
    protected TagElement targetDevice;

    public DkGenericAdapterGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap(), 0);
    }

    public DkGenericAdapterGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map properties, int bundleType) {
        super(model, generatedInfo, properties, bundleType);
    }

    protected void codeDefaultTransport(IType device) {
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_ADAPTER_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_ADAPTER_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_ADAPTER_BUNDLE_ACTIVATOR;
    }

    protected String getConstructorContents(List parents) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("super();\n");
        buffer.append("setKey(getDefaultKey());\t//The super class defines the common measurements\n");
        buffer.append("initialize();\n");
        return buffer.toString();
    }

    protected GenericAdapterElement getGenericAdapterElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (160 == ((TagElement)children.get(i)).getTagCode()) {
                return (GenericAdapterElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected List getManifestImportPackages() {
        List imports = super.getManifestImportPackages();
        String[] genericInterfaces = ((GenericAdapterElement)this.getMainElement()).getImplementedGenericInterfaces();
        int i = 0;
        while (i < genericInterfaces.length) {
            String packageName = DeviceKitUtilities.extractPackage(genericInterfaces[i]);
            if (!imports.contains(packageName)) {
                imports.add(packageName);
            }
            ++i;
        }
        return imports;
    }

    protected List getParentElements() {
        return this.getMainElement().getAllChildrenWithTagCode(157);
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE;
    }

    public TagElement getTargetDevice() {
        return this.targetDevice;
    }

    protected void initialize() {
        List genericadapters = this.getRootElement().getAllChildrenWithTagCode(160);
        GenericAdapterElement adapter = (GenericAdapterElement)genericadapters.get(0);
        this.setDevice(adapter);
        this.setMainTagElement(adapter);
        String className = DeviceKitUtilities.getClassNameFromTagElement(adapter);
        this.setMainClassName(className);
        this.setPackageBase(adapter.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (adapter.getAttribute("lazy") == null || "false".equals(adapter.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (adapter.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = adapter.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }

    public void setTargetDevice(TagElement targetDevice) {
        this.targetDevice = targetDevice;
    }
}

