/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;

public class ConfigurationField {
    protected CustomParameterElement customParameterElement = null;
    protected String type = "";
    protected String metaType = "";
    protected String codeName = "";
    protected String qualifiedName = null;
    protected String name;
    protected String displayName = null;
    protected String value;
    protected String codeNameOld = "";
    protected String description = "";

    public ConfigurationField(CustomParameterElement customParameterElement) {
        this.customParameterElement = customParameterElement;
        this.name = customParameterElement.getKey();
        this.type = customParameterElement.getType();
        this.metaType = customParameterElement.getValidMetaType();
        this.value = customParameterElement.getDefaultValue();
        this.displayName = customParameterElement.getDisplayName();
        this.description = customParameterElement.getDescription();
    }

    public ConfigurationField(String type, String codeName, String value) {
        this.type = type;
        this.codeName = codeName;
        this.value = value;
    }

    public ConfigurationField(String configurationName, String type, String metaType, String value, String description) {
        this(configurationName, type, metaType, value, description, "");
    }

    public ConfigurationField(String configurationName, String type, String metaType, String value, String description, String codeNameOld) {
        this.type = type;
        this.name = configurationName;
        this.value = value;
        this.metaType = metaType;
        this.description = description;
        this.codeNameOld = codeNameOld;
    }

    public String getCodeDefaultName() {
        StringBuffer buffer = new StringBuffer(128);
        if (this.codeName.length() > 0) {
            buffer.append(CodeUtilities.staticFieldName(this.codeName, true));
        } else {
            buffer.append(CodeUtilities.staticFieldName(this.name, true));
        }
        buffer.append("_DEFAULT");
        return buffer.toString();
    }

    public String getCodeDefaultNameQualified() {
        StringBuffer buffer = new StringBuffer(128);
        String qualifiedName = this.getQualifiedName();
        if (qualifiedName != null && qualifiedName.length() > 0) {
            buffer.append(CodeUtilities.staticFieldName(qualifiedName, true));
            buffer.append('_');
        }
        buffer.append(this.getCodeDefaultName());
        return buffer.toString();
    }

    public String getCodeName() {
        if (this.codeName != null && this.codeName.length() > 0) {
            return this.codeName;
        }
        return CodeUtilities.staticFieldName(this.name, true);
    }

    public String getCodeNameOld() {
        return this.codeNameOld;
    }

    public String getCodePropertyName() {
        StringBuffer buffer = new StringBuffer(128);
        if (this.codeName.length() > 0) {
            buffer.append(CodeUtilities.staticFieldName(this.codeName, true));
        } else {
            buffer.append(CodeUtilities.staticFieldName(this.name, true));
        }
        buffer.append("_PROPERTY");
        return buffer.toString();
    }

    public String getCodePropertyNameQualified() {
        StringBuffer buffer = new StringBuffer(128);
        String qualifiedName = this.getQualifiedName();
        if (qualifiedName != null && qualifiedName.length() > 0) {
            buffer.append(CodeUtilities.staticFieldName(qualifiedName, true));
            buffer.append('_');
        }
        buffer.append(this.getCodePropertyName());
        return buffer.toString();
    }

    public String getCodeType() {
        String type = this.getType();
        String compareType = type.toLowerCase();
        if ("integer".equals(compareType)) {
            return "int";
        }
        if ("long".equals(compareType)) {
            return "long";
        }
        if ("short".equals(compareType)) {
            return "short";
        }
        if ("character".equals(compareType)) {
            return "char";
        }
        if ("byte".equals(compareType)) {
            return "byte";
        }
        return type;
    }

    public String getConfigurationName() {
        return this.name;
    }

    public String getConfigurationNameQualified() {
        String qualifiedName = this.getQualifiedName();
        if (qualifiedName.length() > 0) {
            StringBuffer buffer = new StringBuffer(128);
            buffer.append(qualifiedName.toLowerCase());
            buffer.append('.');
            buffer.append(this.name.toLowerCase());
            return buffer.toString();
        }
        return this.name.toLowerCase();
    }

    public CustomParameterElement getCustomParameterElement() {
        return this.customParameterElement;
    }

    public String getDeprecated() {
        return this.customParameterElement != null ? this.customParameterElement.getDeprecated() : null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        if (this.displayName != null && this.displayName.length() > 0) {
            return this.displayName;
        }
        return CodeUtilities.betterName(this.name, false);
    }

    public EnumElement[] getEnumElements() {
        List list;
        int size;
        if (this.customParameterElement != null && (size = (list = this.customParameterElement.getAllChildrenWithTagCode(77)).size()) > 0) {
            EnumElement[] enums = new EnumElement[size];
            int i = 0;
            while (i < size) {
                enums[i] = (EnumElement)list.get(i);
                ++i;
            }
            return enums;
        }
        return new EnumElement[0];
    }

    public String getMetaType() {
        return this.metaType;
    }

    public String getName() {
        return this.name;
    }

    public String getParameterName() {
        return this.name;
    }

    public String getQualifiedName() {
        String id;
        TagElement parent;
        if (this.qualifiedName != null) {
            return this.qualifiedName;
        }
        if (this.customParameterElement != null && (parent = this.customParameterElement.getParent()) != null && (id = parent.getAnyId()) != null) {
            if (id.endsWith("Connection")) {
                return id.substring(0, id.length() - "Connection".length()).toLowerCase();
            }
            return "";
        }
        return "";
    }

    public String getServiceName() {
        String serviceName;
        TagElement parent;
        if (this.customParameterElement != null && (parent = this.customParameterElement.getParent()) != null && (serviceName = parent.getServiceName()) != null) {
            return serviceName;
        }
        return "";
    }

    public String getType() {
        if (this.type.length() > 0) {
            return this.type;
        }
        return "String";
    }

    public String getValue() {
        return this.value;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }
}

