/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import org.eclipse.soda.devicekit.ui.testmanager.util.TestManagerImages;
import org.eclipse.swt.graphics.Image;

public class ProgressImages {
    private static final int PROGRESS_STEPS = 9;
    private static final String FAILURE = "ff";
    private static final String OK = "ss";
    private Image[] fOKImages = new Image[9];
    private Image[] fFailureImages = new Image[9];

    public void dispose() {
        if (!this.isLoaded()) {
            return;
        }
        int i = 0;
        while (i < 9) {
            this.fOKImages[i].dispose();
            this.fOKImages[i] = null;
            this.fFailureImages[i].dispose();
            this.fFailureImages[i] = null;
            ++i;
        }
    }

    public Image getImage(int current, int total, int errors, int failures) {
        if (!this.isLoaded()) {
            this.load();
        }
        if (total == 0) {
            return this.fOKImages[0];
        }
        int index = current * 9 / total - 1;
        index = Math.min(Math.max(0, index), 8);
        if (errors + failures == 0) {
            return this.fOKImages[index];
        }
        return this.fFailureImages[index];
    }

    private boolean isLoaded() {
        return this.fOKImages[0] != null;
    }

    private void load() {
        if (this.isLoaded()) {
            return;
        }
        int i = 0;
        while (i < 9) {
            String okname = OK + Integer.toString(i + 1) + ".gif";
            this.fOKImages[i] = TestManagerImages.createImageDescriptor("prgss/", okname).createImage();
            String failurename = FAILURE + Integer.toString(i + 1) + ".gif";
            this.fFailureImages[i] = TestManagerImages.createImageDescriptor("prgss/", failurename).createImage();
            ++i;
        }
    }
}

