/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestModel;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestManagerImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Element;

public class TestReportLabelDecorator
implements ILabelDecorator {
    private ListenerList fListeners;

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
    }

    private int computeAdornmentFlags(Object obj) {
        if (obj instanceof Element) {
            Element element = (Element)obj;
            if (TestModel.hasErrorInDecendants(element)) {
                return 2;
            }
            if (TestModel.hasFailureInDecendants(element)) {
                return 4;
            }
            if (element.getAttribute("end").length() > 0) {
                return 1;
            }
        }
        return 0;
    }

    public Image decorateImage(Image image, Object element) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return TestManagerPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new TestManagerImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public class ImageImageDescriptor
    extends ImageDescriptor {
        private Image fImage;

        public ImageImageDescriptor(Image image) {
            this.fImage = image;
        }

        public boolean equals(Object obj) {
            return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.fImage.equals((Object)((ImageImageDescriptor)((Object)obj)).fImage);
        }

        public ImageData getImageData() {
            return this.fImage.getImageData();
        }

        public int hashCode() {
            return this.fImage.hashCode();
        }
    }
}

