/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.util.DkJxeRuleGenerator;
import org.eclipse.soda.devicekit.generator.util.PreGenElementHolder;
import org.eclipse.soda.devicekit.ui.DeviceKitException;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.ui.WorkbenchException;
import org.w3c.dom.Node;

public class GenerateOperation
implements IWorkspaceRunnable {
    private boolean custom;
    private PreGenElementHolder customElements;
    private IFile[] files;
    private Object[] generatedProjects;
    private boolean genManifest = false;
    private boolean jxeFileChanged = false;
    private Map properties;
    private String[] requiredClasses;
    private boolean testAntScript = false;

    public GenerateOperation(Map variables, IFile[] files) {
        this(variables, files, false);
    }

    public GenerateOperation(Map variables, IFile[] files, boolean custom) {
        this.files = files;
        this.custom = custom;
    }

    private boolean generateJxeRules(Node node, IFile dkmlFile) throws Exception {
        return this.generateJxeRules(node, dkmlFile, this.getRequiredClasses());
    }

    private boolean generateJxeRules(Node node, IFile dkmlFile, String[] required) throws Exception {
        DkJxeRuleGenerator gen = new DkJxeRuleGenerator(node, dkmlFile);
        if (required != null) {
            int i = 0;
            while (i < required.length) {
                gen.addRequiredEntry(required[i]);
                ++i;
            }
        }
        return gen.generate();
    }

    public boolean generateTestScript() {
        return this.testAntScript;
    }

    public PreGenElementHolder getCustomElements() {
        return this.customElements;
    }

    public Object[] getGeneratedProjects() {
        return this.generatedProjects;
    }

    private Map getMethodProperties() {
        return this.properties;
    }

    private Object[] getProjectsFromFiles(List cus) {
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < cus.size()) {
            if (cus.get(i) instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)cus.get(i);
                if (!result.contains(cu.getParent().getJavaProject())) {
                    result.add(cu.getParent().getJavaProject());
                }
            } else {
                System.out.println("why " + cus.get(i));
            }
            ++i;
        }
        return result.toArray();
    }

    private List getReferencedFiles(IFile file) throws CoreException {
        try {
            DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
            return resolver.getReferences();
        }
        catch (Exception exception) {
            RuntimeException e = new RuntimeException("can not find " + file.getFullPath());
            throw new WorkbenchException(e.toString(), (Throwable)e);
        }
    }

    private String[] getRequiredClasses() {
        return this.requiredClasses;
    }

    protected CoreException handleError(Exception e) throws CoreException {
        throw new DeviceKitException(String.valueOf(e), e);
    }

    public boolean jxeFileChanged() {
        return this.jxeFileChanged;
    }

    public void run(IProgressMonitor progressMonitor) throws CoreException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        monitor.beginTask("", this.files.length * 100);
        StringBuffer errorBuffer = new StringBuffer(1024);
        int i = 0;
        while (i < this.files.length) {
            if (!monitor.isCanceled()) {
                IFile file = this.files[i];
                String projectName = file.getProject().getName();
                try {
                    monitor.setTaskName(String.valueOf(projectName) + '/' + file.getName());
                    monitor.subTask(projectName);
                    DeviceKitGenerator dkg = new DeviceKitGenerator(monitor, this.files[i], this.getReferencedFiles(this.files[i]), this.custom, this.genManifest);
                    dkg.setMethodProperties(this.getMethodProperties());
                    String schema = null;
                    dkg.setSchema(schema);
                    monitor.worked(4);
                    dkg.generate(monitor);
                    monitor.worked(2);
                    this.customElements = dkg.getCustomHolder();
                    this.setGeneratedProjects(this.getProjectsFromFiles(dkg.getGeneratedFiles()));
                    monitor.worked(2);
                    if (dkg.generateTestScript()) {
                        this.testAntScript = true;
                    }
                    monitor.worked(2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (this.files.length == 1) {
                        throw new DeviceKitException(exception.toString(), exception);
                    }
                    errorBuffer.append(projectName);
                    errorBuffer.append('/');
                    errorBuffer.append(file.getName());
                    errorBuffer.append(' ');
                    errorBuffer.append(exception);
                    errorBuffer.append('\n');
                }
            }
            ++i;
        }
        if (errorBuffer.length() > 0) {
            throw new DeviceKitException(errorBuffer.toString());
        }
        monitor.done();
    }

    protected void setGeneratedProjects(Object[] generatedProjects) {
        this.generatedProjects = generatedProjects;
    }

    public void setGenerateManifest(boolean genManifest) {
        this.genManifest = genManifest;
    }

    public void setMethodProperties(Map properties) {
        this.properties = properties;
    }

    protected void setRequiredClasses(String[] requiredClasses) {
        this.requiredClasses = requiredClasses;
    }
}

