/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit;

import java.util.Dictionary;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soda.devicekit.xmlsource.XmlSourceLoader;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DeviceKitPlugin
extends AbstractUIPlugin
implements IStartup {
    private static DeviceKitPlugin plugin;
    private XmlSourceLoader xmlSourceLoader;

    public DeviceKitPlugin() {
        plugin = this;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DeviceKitPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = DeviceKitPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            Shell shell = windows[i].getShell();
            if (shell != null) {
                return shell;
            }
            ++i;
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DeviceKitPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static DeviceKitPlugin getDefault() {
        return plugin;
    }

    public static String getEclipseVersion() {
        Dictionary headers;
        Object value;
        IProduct product = Platform.getProduct();
        if (product != null && (value = (headers = product.getDefiningBundle().getHeaders()).get("Bundle-Version")) != null) {
            String fullVersion = value.toString();
            int index = fullVersion.lastIndexOf(46);
            if (index > 0) {
                return fullVersion.substring(0, index);
            }
            return fullVersion;
        }
        return "3.3";
    }

    public static String getFeature() {
        return "org.eclipse.soda.devicekit";
    }

    public static String getFeatureName() {
        return "Device Kit";
    }

    public static final boolean getGenerateJava() {
        return DeviceKitPlugin.getDefault().getPreferenceStore().getBoolean("generate.java");
    }

    public static final boolean getGenerateManifest() {
        return DeviceKitPlugin.getDefault().getPreferenceStore().getBoolean("generate.manifest");
    }

    public static final boolean getGenerateMetadata() {
        return DeviceKitPlugin.getDefault().getPreferenceStore().getBoolean("generate.metadata");
    }

    public static final boolean getGenerateOld() {
        return DeviceKitPlugin.getDefault().getPreferenceStore().getBoolean("generateold");
    }

    public static final boolean getGenerateProperties() {
        return DeviceKitPlugin.getDefault().getPreferenceStore().getBoolean("generate.properties");
    }

    public static final String getIncubation() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("incubation");
        }
        return "true";
    }

    public static final String getMultiplex() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("multiplex");
        }
        return "false";
    }

    public static final String getOverride() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("override");
        }
        return "false";
    }

    public static final String getPackageBase() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("packagebase");
        }
        return "org.eclipse.dk.soda";
    }

    public static String getPluginId() {
        return "org.eclipse.soda.devicekit";
    }

    public static final String getProvider() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("provider");
        }
        return "Eclipse.org";
    }

    public static final String getVendor() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("vendor");
        }
        return "IBM";
    }

    public static final String getVendorTwo() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("vendortwo");
        }
        return "";
    }

    public static final String getVendors() {
        String vendor = DeviceKitPlugin.getVendor();
        if (vendor == null || vendor.length() == 0) {
            return "";
        }
        String vendorTwo = DeviceKitPlugin.getVendorTwo();
        if (vendorTwo == null || vendorTwo.length() == 0) {
            return vendor;
        }
        return String.valueOf(vendor) + ", " + vendorTwo;
    }

    public static final String getVersion() {
        DeviceKitPlugin deviceKitPlugin = DeviceKitPlugin.getDefault();
        if (deviceKitPlugin != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("version");
        }
        return "1.2.0";
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static final boolean isIncubation() {
        String incubation = DeviceKitPlugin.getIncubation();
        return incubation != null && ("true".equals(incubation) || "1".equals(incubation));
    }

    public static final boolean isIncubation(String incubation) {
        return incubation != null && ("true".equals(incubation) || "1".equals(incubation));
    }

    public void earlyStartup() {
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public Map getXmlFiles() {
        return this.getXmlSourceLoader().getXmlFiles();
    }

    public XmlSourceLoader getXmlSourceLoader() {
        if (this.xmlSourceLoader == null) {
            this.xmlSourceLoader = new XmlSourceLoader();
            this.xmlSourceLoader.loadXmlFiles();
        }
        return this.xmlSourceLoader;
    }

    public Map getXmlTypes() {
        return this.getXmlSourceLoader().getXmlTypes();
    }
}

