/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.adapter.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.adapter.test.AdapterTestResourceBundle;
import org.eclipse.soda.dk.adapter.test.service.AdapterTestService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.service.MultiplexDeviceListener;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.client.NotificationClient;
import org.eclipse.soda.dk.notification.client.NotificationController;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ConnectionTransportService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class AdapterTest
extends NotificationClient
implements AdapterTestService,
Runnable,
MultiplexCommandListener,
MultiplexSignalListener,
MultiplexMeasurementListener,
MultiplexDeviceListener {
    public static final String CLASS_NAME;
    public static final int PRIORITY_DEFAULT = 3;
    public static final int DEFAULT_PRIORITY = 3;
    public static final int TEST_COUNT_DEFAULT = 2;
    public static final int DEFAULT_TEST_COUNT = 2;
    public static final long TEST_DELAY_DEFAULT = 0L;
    public static final long DEFAULT_TEST_DELAY = 0L;
    public static final boolean TEST_EXECUTE_DEFAULT = false;
    public static final boolean DEFAULT_TEST_EXECUTE = false;
    public static final boolean TEST_EXECUTE_READ_DEFAULT = true;
    public static final boolean DEFAULT_TEST_EXECUTE_READ = true;
    public static final boolean TEST_EXECUTE_WRITE_DEFAULT = false;
    public static final boolean DEFAULT_TEST_EXECUTE_WRITE = false;
    public static final boolean TEST_READ_DEFAULT = false;
    public static final boolean DEFAULT_TEST_READ = false;
    public static final boolean TEST_TRIGGER_DEFAULT = false;
    public static final boolean DEFAULT_TEST_TRIGGER = false;
    public static final long TOTAL_TEST_TIME_DEFAULT = 60000L;
    public static final long DEFAULT_TOTAL_TEST_TIME = 60000L;
    public static final long READ_TIMEOUT_DEFAULT = 10000L;
    public static final long DEFAULT_READ_TIMEOUT = 10000L;
    protected static final int DEVICE_TEST_DEAD_STATE_RESOURCE = 4500;
    protected static final int DEVICE_TEST_CREATED_STATE_RESOURCE = 4501;
    protected static final int DEVICE_TEST_ALIVE_STATE_RESOURCE = 4502;
    protected static final int DEVICE_TEST_CONNECTED_STATE_RESOURCE = 4503;
    protected static final int DEVICE_TEST_ACTIVE_STATE_RESOURCE = 4504;
    protected static final int DEVICE_TEST_STARTED_STATE_RESOURCE = 4505;
    protected static final int[] DEVICE_TEST_STATE_RESOURCE_TABLE;
    protected static final int DEVICE_TEST_ERROR_NOTIFICATION_RESOURCE = 4506;
    protected static final int DEVICE_TEST_SIGNAL_NOTIFICATION_RESOURCE = 4507;
    protected static final int DEVICE_TEST_SIGNAL_DATA_NOTIFICATION_RESOURCE = 4508;
    protected static final int DEVICE_TEST_COMMAND_NOTIFICATION_RESOURCE = 4509;
    protected static final int DEVICE_TEST_COMMAND_DATA_NOTIFICATION_RESOURCE = 4510;
    protected static final int DEVICE_TEST_MEASUREMENT_NOTIFICATION_RESOURCE = 4511;
    protected static final int DEVICE_TEST_MEASUREMENT_VALUE_NOTIFICATION_RESOURCE = 4512;
    protected static final int DEVICE_TEST_START_RESOURCE = 4513;
    protected static final int DEVICE_TEST_STOP_RESOURCE = 4514;
    protected static final int DEVICE_TEST_WAITING_RESOURCE = 4515;
    protected static final int DEVICE_TEST_SEND_EXCEPTION_RESOURCE = 4516;
    protected static final int DEVICE_TEST_COMMAND_NOT_FOUND_RESOURCE = 4517;
    protected static final int DEVICE_TEST_MEASUREMENT_NOT_FOUND_RESOURCE = 4518;
    protected static final int DEVICE_TEST_SIGNAL_NOT_FOUND_RESOURCE = 4519;
    protected static final int DEVICE_TEST_COMMAND_EXCEPTION_RESOURCE = 4520;
    protected static final int DEVICE_TEST_MEASUREMENT_EXCEPTION_RESOURCE = 4521;
    protected static final int DEVICE_TEST_SIGNAL_EXCEPTION_RESOURCE = 4522;
    protected static final int DEVICE_TEST_START_EXECUTION_RESOURCE = 4523;
    protected static final int DEVICE_TEST_STOP_EXECUTION_RESOURCE = 4524;
    protected static final int DEVICE_TEST_CONTROL_NOTIFICATION_RESOURCE = 4525;
    protected static final int DEVICE_TEST_EXIT_RESOURCE = 4526;
    protected static final int DEVICE_TEST_DEVICE_CONFIGURATION_MISCOMPARE_RESOURCE = 4527;
    protected static final int DEVICE_TEST_DATA_NOTIFICATION_RESOURCE = 4528;
    public static final String ID_VALUE = "T1";
    public static final String PREFIX_VALUE = "T1";
    private static ResourceBundle DefaultResourceBundle;
    private boolean active = false;
    private DeviceService device = null;
    private AdapterService adapter = null;
    private int testCount = AdapterTest.getStaticInt((String)"devicetest.testcount", (int)2);
    private long testDelay = this.getLong("devicetest.testdelay", 0L);
    private boolean testExecute = AdapterTest.getStaticBoolean((String)"devicetest.testexecute", (boolean)false);
    private boolean testExecuteRead = AdapterTest.getStaticBoolean((String)"devicetest.testexecuteread", (boolean)true);
    private boolean testExecuteWrite = AdapterTest.getStaticBoolean((String)"devicetest.testexecutewrite", (boolean)false);
    private boolean testRead = AdapterTest.getStaticBoolean((String)"devicetest.testread", (boolean)false);
    private boolean testTrigger = AdapterTest.getStaticBoolean((String)"devicetest.testtrigger", (boolean)false);
    private long totalTestTime = AdapterTest.getStaticLong((String)"devicetest.totaltesttime", (long)0L);
    private long readTimeout = 0L;
    private int priority = AdapterTest.getStaticInt((String)"devicetest.priority", (int)3);
    private Thread thread = null;
    private final Object stateChanged = new Object();
    private ConfigurationService configurationService = null;
    protected Dictionary deviceConfigurationInformation = null;
    private long startTime = System.currentTimeMillis();
    protected boolean configurationSave = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.adapter.test.AdapterTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        DEVICE_TEST_STATE_RESOURCE_TABLE = new int[]{4500, 4501, 4502, 4503, 4504, 4505};
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.soda.dk.adapter.test.AdapterTestResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelChanged(DeviceService source, Object timestamp, ChannelService channel, int newState, int oldState) {
        this.report(null, DEVICE_TEST_STATE_RESOURCE_TABLE[newState], Transport.STATE_STRINGS[oldState], channel);
        this.checkNotification();
        if (newState >= 5) {
            this.test();
        }
        Object object = this.stateChanged;
        synchronized (object) {
            this.stateChanged.notifyAll();
        }
    }

    public void checkNotification() {
        NotificationController notificationController;
        NotificationService notificationService;
        if (this.device != null && (notificationService = this.device.getNotificationService()) != null && (notificationController = this.getNotificationController()) == null) {
            this.setNotificationService(notificationService);
            this.register("*");
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, ChannelService channel, Object data) {
        if (data == null) {
            this.report(null, 4509, source, Nls.formatTimestamp((Object)timestamp), null);
        } else {
            this.report(null, 4510, source, Nls.formatTimestamp((Object)timestamp), data, null);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        if (data == null) {
            this.report(null, 4509, source, Nls.formatTimestamp((Object)timestamp), null);
        } else {
            this.report(null, 4510, source, Nls.formatTimestamp((Object)timestamp), data, null);
        }
    }

    public void controlChanged(DeviceService container, Object timestamp, ControlService control, int code) {
        this.report(null, 4525, control, Nls.formatTimestamp((Object)timestamp), AdapterTest.createInteger((int)code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceChanged(DeviceService deviceService, Object timestamp, int newState, int oldState) {
        this.report(null, DEVICE_TEST_STATE_RESOURCE_TABLE[newState], Transport.STATE_STRINGS[oldState], null);
        this.checkNotification();
        if (newState >= 5) {
            this.test();
        }
        Object object = this.stateChanged;
        synchronized (object) {
            this.stateChanged.notifyAll();
        }
    }

    public void deviceConfigurationCompare() {
        DeviceService device = this.getDevice();
        if (device != null) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>(101);
            Enumeration enumeration = device.elements();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof MeasurementService)) continue;
                MeasurementService measurement = (MeasurementService)object;
                String key = measurement.getKey();
                Object value = measurement.getValue();
                if (value == null || !(value instanceof String) && !(value instanceof Number) && !(value instanceof Boolean)) continue;
                ((Dictionary)dictionary).put(key, value);
            }
            this.setDeviceConfigurationInformation(dictionary);
            String className = this.getClass().getName();
            int index = className.lastIndexOf(46);
            if (index > 0) {
                String simpleName = className.substring(index + 1, className.length());
                InputStream cis = this.getClass().getResourceAsStream(String.valueOf(simpleName) + ".properties");
                if (cis != null) {
                    Properties properties = new Properties();
                    try {
                        BufferedInputStream is = new BufferedInputStream(cis);
                        properties.load(is);
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    Enumeration enumeration2 = ((Dictionary)dictionary).keys();
                    while (enumeration2.hasMoreElements()) {
                        Object key = enumeration2.nextElement();
                        if (key.equals("state")) continue;
                        Object configurationValue = properties.get(key);
                        Object value = ((Dictionary)dictionary).get(key);
                        if (configurationValue == null || value.equals(configurationValue) || value.toString().equals(configurationValue.toString())) continue;
                        this.report(null, 4527, key, configurationValue, value);
                    }
                }
            }
        }
    }

    public void deviceConfigurationSave() {
        String className;
        int index;
        Dictionary dictionary = this.getDeviceConfigurationInformation();
        if (dictionary != null && (index = (className = this.getClass().getName()).lastIndexOf(46)) > 0) {
            String simpleName = className.substring(index + 1, className.length());
            int size = dictionary.size();
            InputStream is = this.getClass().getResourceAsStream(String.valueOf(simpleName) + ".properties");
            if (is == null || this.isConfigurationSave()) {
                Object[] keys = new String[size];
                int i = 0;
                Enumeration enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    keys[i++] = String.valueOf(key);
                }
                Arrays.sort(keys);
                StringBuffer buffer = new StringBuffer(1024);
                Calendar calendar = Calendar.getInstance();
                int year = calendar.get(1);
                buffer.append(Nls.format((String)this.getCopyright(), (Object[])new Object[]{this.getVendor(), AdapterTest.createInteger((int)year)}));
                buffer.append("# Date: ");
                buffer.append(calendar.getTime());
                buffer.append('\r');
                buffer.append('\n');
                int j = 0;
                while (j < size) {
                    Object key = keys[j];
                    if (!((String)key).equals("state")) {
                        buffer.append((String)key);
                        buffer.append('=');
                        Object value = dictionary.get(key);
                        buffer.append(value);
                        buffer.append('\r');
                        buffer.append('\n');
                    }
                    ++j;
                }
                try {
                    StringBuffer cbuffer = new StringBuffer(1024);
                    cbuffer.append("src");
                    cbuffer.append('/');
                    cbuffer.append(className.replace('.', '/'));
                    cbuffer.append(".properties");
                    File file = new File(cbuffer.toString());
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(buffer.toString().getBytes());
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void endTests() {
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        this.report(null, 4506, Nls.formatTimestamp((Object)timestamp), data);
    }

    public void exit() {
        this.stop();
        this.setDevice(null);
    }

    public String formatData(Object data) {
        StringBuffer buffer = new StringBuffer(256);
        Nls.formatData((StringBuffer)buffer, (Object)data);
        return buffer.toString();
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        if (this.configurationService == null) {
            return null;
        }
        return this.getConfigurationInformation().get(propertyName);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public String getCopyright() {
        return "# (C) Copyright {0} Corp. {1} All Rights Reserved\r\n";
    }

    public AdapterService getDefaultAdapter() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    public DeviceService getDefaultDevice() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    public NotificationService getDefaultNotificationService() {
        return Notification.getBroker();
    }

    public DeviceService getDevice() {
        if (this.device != null) {
            return this.device;
        }
        AdapterService adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getDevice();
        }
        return null;
    }

    public Dictionary getDeviceConfigurationInformation() {
        return this.deviceConfigurationInformation;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 4506: 
            case 4516: 
            case 4517: 
            case 4518: 
            case 4519: 
            case 4520: 
            case 4521: 
            case 4522: 
            case 4527: {
                return 2;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public Object getLogDetails4() {
        TransportService transport = this.getTransport();
        ConnectionService connection = null;
        if (transport instanceof ConnectionTransportService) {
            connection = ((ConnectionTransportService)transport).getConnection();
        }
        return String.valueOf(connection);
    }

    public Object getLogDetails5() {
        return String.valueOf(this.getTransport());
    }

    public Object getLogDetails6() {
        return String.valueOf(this.getDevice());
    }

    public Object getLogDetails7() {
        return String.valueOf(this.getAdapter());
    }

    public int getPriority() {
        return this.priority;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(AdapterTestResourceBundle.getKey(resourceId));
        }
        catch (RuntimeException runtimeException) {
            return super.getResource(resourceId);
        }
    }

    public int getTestCount() {
        return this.testCount;
    }

    public long getTestDelay() {
        return this.testDelay;
    }

    public boolean getTestExecute() {
        return this.testExecute;
    }

    public boolean getTestExecuteRead() {
        return this.testExecuteRead;
    }

    public boolean getTestExecuteWrite() {
        return this.testExecuteWrite;
    }

    public boolean getTestRead() {
        return this.testRead;
    }

    public boolean getTestTrigger() {
        return this.testTrigger;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getTotalTestTime() {
        return this.totalTestTime;
    }

    public TransportService getTransport() {
        TransportService transport = null;
        DeviceService device = this.getDevice();
        if (device != null) {
            transport = device.getTransport();
        }
        return transport;
    }

    public String getVendor() {
        return "IBM";
    }

    public boolean isActive() {
        DeviceService device = this.getDevice();
        return this.active && device != null && device.getState() >= 5;
    }

    public boolean isConfigurationSave() {
        return this.configurationSave;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        this.report(null, 4511, source, Nls.formatTimestamp((Object)timestamp), newValue, oldValue, channel);
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.report(null, 4511, source, Nls.formatTimestamp((Object)timestamp), newValue, oldValue, null);
    }

    public void notificationReceived(String externalKey, Object data) {
        this.report(null, 4528, externalKey, Nls.formatTimestamp((Object)AdapterTest.getCurrentTimestamp()), data);
        super.notificationReceived(externalKey, data);
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    public void run() {
        this.checkNotification();
        this.waitForStarted();
        this.report(null, 4523, null);
        int testCount = this.getTestCount();
        this.startTests();
        int i = 0;
        while (i < testCount) {
            this.runTests();
            ++i;
        }
        this.endTests();
        long end = System.currentTimeMillis();
        this.report(null, 4524, AdapterTest.createNumber((long)(end - this.startTime)));
        this.deviceConfigurationCompare();
    }

    public void run(String[] arguments) {
        try {
            System.gc();
            System.gc();
            long timeStart = System.currentTimeMillis();
            long freeMemoryStart = Runtime.getRuntime().freeMemory();
            NotificationService notificationService = this.getDefaultNotificationService();
            this.setNotificationService(notificationService);
            this.register("*");
            AdapterService adapter = this.getDefaultAdapter();
            Hashtable<String, String> configurationInformation = new Hashtable<String, String>(101);
            configurationInformation.put("id", "T1");
            configurationInformation.put("prefix", "T1");
            adapter.setConfigurationInformation(configurationInformation);
            adapter.setNotificationService(notificationService);
            this.setAdapter(adapter);
            adapter.start();
            DeviceService deviceService = adapter.getDevice();
            if (deviceService != null) {
                this.setDevice(deviceService);
                deviceService.setConfigurationInformation(configurationInformation);
                deviceService.setNotificationService(notificationService);
                if (deviceService instanceof Device) {
                    Device device = (Device)deviceService;
                    device.setup();
                    TransportService transportService = deviceService.getTransport();
                    if (transportService != null) {
                        transportService.setConfigurationInformation(configurationInformation);
                        transportService.setNotificationService(notificationService);
                    }
                    deviceService.start();
                } else {
                    deviceService.start();
                    TransportService transportService = deviceService.getTransport();
                    if (transportService != null) {
                        transportService.setConfigurationInformation(configurationInformation);
                        transportService.setNotificationService(notificationService);
                    }
                }
            }
            this.sleep(this.getTotalTestTime());
            long timeEnd = System.currentTimeMillis();
            System.gc();
            System.gc();
            long freeMemoryEnd = Runtime.getRuntime().freeMemory();
            this.stop();
            if (deviceService != null) {
                deviceService.exit();
                TransportService transportService = deviceService.getTransport();
                if (transportService != null) {
                    transportService.exit();
                }
            }
            this.report(null, 4526, AdapterTest.createNumber((long)(timeEnd - timeStart)), AdapterTest.createNumber((long)(freeMemoryStart - freeMemoryEnd)));
            this.deviceConfigurationSave();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
    }

    public void runTests() {
        if (this.device != null) {
            this.checkNotification();
            Enumeration enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                this.waitForStarted();
                Object control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    this.testMeasurement(((MeasurementService)control).getKey());
                }
                if (control instanceof SignalService) {
                    this.testSignal(((SignalService)control).getKey());
                }
                if (control instanceof CommandService) {
                    this.testCommand(((CommandService)control).getKey());
                }
                this.sleep(10L);
            }
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAdapter(AdapterService adapter) {
        Object control;
        Enumeration enumeration;
        if (this.adapter != null) {
            this.adapter.removeDeviceListener((DeviceListener)this);
            enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    ((MeasurementService)control).removeMeasurementListener((MeasurementListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).removeSignalListener((SignalListener)this);
                }
                if (!(control instanceof CommandService)) continue;
                ((CommandService)control).removeCommandListener((CommandListener)this);
            }
            NotificationService notificationService = this.getNotificationService();
            if (notificationService != null) {
                this.unregister();
                this.setNotificationService(null);
            }
        }
        this.adapter = adapter;
        if (this.adapter != null) {
            this.adapter.addDeviceListener((DeviceListener)this);
            enumeration = this.adapter.elements();
            while (enumeration.hasMoreElements()) {
                control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    ((MeasurementService)control).addMeasurementListener((MeasurementListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).addSignalListener((SignalListener)this);
                }
                if (!(control instanceof CommandService)) continue;
                ((CommandService)control).addCommandListener((CommandListener)this);
            }
        }
        this.checkNotification();
        if (this.isActive()) {
            this.test();
        }
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        this.configurationService = new EscConfiguration(configurationInformation);
    }

    public void setConfigurationSave(boolean configurationSave) {
        this.configurationSave = configurationSave;
    }

    public void setDevice(DeviceService device) {
        Object control;
        Enumeration enumeration;
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
            enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    ((MeasurementService)control).removeMeasurementListener((MeasurementListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).removeSignalListener((SignalListener)this);
                }
                if (!(control instanceof CommandService)) continue;
                ((CommandService)control).removeCommandListener((CommandListener)this);
            }
            NotificationService notificationService = this.getNotificationService();
            if (notificationService != null) {
                this.unregister();
                this.setNotificationService(null);
            }
        }
        this.device = device;
        if (this.device != null) {
            this.device.addDeviceListener((DeviceListener)this);
            enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    ((MeasurementService)control).addMeasurementListener((MeasurementListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).addSignalListener((SignalListener)this);
                }
                if (!(control instanceof CommandService)) continue;
                ((CommandService)control).addCommandListener((CommandListener)this);
            }
        }
        this.checkNotification();
        if (this.isActive()) {
            this.test();
        }
    }

    public void setDeviceConfigurationInformation(Dictionary deviceConfigurationInformation) {
        this.deviceConfigurationInformation = deviceConfigurationInformation;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTestCount(int testCount) {
        this.testCount = testCount;
    }

    public void setTestDelay(long testDelay) {
        this.testDelay = testDelay;
    }

    public void setTestExecute(boolean testExecute) {
        this.testExecute = testExecute;
    }

    public void setTestExecuteRead(boolean testExecuteRead) {
        this.testExecuteRead = testExecuteRead;
    }

    public void setTestExecuteWrite(boolean testExecuteWrite) {
        this.testExecuteWrite = testExecuteWrite;
    }

    public void setTestRead(boolean testRead) {
        this.testRead = testRead;
    }

    public void setTestTrigger(boolean testTrigger) {
        this.testTrigger = testTrigger;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setTotalTestTime(long totalTestTime) {
        this.totalTestTime = totalTestTime;
    }

    public void setup() {
        this.setPriority(this.getInt("devicetest.priority", 3));
        this.setTotalTestTime(this.getLong("devicetest.totaltesttime", 60000L));
        this.setTotalTestTime(this.getLong("devicetest.readtimeout", 10000L));
        this.setTestCount(this.getInt("devicetest.testcount", 2));
        this.setTestDelay(this.getLong("devicetest.testdelay", 0L));
        this.setTestExecute(this.getBoolean("devicetest.testexecute", false));
        this.setTestExecuteRead(this.getBoolean("devicetest.testexecuteread", true));
        this.setTestExecuteWrite(this.getBoolean("devicetest.testexecutewrite", false));
        this.setTestRead(this.getBoolean("devicetest.testread", false));
        this.setTestTrigger(this.getBoolean("devicetest.testtrigger", false));
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        if (data == null) {
            this.report(null, 4507, source, Nls.formatTimestamp((Object)timestamp), channel);
        } else {
            this.report(null, 4508, source, Nls.formatTimestamp((Object)timestamp), data, channel);
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (data == null) {
            this.report(null, 4507, source, Nls.formatTimestamp((Object)timestamp), null);
        } else {
            this.report(null, 4508, source, Nls.formatTimestamp((Object)timestamp), data, null);
        }
    }

    public void start() {
        this.setup();
        this.setActive(true);
        if (this.getDevice() != null) {
            this.report(null, 4513, null);
            this.test();
        }
    }

    public void startTests() {
    }

    public void stop() {
        this.setActive(false);
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join(2000L);
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setThread(null);
        }
        this.report(null, 4514, null);
    }

    public void test() {
        Thread thread = this.getThread();
        if (thread == null) {
            this.setThread(new Thread((Runnable)this, String.valueOf(this.getOutputName())));
            this.getThread().setPriority(this.getPriority());
            this.getThread().start();
        } else if (!thread.isAlive()) {
            this.setThread(null);
        }
    }

    public void testCommand(String commandName) {
        if (this.isActive()) {
            try {
                CommandService command = this.getDevice().getCommand(commandName);
                if (command == null) {
                    this.report(null, 4517, commandName);
                } else if (this.getTestExecute() && this.isActive()) {
                    command.execute();
                }
            }
            catch (RuntimeException exception) {
                this.report(exception, 4520, commandName);
            }
        }
    }

    public void testMeasurement(String measurementName) {
        if (this.isActive()) {
            try {
                MeasurementService measurement = this.getDevice().getMeasurement(measurementName);
                if (measurement == null) {
                    this.report(null, 4518, measurementName);
                } else {
                    Object value;
                    if (this.getTestRead() && this.isActive()) {
                        value = measurement.read(this.getReadTimeout());
                        this.report(null, 4512, measurement, value);
                        this.broadcast(measurement + "/read", null);
                    }
                    if (this.getTestExecuteRead() && this.isActive()) {
                        measurement.executeRead();
                        this.broadcast(measurement + "/read", null);
                    }
                    value = measurement.getValue();
                    this.report(null, 4512, measurement, value);
                    this.broadcast(measurement + "/get", null);
                    if (value != null && this.getTestExecuteWrite() && this.isActive()) {
                        measurement.executeWrite(value);
                        Hashtable<String, Object> data = new Hashtable<String, Object>();
                        data.put("value", value);
                        this.broadcast(measurement + "/write", data);
                    }
                }
            }
            catch (RuntimeException exception) {
                this.report(exception, 4521, measurementName);
            }
        }
    }

    public void testSignal(String signalName) {
        if (this.isActive()) {
            try {
                SignalService signal = this.getDevice().getSignal(signalName);
                if (signal == null) {
                    this.report(null, 4519, signalName);
                } else if (this.getTestTrigger() && this.isActive()) {
                    signal.trigger();
                }
            }
            catch (RuntimeException exception) {
                this.report(exception, 4522, signalName);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        Dictionary configuration = this.getConfigurationInformation();
        if (configuration != null) {
            buffer.append(configuration);
        } else {
            buffer.append('{');
            buffer.append("testcount=");
            buffer.append(this.getTestCount());
            buffer.append(",testdelay=");
            buffer.append(this.getTestDelay());
            buffer.append(",totaltesttime=");
            buffer.append(this.getTotalTestTime());
            buffer.append('}');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStarted() {
        long startTime = System.currentTimeMillis();
        long waitTime = 1000L;
        while (!this.isActive() && this.getDevice() != null) {
            try {
                long currentTime = System.currentTimeMillis();
                Number time = AdapterTest.createNumber((long)(currentTime - startTime));
                this.report(null, 4515, time);
                Object object = this.stateChanged;
                synchronized (object) {
                    this.stateChanged.wait(waitTime);
                    if ((waitTime <<= 1) > this.getTotalTestTime()) {
                        waitTime = this.getTotalTestTime();
                    }
                }
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
    }
}

