/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.concrete.signal;

import org.eclipse.soda.dk.device.service.DeviceControl;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.signal.ParameterSignal;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class ConcreteSignal
extends ParameterSignal
implements DeviceControl,
ResponseListener {
    private DeviceService device;

    public ConcreteSignal(String key) {
        this(key, null, null, null);
    }

    public ConcreteSignal(String key, MessageService message, TransformService transform) {
        this(key, message, transform, null);
    }

    public ConcreteSignal(String key, MessageService message, TransformService transform, ParameterService parameter) {
        super(key, message, transform, parameter);
    }

    public Object encode(Object data) {
        TransformService transformService = this.getTransform();
        if (transformService == null) {
            return data;
        }
        return transformService.encode(data);
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public void noResponseReceived(TransportService transportService, ChannelService channel, Object timestamp, Object data) {
        this.fireErrorOccurred(timestamp, data);
    }

    public void responseReceived(TransportService transportService, ChannelService channel, Object timestamp, Object data) {
        this.messageReceived(transportService, timestamp, channel, (MessageService)data);
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }

    public void trigger() {
        this.trigger(null);
    }

    public void trigger(ChannelService channel) {
        this.getDevice().send(channel, this.getMessage(), (ResponseListener)this);
    }

    public void trigger(ChannelService channel, Object data) {
        if (data == null) {
            this.trigger(channel);
        } else {
            MessageService message = this.getMessage();
            try {
                Object writeData = this.encode(data);
                MessageService newMessage = (MessageService)message.clone();
                this.getDevice().send(channel, newMessage.encodeMessage(newMessage, this.getParameter(), writeData), (ResponseListener)this);
            }
            catch (CloneNotSupportedException exception) {
                this.handleError(exception, 3, message);
            }
        }
    }

    public void trigger(Object value) {
        this.trigger(null, value);
    }
}

