/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameters;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class MapParametersTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public MapParametersTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.MapParametersTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDecodeComplex() {
        SimpleParameter parameter3 = new SimpleParameter("Three", null, 3, 1, 1);
        SimpleParameter parameter4 = new SimpleParameter("Four", null, 4, 1, 1);
        MapParameters parameters2 = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter3, parameter4});
        SimpleParameter parameter = new SimpleParameter("One", null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter("Two", null, 2, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, parameters2});
        Message message = new Message(new byte[]{90, 10, 1, 2, 3});
        Object result = parameters.decodeValue((MessageService)message);
        MapParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof Map));
        Object value = ((Map)result).get(parameter.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(10), value);
        Object valueTwo = ((Map)result).get(parameterTwo.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(1), valueTwo);
        Object values2 = ((Map)result).get(parameters2.getKey());
        MapParametersTestcase.assertTrue((boolean)(values2 instanceof Map));
        Map map2 = (Map)values2;
        Object value3 = map2.get(parameter3.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(2), value3);
        Object value4 = map2.get(parameter4.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(3), value4);
    }

    public void testDecodeInteger() {
        SimpleParameter parameter = new SimpleParameter("One", null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter("Two", null, 2, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, 10, 1});
        Object result = parameters.decodeValue((MessageService)message);
        MapParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof Map));
        Object value = ((Map)result).get(parameter.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(10), value);
        Object valueTwo = ((Map)result).get(parameterTwo.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(1), valueTwo);
        System.out.println("result " + result);
    }

    public void testDecodeTrue() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 48);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        byArray[1] = 8;
        Message message = new Message(byArray);
        Object result = parameters.decodeValue((MessageService)message);
        MapParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof Map));
        Object value = ((Map)result).get(parameter.getKey());
        MapParametersTestcase.assertEquals((Object)Boolean.TRUE, value);
    }

    public void testEncodeComplex() {
        SimpleParameter parameter3 = new SimpleParameter("Three", null, 3, 1, 1);
        SimpleParameter parameter4 = new SimpleParameter("Four", null, 4, 1, 1);
        MapParameters parameters2 = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter3, parameter4});
        SimpleParameter parameter = new SimpleParameter("One", null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter("Two", null, 2, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, parameters2});
        byte[] byArray = new byte[5];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Hashtable<String, Serializable> values = new Hashtable<String, Serializable>();
        values.put(parameter.getKey(), new Integer(10));
        values.put(parameterTwo.getKey(), new Integer(1));
        Hashtable<String, Integer> values2 = new Hashtable<String, Integer>();
        values2.put(parameter3.getKey(), new Integer(2));
        values2.put(parameter4.getKey(), new Integer(3));
        values.put(parameters2.getKey(), values2);
        MessageService result = parameters.encodeValue((MessageService)message, values);
        byte[] resultBytes = result.getBytes();
        Message resultMessage = new Message(new byte[]{90, 10, 1, 2, 3});
        byte[] resultMessageBytes = resultMessage.getBytes();
        int i = 0;
        while (i < resultMessageBytes.length) {
            MapParametersTestcase.assertEquals((byte)resultMessageBytes[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeInteger() {
        SimpleParameter parameter = new SimpleParameter("One", null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter("Two", null, 2, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put(parameter.getKey(), new Integer(1));
        values.put(parameterTwo.getKey(), new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        MapParametersTestcase.assertEquals((byte)1, (byte)result.getBytes()[1]);
        MapParametersTestcase.assertEquals((byte)5, (byte)result.getBytes()[2]);
    }

    public void testEncodeInteger8() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put(parameter.getKey(), new Integer(2));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        MapParametersTestcase.assertEquals((byte)2, (byte)result.getBytes()[1]);
    }

    public void testEncodeLong() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 225);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[9];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        values.put(parameter.getKey(), new Long(Long.MAX_VALUE));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        MapParametersTestcase.assertEquals((byte)127, (byte)result.getBytes()[1]);
    }
}

