/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.AsciiMessage;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.FillStreamParameter;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.VariableListParameters;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class VariableListParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public VariableListParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.VariableListParameterTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDecodeInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, 10, 1});
        Object result = parameters.decodeValue((MessageService)message);
        VariableListParameterTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        VariableListParameterTestcase.assertEquals(value, (Object)new Integer(10));
        Object valueTwo = ((List)result).get(1);
        VariableListParameterTestcase.assertEquals(valueTwo, (Object)new Integer(1));
    }

    public void testDecodeIntegerCursor() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, -1, 1, 1);
        FillStreamParameter parameterFill = new FillStreamParameter(EMPTY_STRING, -1, 8);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, -1, 1, 1);
        SimpleParameter parameterThree = new SimpleParameter(EMPTY_STRING, null, -1, 2, 1);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterFill, parameterTwo, parameterThree}, 8);
        Message message = new Message(new byte[]{90, 10, -1, 1, 1, 2, 10, -1, 1, 1, 2});
        Object result = parameters.decodeValue((MessageService)message);
        VariableListParameterTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        VariableListParameterTestcase.assertEquals((Object)new Integer(10), value);
        Object valueTwo = ((List)result).get(1);
        VariableListParameterTestcase.assertEquals((Object)new Integer(1), valueTwo);
        Object valueThree = ((List)result).get(2);
        VariableListParameterTestcase.assertEquals((Object)new Integer(258), valueThree);
        byte[] byArray = new byte[11];
        byArray[0] = 90;
        byArray[2] = -1;
        byArray[7] = -1;
        Message emessage = new Message(byArray);
        MessageService smessage = parameters.encodeValue((MessageService)emessage, result);
        byte[] expectedBytes = message.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            VariableListParameterTestcase.assertEquals((byte)expectedBytes[i], (byte)smessage.getBytes()[i]);
            ++i;
        }
    }

    public void testEncodeInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(1));
        values.add(new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        VariableListParameterTestcase.assertEquals((byte)result.getBytes()[1], (byte)1);
        VariableListParameterTestcase.assertEquals((byte)result.getBytes()[2], (byte)5);
    }

    public void testEncodeInteger8() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(2));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        VariableListParameterTestcase.assertEquals((byte)result.getBytes()[1], (byte)2);
    }

    public void testEncodeIntegerCursor() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(1));
        values.add(new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        VariableListParameterTestcase.assertEquals((byte)90, (byte)result.getBytes()[0]);
        VariableListParameterTestcase.assertEquals((byte)1, (byte)result.getBytes()[1]);
        VariableListParameterTestcase.assertEquals((byte)5, (byte)result.getBytes()[2]);
    }

    public void testEncodeLong() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 225);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[9];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Vector<Long> values = new Vector<Long>();
        values.add(new Long(Long.MAX_VALUE));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        VariableListParameterTestcase.assertEquals((byte)result.getBytes()[1], (byte)127);
    }

    public void testEncodeString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        SimpleParameter parameterThree = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, parameterThree});
        AsciiMessage message = new AsciiMessage("09");
        Vector<String> values = new Vector<String>();
        values.add("abc");
        values.add(null);
        values.add("def");
        MessageService result = parameters.encodeValue((MessageService)message, values);
        VariableListParameterTestcase.assertEquals((int)result.getBytes()[1], (int)97);
        VariableListParameterTestcase.assertEquals((int)result.getBytes()[2], (int)98);
        VariableListParameterTestcase.assertEquals((String)new String(result.getBytes()), (String)"0abcdef9");
    }

    public void testEncodeVariable() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 0, 84);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Object> values = new Vector<Object>();
        values.add(new Integer(1));
        values.add(new byte[]{5, 6});
        MessageService result = parameters.encodeValue((MessageService)message, values);
        VariableListParameterTestcase.assertEquals((byte)90, (byte)result.getBytes()[0]);
        VariableListParameterTestcase.assertEquals((byte)1, (byte)result.getBytes()[1]);
        VariableListParameterTestcase.assertEquals((byte)5, (byte)result.getBytes()[2]);
        VariableListParameterTestcase.assertEquals((byte)6, (byte)result.getBytes()[3]);
        VariableListParameterTestcase.assertEquals((byte)-1, (byte)result.getBytes()[4]);
    }

    public void testEncodeVariable2() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 84);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 0, 84);
        VariableListParameters parameters = new VariableListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Message expected = new Message(new byte[]{90, 1, 2, -1, 5, 6, -1});
        Vector<byte[]> values = new Vector<byte[]>();
        values.add(new byte[]{1, 2});
        values.add(new byte[]{5, 6});
        MessageService result = parameters.encodeValue((MessageService)message, values);
        byte[] expectedBytes = expected.getBytes();
        int i = 0;
        while (i < expectedBytes.length) {
            VariableListParameterTestcase.assertEquals((byte)expectedBytes[i], (byte)result.getBytes()[i]);
            ++i;
        }
    }
}

