/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.message.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.TokenMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.FieldParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class TokenMessageTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public TokenMessageTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.message.testcase.TokenMessageTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testArray() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "0,1");
        TokenMessage message = new TokenMessage("123,456,789".getBytes(), null, (ParameterService)parameter, ",");
        Object result = parameter.decodeValue((MessageService)message);
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof Object[]));
        TokenMessageTestcase.assertEquals((Object)"123", (Object)((Object[])result)[0]);
        TokenMessageTestcase.assertEquals((Object)"456", (Object)((Object[])result)[1]);
    }

    public void testPlus() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "0+1+2");
        TokenMessage message = new TokenMessage("123,456,789".getBytes(), null, (ParameterService)parameter, ",");
        Object result = parameter.decodeValue((MessageService)message);
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof String));
        TokenMessageTestcase.assertEquals((Object)"123456789", (Object)result);
    }

    public void testSend() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "0");
        TokenMessage message = new TokenMessage("123,456".getBytes(), null, (ParameterService)parameter, ",");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"987");
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof TokenMessage));
        TokenMessageTestcase.assertEquals((String)"987,456", (String)String.valueOf(result));
    }

    public void testSendMore() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "2");
        TokenMessage message = new TokenMessage("123,456".getBytes(), null, (ParameterService)parameter, ",");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"789");
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof TokenMessage));
        TokenMessageTestcase.assertEquals((String)"123,456,789", (String)String.valueOf(result));
    }

    public void testSendMore4() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "4");
        TokenMessage message = new TokenMessage("123,456".getBytes(), null, (ParameterService)parameter, ",");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"789");
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof TokenMessage));
        TokenMessageTestcase.assertEquals((String)"123,456,,,789", (String)String.valueOf(result));
    }

    public void testTrue() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "0");
        TokenMessage message = new TokenMessage("123,456".getBytes(), null, (ParameterService)parameter, ",");
        Object result = parameter.decodeValue((MessageService)message);
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof String));
        TokenMessageTestcase.assertEquals((Object)"123", (Object)result);
    }

    public void testTrueTwo() {
        FieldParameter parameter = new FieldParameter(EMPTY_STRING, null, "1");
        TokenMessage message = new TokenMessage("123,456".getBytes(), null, (ParameterService)parameter, ",");
        Object result = parameter.decodeValue((MessageService)message);
        TokenMessageTestcase.assertEquals((boolean)true, (boolean)(result instanceof String));
        TokenMessageTestcase.assertEquals((Object)"456", (Object)result);
    }
}

