/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.OffsetParameter;

public class OffsetParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public OffsetParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.OffsetParameterTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDecodeBytesInteger() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 1, 1);
        Object result = parameter.decode((Object)new byte[]{90, 10, -1});
        OffsetParameterTestcase.assertEquals((Object)new Integer(1), (Object)result);
    }

    public void testDecodeInteger() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 1, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decode((Object)message);
        OffsetParameterTestcase.assertEquals((Object)new Integer(1), (Object)result);
    }

    public void testEncodeBytesInteger() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 2, 1);
        byte[] result = (byte[])parameter.encode((Object)new byte[]{90, -1, -1}, (Object)new Integer(2));
        OffsetParameterTestcase.assertEquals((byte)-5, (byte)result[1]);
    }

    public void testEncodeInteger() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 2, 1);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = (MessageService)parameter.encode((Object)message, (Object)new Integer(2));
        OffsetParameterTestcase.assertEquals((byte)-5, (byte)result.getBytes()[1]);
    }

    public void testEncodeInteger4() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 4, 1);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        OffsetParameterTestcase.assertEquals((byte)2, (byte)result.getBytes()[1]);
    }

    public void testEncodeInteger8() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 8, 1);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        OffsetParameterTestcase.assertEquals((byte)0, (byte)result.getBytes()[1]);
        OffsetParameterTestcase.assertEquals((byte)32, (byte)result.getBytes()[2]);
    }

    public void testEncodeInteger8a() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 8, 1);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        OffsetParameterTestcase.assertEquals((byte)-16, (byte)result.getBytes()[1]);
        OffsetParameterTestcase.assertEquals((byte)47, (byte)result.getBytes()[2]);
    }

    public void testEncodeValueInteger() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 2, 1);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        OffsetParameterTestcase.assertEquals((byte)-5, (byte)result.getBytes()[1]);
    }

    public void testInteger() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 1, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        OffsetParameterTestcase.assertEquals((Object)new Integer(1), (Object)result);
    }

    public void testInteger2() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 2, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        OffsetParameterTestcase.assertEquals((Object)new Integer(2), (Object)result);
    }

    public void testInteger4() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 4, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        OffsetParameterTestcase.assertEquals((Object)new Integer(10), (Object)result);
    }

    public void testInteger5() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 5, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        OffsetParameterTestcase.assertEquals((Object)new Integer(21), (Object)result);
    }

    public void testTrue() {
        OffsetParameter parameter = new OffsetParameter(EMPTY_STRING, null, 12, 1, 48);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        byArray[1] = 8;
        Message message = new Message(byArray);
        Object result = parameter.decodeValue((MessageService)message);
        OffsetParameterTestcase.assertEquals((Object)Boolean.TRUE, (Object)result);
    }
}

