/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.parameter.SimpleBooleanParameter;

public class BooleanParameter
extends SimpleBooleanParameter {
    private int length = 1;
    private int offset = Integer.MAX_VALUE;
    private long trueValue = 1L;
    private long falseValue = 0L;

    public BooleanParameter(String key) {
        super(key);
    }

    public BooleanParameter() {
        this("Boolean");
    }

    public BooleanParameter(String key, int length) {
        super(key);
        this.setLength(length);
    }

    public BooleanParameter(String key, int offset, int length) {
        super(key);
        this.setOffset(offset);
        this.setLength(length);
    }

    public BooleanParameter(String key, int offset, int length, long falseValue, long trueValue) {
        super(key);
        this.setOffset(offset);
        this.setLength(length);
        this.setFalseValue(falseValue);
        this.setTrueValue(trueValue);
    }

    public long getFalseValue() {
        if (this.falseValue != Long.MAX_VALUE) {
            return this.falseValue;
        }
        return this.getFalseValueDefault();
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getTrueValue() {
        if (this.trueValue != Long.MAX_VALUE) {
            return this.trueValue;
        }
        return this.getTrueValueDefault();
    }

    public void setFalseValue(long falseValue) {
        this.falseValue = falseValue;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setTrueValue(long trueValue) {
        this.trueValue = trueValue;
    }
}

