/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.ParameterCommand;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class MeasurementCommand
extends ParameterCommand {
    protected MeasurementService measurement = null;

    public MeasurementCommand(String key, MessageService message, TransformService transform, ParameterService parameter, MeasurementService measurement) {
        super(key, message, transform, parameter);
        this.setMeasurement(measurement);
    }

    public void execute(ChannelService channel) {
        MeasurementService measurement = this.getMeasurement();
        if (measurement == null) {
            super.execute(channel);
        } else {
            Object value = measurement.getValue(channel);
            if (value == null) {
                try {
                    value = measurement.read(channel, 1000L);
                    this.execute(channel, value);
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 1);
                }
            } else {
                this.execute(channel, value);
            }
        }
    }

    public MeasurementService getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(MeasurementService measurement) {
        this.measurement = measurement;
    }
}

